/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.services.android.telemetry.MapboxTelemetry;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;

class AttributionDialogManager
implements View.OnClickListener,
DialogInterface.OnClickListener {
    private static final String MAP_FEEDBACK_URL = "https://www.mapbox.com/map-feedback";
    private static final String MAP_FEEDBACK_LOCATION_FORMAT = "https://www.mapbox.com/map-feedback/#/%f/%f/%d";
    private final Context context;
    private final MapboxMap mapboxMap;
    private String[] attributionKeys;
    private HashMap<String, String> attributionMap;

    AttributionDialogManager(@NonNull Context context, @NonNull MapboxMap mapboxMap) {
        this.context = context;
        this.mapboxMap = mapboxMap;
    }

    public void onClick(View view) {
        this.attributionMap = new AttributionBuilder(this.context, this.mapboxMap).build();
        this.showAttributionDialog();
    }

    private void showAttributionDialog() {
        this.attributionKeys = this.attributionMap.keySet().toArray(new String[this.attributionMap.size()]);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context, R.style.mapbox_AlertDialogStyle);
        builder.setTitle(R.string.mapbox_attributionsDialogTitle);
        builder.setAdapter((ListAdapter)new ArrayAdapter(this.context, R.layout.mapbox_attribution_list_item, (Object[])this.attributionKeys), (DialogInterface.OnClickListener)this);
        builder.show();
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.isLatestEntry(which)) {
            this.showTelemetryDialog();
        } else {
            this.showMapFeedbackWebPage(which);
        }
    }

    private boolean isLatestEntry(int attributionKeyIndex) {
        return attributionKeyIndex == this.attributionKeys.length - 1;
    }

    private void showTelemetryDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context, R.style.mapbox_AlertDialogStyle);
        builder.setTitle(R.string.mapbox_attributionTelemetryTitle);
        builder.setMessage(R.string.mapbox_attributionTelemetryMessage);
        builder.setPositiveButton(R.string.mapbox_attributionTelemetryPositive, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MapboxTelemetry.getInstance().setTelemetryEnabled(true);
                dialog.cancel();
            }
        });
        builder.setNeutralButton(R.string.mapbox_attributionTelemetryNeutral, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AttributionDialogManager.this.showWebPage(AttributionDialogManager.this.context.getResources().getString(R.string.mapbox_telemetryLink));
                dialog.cancel();
            }
        });
        builder.setNegativeButton(R.string.mapbox_attributionTelemetryNegative, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MapboxTelemetry.getInstance().setTelemetryEnabled(false);
                dialog.cancel();
            }
        });
        builder.show();
    }

    private void showMapFeedbackWebPage(int which) {
        String url = this.attributionMap.get(this.attributionKeys[which]);
        if (url.contains(MAP_FEEDBACK_URL)) {
            url = this.buildMapFeedbackMapUrl(this.mapboxMap.getCameraPosition());
        }
        this.showWebPage(url);
    }

    private String buildMapFeedbackMapUrl(CameraPosition cameraPosition) {
        return cameraPosition != null ? String.format(Locale.getDefault(), MAP_FEEDBACK_LOCATION_FORMAT, cameraPosition.target.getLongitude(), cameraPosition.target.getLatitude(), (int)cameraPosition.zoom) : MAP_FEEDBACK_URL;
    }

    private void showWebPage(@NonNull String url) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            this.context.startActivity(intent);
        }
        catch (ActivityNotFoundException exception) {
            Toast.makeText((Context)this.context, (int)R.string.mapbox_attributionErrorNoBrowser, (int)1).show();
        }
    }

    private static class AttributionBuilder {
        private final HashMap<String, String> map = new LinkedHashMap<String, String>();
        private final Context context;
        private final MapboxMap mapboxMap;

        AttributionBuilder(Context context, MapboxMap mapboxMap) {
            this.context = context.getApplicationContext();
            this.mapboxMap = mapboxMap;
        }

        private HashMap<String, String> build() {
            for (Source source : this.mapboxMap.getSources()) {
                this.parseAttribution(source.getAttribution());
            }
            this.addTelemetryEntryToAttributionMap();
            return this.map;
        }

        private void parseAttribution(String attributionSource) {
            if (!TextUtils.isEmpty((CharSequence)attributionSource)) {
                URLSpan[] urlSpans;
                SpannableStringBuilder htmlBuilder = (SpannableStringBuilder)Html.fromHtml((String)attributionSource);
                for (URLSpan urlSpan : urlSpans = (URLSpan[])htmlBuilder.getSpans(0, htmlBuilder.length(), URLSpan.class)) {
                    this.map.put(this.resolveAnchorValue(htmlBuilder, urlSpan), urlSpan.getURL());
                }
            }
        }

        private String resolveAnchorValue(SpannableStringBuilder htmlBuilder, URLSpan urlSpan) {
            int start = htmlBuilder.getSpanStart((Object)urlSpan);
            int end = htmlBuilder.getSpanEnd((Object)urlSpan);
            int length = end - start;
            char[] charKey = new char[length];
            htmlBuilder.getChars(start, end, charKey, 0);
            return String.valueOf(charKey);
        }

        private void addTelemetryEntryToAttributionMap() {
            String telemetryKey = this.context.getString(R.string.mapbox_telemetrySettings);
            String telemetryLink = this.context.getString(R.string.mapbox_telemetryLink);
            this.map.put(telemetryKey, telemetryLink);
        }
    }
}

