/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import android.view.View;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.BaseMarkerViewOptions;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.annotations.MarkerViewManager;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.maps.IconManager;
import com.mapbox.mapboxsdk.maps.InfoWindowManager;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.services.commons.geojson.Feature;
import java.util.ArrayList;
import java.util.List;
import timber.log.Timber;

class AnnotationManager {
    private static final String LAYER_ID_SHAPE_ANNOTATIONS = "com.mapbox.annotations.shape.";
    private static final long NO_ANNOTATION_ID = -1L;
    private final NativeMapView nativeMapView;
    private final MapView mapView;
    private final IconManager iconManager;
    private final InfoWindowManager infoWindowManager = new InfoWindowManager();
    private final MarkerViewManager markerViewManager;
    private final LongSparseArray<Annotation> annotations = new LongSparseArray();
    private final List<Marker> selectedMarkers = new ArrayList<Marker>();
    private final List<String> shapeAnnotationIds = new ArrayList<String>();
    private MapboxMap mapboxMap;
    private MapboxMap.OnMarkerClickListener onMarkerClickListener;
    private MapboxMap.OnPolygonClickListener onPolygonClickListener;
    private MapboxMap.OnPolylineClickListener onPolylineClickListener;

    AnnotationManager(NativeMapView view, MapView mapView, MarkerViewManager markerViewManager) {
        this.nativeMapView = view;
        this.mapView = mapView;
        this.iconManager = new IconManager(this.nativeMapView);
        this.markerViewManager = markerViewManager;
        if (view != null) {
            view.addOnMapChangedListener(markerViewManager);
        }
    }

    AnnotationManager bind(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
        this.markerViewManager.bind(mapboxMap);
        return this;
    }

    void update() {
        this.markerViewManager.update();
        this.infoWindowManager.update();
    }

    Annotation getAnnotation(long id2) {
        return (Annotation)this.annotations.get(id2);
    }

    List<Annotation> getAnnotations() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            annotations.add((Annotation)this.annotations.get(this.annotations.keyAt(i)));
        }
        return annotations;
    }

    void removeAnnotation(@NonNull Annotation annotation) {
        if (annotation instanceof Marker) {
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (this.selectedMarkers.contains(marker)) {
                this.selectedMarkers.remove(marker);
            }
            if (marker instanceof MarkerView) {
                this.markerViewManager.removeMarkerView((MarkerView)marker);
            }
        } else {
            this.shapeAnnotationIds.remove(annotation.getId());
        }
        long id2 = annotation.getId();
        if (this.nativeMapView != null) {
            this.nativeMapView.removeAnnotation(id2);
        }
        this.annotations.remove(id2);
    }

    void removeAnnotation(long id2) {
        if (this.nativeMapView != null) {
            this.nativeMapView.removeAnnotation(id2);
        }
        this.annotations.remove(id2);
    }

    void removeAnnotations(@NonNull List<? extends Annotation> annotationList) {
        int count = annotationList.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (annotation instanceof Marker) {
                Marker marker = (Marker)annotation;
                marker.hideInfoWindow();
                if (this.selectedMarkers.contains(marker)) {
                    this.selectedMarkers.remove(marker);
                }
                if (marker instanceof MarkerView) {
                    this.markerViewManager.removeMarkerView((MarkerView)marker);
                }
            } else {
                this.shapeAnnotationIds.remove(annotation.getId());
            }
            ids[i] = annotationList.get(i).getId();
        }
        if (this.nativeMapView != null) {
            this.nativeMapView.removeAnnotations(ids);
        }
        for (long id2 : ids) {
            this.annotations.remove(id2);
        }
    }

    void removeAnnotations() {
        int count = this.annotations.size();
        long[] ids = new long[count];
        this.selectedMarkers.clear();
        for (int i = 0; i < count; ++i) {
            ids[i] = this.annotations.keyAt(i);
            Annotation annotation = (Annotation)this.annotations.get(ids[i]);
            if (annotation instanceof Marker) {
                Marker marker = (Marker)annotation;
                marker.hideInfoWindow();
                if (!(marker instanceof MarkerView)) continue;
                this.markerViewManager.removeMarkerView((MarkerView)marker);
                continue;
            }
            this.shapeAnnotationIds.remove(annotation.getId());
        }
        if (this.nativeMapView != null) {
            this.nativeMapView.removeAnnotations(ids);
        }
        this.annotations.clear();
    }

    Marker addMarker(@NonNull BaseMarkerOptions markerOptions, @NonNull MapboxMap mapboxMap) {
        Marker marker = this.prepareMarker(markerOptions);
        long id2 = this.nativeMapView != null ? this.nativeMapView.addMarker(marker) : 0L;
        marker.setMapboxMap(mapboxMap);
        marker.setId(id2);
        this.annotations.put(id2, (Object)marker);
        return marker;
    }

    List<Marker> addMarkers(@NonNull List<? extends BaseMarkerOptions> markerOptionsList, @NonNull MapboxMap mapboxMap) {
        int count = markerOptionsList.size();
        ArrayList<Marker> markers = new ArrayList<Marker>(count);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                BaseMarkerOptions markerOptions = markerOptionsList.get(i);
                Marker marker = this.prepareMarker(markerOptions);
                markers.add(marker);
            }
            if (markers.size() > 0) {
                long[] ids = this.nativeMapView != null ? this.nativeMapView.addMarkers(markers) : new long[markers.size()];
                for (int i = 0; i < ids.length; ++i) {
                    Marker m = (Marker)markers.get(i);
                    m.setMapboxMap(mapboxMap);
                    long id2 = ids[i];
                    m.setId(id2);
                    this.annotations.put(id2, (Object)m);
                }
            }
        }
        return markers;
    }

    private Marker prepareMarker(BaseMarkerOptions markerOptions) {
        Object marker = markerOptions.getMarker();
        Icon icon = this.iconManager.loadIconForMarker((Marker)marker);
        ((Marker)marker).setTopOffsetPixels(this.iconManager.getTopOffsetPixelsForIcon(icon));
        return marker;
    }

    MarkerView addMarker(@NonNull BaseMarkerViewOptions markerOptions, @NonNull MapboxMap mapboxMap, @Nullable MarkerViewManager.OnMarkerViewAddedListener onMarkerViewAddedListener) {
        MarkerView marker = this.prepareViewMarker(markerOptions);
        marker.setMapboxMap(mapboxMap);
        long id2 = this.nativeMapView.addMarker(marker);
        marker.setId(id2);
        this.annotations.put(id2, (Object)marker);
        if (onMarkerViewAddedListener != null) {
            this.markerViewManager.addOnMarkerViewAddedListener(marker, onMarkerViewAddedListener);
        }
        this.markerViewManager.setEnabled(true);
        this.markerViewManager.setWaitingForRenderInvoke(true);
        return marker;
    }

    List<MarkerView> addMarkerViews(@NonNull List<? extends BaseMarkerViewOptions> markerViewOptions, @NonNull MapboxMap mapboxMap) {
        ArrayList<MarkerView> markers = new ArrayList<MarkerView>();
        for (BaseMarkerViewOptions baseMarkerViewOptions : markerViewOptions) {
            if (markerViewOptions.indexOf(baseMarkerViewOptions) == markerViewOptions.size() - 1) {
                this.markerViewManager.setWaitingForRenderInvoke(true);
            }
            MarkerView marker = this.prepareViewMarker(baseMarkerViewOptions);
            marker.setMapboxMap(mapboxMap);
            long id2 = this.nativeMapView.addMarker(marker);
            marker.setId(id2);
            this.annotations.put(id2, (Object)marker);
            markers.add(marker);
        }
        this.markerViewManager.setEnabled(true);
        this.markerViewManager.update();
        return markers;
    }

    private MarkerView prepareViewMarker(BaseMarkerViewOptions markerViewOptions) {
        Object marker = markerViewOptions.getMarker();
        this.iconManager.loadIconForMarkerView((MarkerView)marker);
        return marker;
    }

    void updateMarker(@NonNull Marker updatedMarker) {
        if (!this.isAddedToMap(updatedMarker)) {
            Timber.w((String)"Attempting to update non-added Marker with value %s", (Object[])new Object[]{updatedMarker});
            return;
        }
        this.ensureIconLoaded(updatedMarker);
        this.nativeMapView.updateMarker(updatedMarker);
        this.annotations.setValueAt(this.annotations.indexOfKey(updatedMarker.getId()), (Object)updatedMarker);
    }

    private boolean isAddedToMap(Annotation annotation) {
        return annotation != null && annotation.getId() != -1L && this.annotations.indexOfKey(annotation.getId()) > -1;
    }

    private void ensureIconLoaded(Marker marker) {
        if (!(marker instanceof MarkerView)) {
            this.iconManager.ensureIconLoaded(marker, this.mapboxMap);
        }
    }

    List<Marker> getMarkers() {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Marker)) continue;
            markers.add((Marker)annotation);
        }
        return markers;
    }

    void setOnMarkerClickListener(@Nullable MapboxMap.OnMarkerClickListener listener) {
        this.onMarkerClickListener = listener;
    }

    void setOnPolygonClickListener(@Nullable MapboxMap.OnPolygonClickListener listener) {
        this.onPolygonClickListener = listener;
    }

    void setOnPolylineClickListener(@Nullable MapboxMap.OnPolylineClickListener listener) {
        this.onPolylineClickListener = listener;
    }

    void selectMarker(@NonNull Marker marker) {
        if (this.selectedMarkers.contains(marker)) {
            return;
        }
        if (!this.infoWindowManager.isAllowConcurrentMultipleOpenInfoWindows()) {
            this.deselectMarkers();
        }
        if (marker instanceof MarkerView) {
            this.markerViewManager.select((MarkerView)marker, false);
            this.markerViewManager.ensureInfoWindowOffset((MarkerView)marker);
        }
        if (this.infoWindowManager.isInfoWindowValidForMarker(marker) || this.infoWindowManager.getInfoWindowAdapter() != null) {
            this.infoWindowManager.add(marker.showInfoWindow(this.mapboxMap, this.mapView));
        }
        this.selectedMarkers.add(marker);
    }

    void deselectMarkers() {
        if (this.selectedMarkers.isEmpty()) {
            return;
        }
        for (Marker marker : this.selectedMarkers) {
            if (marker.isInfoWindowShown()) {
                marker.hideInfoWindow();
            }
            if (!(marker instanceof MarkerView)) continue;
            this.markerViewManager.deselect((MarkerView)marker, false);
        }
        this.selectedMarkers.clear();
    }

    void deselectMarker(@NonNull Marker marker) {
        if (!this.selectedMarkers.contains(marker)) {
            return;
        }
        if (marker.isInfoWindowShown()) {
            marker.hideInfoWindow();
        }
        if (marker instanceof MarkerView) {
            this.markerViewManager.deselect((MarkerView)marker, false);
        }
        this.selectedMarkers.remove(marker);
    }

    List<Marker> getSelectedMarkers() {
        return this.selectedMarkers;
    }

    @NonNull
    List<Marker> getMarkersInRect(@NonNull RectF rectangle) {
        float pixelRatio = this.nativeMapView.getPixelRatio();
        RectF rect = new RectF(rectangle.left / pixelRatio, rectangle.top / pixelRatio, rectangle.right / pixelRatio, rectangle.bottom / pixelRatio);
        long[] ids = this.nativeMapView.queryPointAnnotations(rect);
        ArrayList<Long> idsList = new ArrayList<Long>(ids.length);
        for (long id2 : ids) {
            idsList.add(id2);
        }
        ArrayList<Marker> annotations = new ArrayList<Marker>(ids.length);
        List<Annotation> annotationList = this.getAnnotations();
        int count = annotationList.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (!(annotation instanceof Marker) || !idsList.contains(annotation.getId())) continue;
            annotations.add((Marker)annotation);
        }
        return new ArrayList<Marker>(annotations);
    }

    List<MarkerView> getMarkerViewsInRect(@NonNull RectF rectangle) {
        float pixelRatio = this.nativeMapView.getPixelRatio();
        RectF rect = new RectF(rectangle.left / pixelRatio, rectangle.top / pixelRatio, rectangle.right / pixelRatio, rectangle.bottom / pixelRatio);
        long[] ids = this.nativeMapView.queryPointAnnotations(rect);
        ArrayList<Long> idsList = new ArrayList<Long>(ids.length);
        for (long id2 : ids) {
            idsList.add(id2);
        }
        ArrayList<MarkerView> annotations = new ArrayList<MarkerView>(ids.length);
        List<Annotation> annotationList = this.getAnnotations();
        int count = annotationList.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (!(annotation instanceof MarkerView) || !idsList.contains(annotation.getId())) continue;
            annotations.add((MarkerView)annotation);
        }
        return new ArrayList<MarkerView>(annotations);
    }

    Polygon addPolygon(@NonNull PolygonOptions polygonOptions, @NonNull MapboxMap mapboxMap) {
        Polygon polygon = polygonOptions.getPolygon();
        if (!polygon.getPoints().isEmpty()) {
            long id2 = this.nativeMapView != null ? this.nativeMapView.addPolygon(polygon) : 0L;
            polygon.setId(id2);
            polygon.setMapboxMap(mapboxMap);
            this.shapeAnnotationIds.add(LAYER_ID_SHAPE_ANNOTATIONS + id2);
            this.annotations.put(id2, (Object)polygon);
        }
        return polygon;
    }

    List<Polygon> addPolygons(@NonNull List<PolygonOptions> polygonOptionsList, @NonNull MapboxMap mapboxMap) {
        int count = polygonOptionsList.size();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(count);
        if (count > 0) {
            Polygon polygon;
            for (PolygonOptions polygonOptions : polygonOptionsList) {
                polygon = polygonOptions.getPolygon();
                if (polygon.getPoints().isEmpty()) continue;
                polygons.add(polygon);
            }
            long[] ids = this.nativeMapView != null ? this.nativeMapView.addPolygons(polygons) : new long[polygons.size()];
            for (int i = 0; i < ids.length; ++i) {
                polygon = (Polygon)polygons.get(i);
                polygon.setMapboxMap(mapboxMap);
                long id2 = ids[i];
                polygon.setId(id2);
                this.shapeAnnotationIds.add(LAYER_ID_SHAPE_ANNOTATIONS + id2);
                this.annotations.put(id2, (Object)polygon);
            }
        }
        return polygons;
    }

    void updatePolygon(@NonNull Polygon polygon) {
        if (!this.isAddedToMap(polygon)) {
            Timber.w((String)"Attempting to update non-added Polygon with value %s", (Object[])new Object[]{polygon});
            return;
        }
        this.nativeMapView.updatePolygon(polygon);
        this.annotations.setValueAt(this.annotations.indexOfKey(polygon.getId()), (Object)polygon);
    }

    List<Polygon> getPolygons() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Polygon)) continue;
            polygons.add((Polygon)annotation);
        }
        return polygons;
    }

    Polyline addPolyline(@NonNull PolylineOptions polylineOptions, @NonNull MapboxMap mapboxMap) {
        Polyline polyline = polylineOptions.getPolyline();
        if (!polyline.getPoints().isEmpty()) {
            long id2 = this.nativeMapView != null ? this.nativeMapView.addPolyline(polyline) : 0L;
            polyline.setMapboxMap(mapboxMap);
            polyline.setId(id2);
            this.shapeAnnotationIds.add(LAYER_ID_SHAPE_ANNOTATIONS + id2);
            this.annotations.put(id2, (Object)polyline);
        }
        return polyline;
    }

    List<Polyline> addPolylines(@NonNull List<PolylineOptions> polylineOptionsList, @NonNull MapboxMap mapboxMap) {
        int count = polylineOptionsList.size();
        ArrayList<Polyline> polylines = new ArrayList<Polyline>(count);
        if (count > 0) {
            for (PolylineOptions options : polylineOptionsList) {
                Polyline polyline = options.getPolyline();
                if (polyline.getPoints().isEmpty()) continue;
                polylines.add(polyline);
            }
            long[] ids = this.nativeMapView != null ? this.nativeMapView.addPolylines(polylines) : new long[polylines.size()];
            for (int i = 0; i < ids.length; ++i) {
                Polyline p = (Polyline)polylines.get(i);
                p.setMapboxMap(mapboxMap);
                long id2 = ids[i];
                p.setId(id2);
                this.shapeAnnotationIds.add(LAYER_ID_SHAPE_ANNOTATIONS + id2);
                this.annotations.put(id2, (Object)p);
            }
        }
        return polylines;
    }

    void updatePolyline(@NonNull Polyline polyline) {
        if (!this.isAddedToMap(polyline)) {
            Timber.w((String)"Attempting to update non-added Polyline with value %s", (Object[])new Object[]{polyline});
            return;
        }
        this.nativeMapView.updatePolyline(polyline);
        this.annotations.setValueAt(this.annotations.indexOfKey(polyline.getId()), (Object)polyline);
    }

    List<Polyline> getPolylines() {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Polyline)) continue;
            polylines.add((Polyline)annotation);
        }
        return polylines;
    }

    InfoWindowManager getInfoWindowManager() {
        return this.infoWindowManager;
    }

    MarkerViewManager getMarkerViewManager() {
        return this.markerViewManager;
    }

    void adjustTopOffsetPixels(MapboxMap mapboxMap) {
        int count = this.annotations.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = (Annotation)this.annotations.get((long)i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.setTopOffsetPixels(this.iconManager.getTopOffsetPixelsForIcon(marker.getIcon()));
        }
        for (Marker marker : this.selectedMarkers) {
            if (!marker.isInfoWindowShown()) continue;
            marker.hideInfoWindow();
            marker.showInfoWindow(mapboxMap, this.mapView);
        }
    }

    void reloadMarkers() {
        this.iconManager.reloadIcons();
        int count = this.annotations.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = (Annotation)this.annotations.get((long)i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            this.nativeMapView.removeAnnotation(annotation.getId());
            long newId = this.nativeMapView.addMarker(marker);
            marker.setId(newId);
        }
    }

    boolean onTap(PointF tapPoint) {
        MarkerHit markerHit;
        long markerId;
        ShapeAnnotationHit shapeAnnotationHit;
        long shapeAnnotationId;
        if (!this.shapeAnnotationIds.isEmpty() && (shapeAnnotationId = new ShapeAnnotationHitResolver(this.mapboxMap).execute(shapeAnnotationHit = this.getShapeAnnotationHitFromTap(tapPoint))) != -1L) {
            this.handleClickForShapeAnnotation(shapeAnnotationId);
        }
        return (markerId = new MarkerHitResolver(this.mapboxMap).execute(markerHit = this.getMarkerHitFromTouchArea(tapPoint))) != -1L && this.isClickHandledForMarker(markerId);
    }

    private ShapeAnnotationHit getShapeAnnotationHitFromTap(PointF tapPoint) {
        float touchTargetSide = Mapbox.getApplicationContext().getResources().getDimension(R.dimen.mapbox_eight_dp);
        RectF tapRect = new RectF(tapPoint.x - touchTargetSide, tapPoint.y - touchTargetSide, tapPoint.x + touchTargetSide, tapPoint.y + touchTargetSide);
        return new ShapeAnnotationHit(tapRect, this.shapeAnnotationIds.toArray(new String[this.shapeAnnotationIds.size()]));
    }

    private void handleClickForShapeAnnotation(long shapeAnnotationId) {
        Annotation annotation = this.getAnnotation(shapeAnnotationId);
        if (annotation instanceof Polygon && this.onPolygonClickListener != null) {
            this.onPolygonClickListener.onPolygonClick((Polygon)annotation);
        } else if (annotation instanceof Polyline && this.onPolylineClickListener != null) {
            this.onPolylineClickListener.onPolylineClick((Polyline)annotation);
        }
    }

    private MarkerHit getMarkerHitFromTouchArea(PointF tapPoint) {
        int touchSurfaceWidth = (int)((double)this.iconManager.getHighestIconHeight() * 1.5);
        int touchSurfaceHeight = (int)((double)this.iconManager.getHighestIconWidth() * 1.5);
        RectF tapRect = new RectF(tapPoint.x - (float)touchSurfaceWidth, tapPoint.y - (float)touchSurfaceHeight, tapPoint.x + (float)touchSurfaceWidth, tapPoint.y + (float)touchSurfaceHeight);
        return new MarkerHit(tapRect, this.getMarkersInRect(tapRect));
    }

    private boolean isClickHandledForMarker(long markerId) {
        Marker marker = (Marker)this.getAnnotation(markerId);
        boolean handledDefaultClick = marker instanceof MarkerView ? this.markerViewManager.onClickMarkerView((MarkerView)marker) : this.onClickMarker(marker);
        if (!handledDefaultClick) {
            this.toggleMarkerSelectionState(marker);
        }
        return true;
    }

    private boolean onClickMarker(Marker marker) {
        return this.onMarkerClickListener != null && this.onMarkerClickListener.onMarkerClick(marker);
    }

    private void toggleMarkerSelectionState(Marker marker) {
        if (!this.selectedMarkers.contains(marker)) {
            this.selectMarker(marker);
        } else {
            this.deselectMarker(marker);
        }
    }

    private static class MarkerHit {
        private final RectF tapRect;
        private final List<Marker> markers;

        MarkerHit(RectF tapRect, List<Marker> markers) {
            this.tapRect = tapRect;
            this.markers = markers;
        }

        float getTapPointX() {
            return this.tapRect.centerX();
        }

        float getTapPointY() {
            return this.tapRect.centerY();
        }
    }

    private static class ShapeAnnotationHit {
        private final RectF tapPoint;
        private final String[] layerIds;

        ShapeAnnotationHit(RectF tapRect, String[] layerIds) {
            this.tapPoint = tapRect;
            this.layerIds = layerIds;
        }
    }

    private static class MarkerHitResolver {
        private final MarkerViewManager markerViewManager;
        private final Projection projection;
        private View view;
        private Bitmap bitmap;
        private PointF markerLocation;
        private Rect hitRectView = new Rect();
        private RectF hitRectMarker = new RectF();
        private RectF highestSurfaceIntersection = new RectF();
        private long closestMarkerId = -1L;

        MarkerHitResolver(@NonNull MapboxMap mapboxMap) {
            this.markerViewManager = mapboxMap.getMarkerViewManager();
            this.projection = mapboxMap.getProjection();
        }

        public long execute(MarkerHit markerHit) {
            this.resolveForMarkers(markerHit);
            return this.closestMarkerId;
        }

        private void resolveForMarkers(MarkerHit markerHit) {
            for (Marker marker : markerHit.markers) {
                if (marker instanceof MarkerView) {
                    this.resolveForMarkerView(markerHit, (MarkerView)marker);
                    continue;
                }
                this.resolveForMarker(markerHit, marker);
            }
        }

        private void resolveForMarkerView(MarkerHit markerHit, MarkerView markerView) {
            this.view = this.markerViewManager.getView(markerView);
            if (this.view != null) {
                this.view.getHitRect(this.hitRectView);
                this.hitRectMarker = new RectF(this.hitRectView);
                this.hitTestMarker(markerHit, markerView, this.hitRectMarker);
            }
        }

        private void resolveForMarker(MarkerHit markerHit, Marker marker) {
            this.markerLocation = this.projection.toScreenLocation(marker.getPosition());
            this.bitmap = marker.getIcon().getBitmap();
            this.hitRectMarker.set(0.0f, 0.0f, (float)this.bitmap.getWidth(), (float)this.bitmap.getHeight());
            this.hitRectMarker.offsetTo(this.markerLocation.x - (float)(this.bitmap.getWidth() / 2), this.markerLocation.y - (float)(this.bitmap.getHeight() / 2));
            this.hitTestMarker(markerHit, marker, this.hitRectMarker);
        }

        private void hitTestMarker(MarkerHit markerHit, Marker marker, RectF hitRectMarker) {
            if (hitRectMarker.contains(markerHit.getTapPointX(), markerHit.getTapPointY())) {
                hitRectMarker.intersect(markerHit.tapRect);
                if (this.isRectangleHighestSurfaceIntersection(hitRectMarker)) {
                    this.highestSurfaceIntersection = new RectF(hitRectMarker);
                    this.closestMarkerId = marker.getId();
                }
            }
        }

        private boolean isRectangleHighestSurfaceIntersection(RectF rectF) {
            return rectF.width() * rectF.height() > this.highestSurfaceIntersection.width() * this.highestSurfaceIntersection.height();
        }
    }

    private static class ShapeAnnotationHitResolver {
        private MapboxMap mapboxMap;

        ShapeAnnotationHitResolver(MapboxMap mapboxMap) {
            this.mapboxMap = mapboxMap;
        }

        public long execute(ShapeAnnotationHit shapeHit) {
            long foundAnnotationId = -1L;
            List<Feature> features = this.mapboxMap.queryRenderedFeatures(shapeHit.tapPoint, shapeHit.layerIds);
            if (!features.isEmpty()) {
                foundAnnotationId = this.getIdFromFeature(features.get(0));
            }
            return foundAnnotationId;
        }

        private long getIdFromFeature(Feature feature) {
            try {
                return Long.valueOf(feature.getId());
            }
            catch (NumberFormatException exception) {
                Timber.e((Throwable)exception, (String)"Couldn't parse feature id to a long, with id: %s", (Object[])new Object[]{feature.getId()});
                return -1L;
            }
        }
    }
}

