/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;

public class MapFragmentUtils {
    public static Bundle createFragmentArgs(MapboxMapOptions options) {
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapboxMapOptions", (Parcelable)options);
        return bundle;
    }

    public static MapboxMapOptions resolveArgs(Context context, Bundle args) {
        MapboxMapOptions options = args != null && args.containsKey("MapboxMapOptions") ? (MapboxMapOptions)args.getParcelable("MapboxMapOptions") : MapboxMapOptions.createFromAttributes(context, null);
        options = MapFragmentUtils.loadDefaultMyLocationViewDrawables(context, options);
        return options;
    }

    private static MapboxMapOptions loadDefaultMyLocationViewDrawables(Context context, MapboxMapOptions options) {
        Drawable foregroundDrawable = options.getMyLocationForegroundDrawable();
        Drawable foregroundBearingDrawable = options.getMyLocationForegroundBearingDrawable();
        if (foregroundDrawable == null || foregroundBearingDrawable == null) {
            if (foregroundDrawable == null) {
                foregroundDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.mapbox_mylocation_icon_default);
            }
            if (foregroundBearingDrawable == null) {
                foregroundBearingDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.mapbox_mylocation_icon_bearing);
            }
            options.myLocationForegroundDrawables(foregroundDrawable, foregroundBearingDrawable);
        }
        if (options.getMyLocationBackgroundDrawable() == null) {
            options.myLocationBackgroundDrawable(ContextCompat.getDrawable((Context)context, (int)R.drawable.mapbox_mylocation_bg_shape));
        }
        return options;
    }
}

