/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import java.util.ArrayList;
import java.util.Collections;

public class Filter {
    public static Statement all(Statement ... statements) {
        return new CompoundStatement("all", statements);
    }

    public static Statement any(Statement ... statements) {
        return new CompoundStatement("any", statements);
    }

    public static Statement none(Statement ... statements) {
        return new CompoundStatement("none", statements);
    }

    public static Statement has(String key) {
        return new SimpleStatement("has", key, new Object[0]);
    }

    public static Statement notHas(String key) {
        return new SimpleStatement("!has", key, new Object[0]);
    }

    public static Statement eq(String key, Object value) {
        return new SimpleStatement("==", key, value);
    }

    public static Statement neq(String key, Object value) {
        return new SimpleStatement("!=", key, value);
    }

    public static Statement gt(String key, Object value) {
        return new SimpleStatement(">", key, value);
    }

    public static Statement gte(String key, Object value) {
        return new SimpleStatement(">=", key, value);
    }

    public static Statement lt(String key, Object value) {
        return new SimpleStatement("<", key, value);
    }

    public static Statement lte(String key, Object value) {
        return new SimpleStatement("<=", key, value);
    }

    public static Statement in(String key, Object ... values) {
        return new SimpleStatement("in", key, values);
    }

    public static Statement notIn(String key, Object ... values) {
        return new SimpleStatement("!in", key, values);
    }

    private static class CompoundStatement
    extends Statement {
        private final Statement[] statements;

        CompoundStatement(String operator, Statement ... statements) {
            super(operator);
            this.statements = statements;
        }

        @Override
        public Object[] toArray() {
            ArrayList<Object> array = new ArrayList<Object>(1 + this.statements.length);
            array.add(this.operator);
            for (Statement statement : this.statements) {
                array.add(statement.toArray());
            }
            return array.toArray();
        }
    }

    private static class SimpleStatement
    extends Statement {
        private final String key;
        private final Object[] values;

        SimpleStatement(String operator, String key, Object ... values) {
            super(operator);
            this.key = key;
            this.values = values;
        }

        @Override
        public Object[] toArray() {
            ArrayList<String> array = new ArrayList<String>(2 + this.values.length);
            array.add(this.operator);
            array.add(this.key);
            Collections.addAll(array, this.values);
            return array.toArray();
        }
    }

    public static abstract class Statement {
        protected final String operator;

        public Statement(String operator) {
            this.operator = operator;
        }

        public abstract Object[] toArray();
    }
}

