/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.Bitmap;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.IconFactory;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.exceptions.IconBitmapChangedException;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class IconManager {
    private NativeMapView nativeMapView;
    private List<Icon> icons;
    private int averageIconHeight;
    private int averageIconWidth;

    IconManager(NativeMapView nativeMapView) {
        this.nativeMapView = nativeMapView;
        this.icons = new ArrayList<Icon>();
        this.loadIcon(IconFactory.recreate("com.mapbox.icons.icon_marker_view", IconFactory.ICON_MARKERVIEW_BITMAP));
    }

    Icon loadIconForMarker(Marker marker) {
        Bitmap bitmap;
        Icon icon = marker.getIcon();
        int iconSize = this.icons.size() + 1;
        if (icon == null) {
            icon = IconFactory.getInstance(this.nativeMapView.getContext()).defaultMarker();
            bitmap = icon.getBitmap();
            this.averageIconHeight += (bitmap.getHeight() / 2 - this.averageIconHeight) / iconSize;
            this.averageIconWidth += (bitmap.getWidth() - this.averageIconWidth) / iconSize;
            marker.setIcon(icon);
        } else {
            bitmap = icon.getBitmap();
            this.averageIconHeight += (bitmap.getHeight() - this.averageIconHeight) / iconSize;
            this.averageIconWidth += (bitmap.getWidth() - this.averageIconWidth) / iconSize;
        }
        if (!this.icons.contains(icon)) {
            this.icons.add(icon);
            this.loadIcon(icon);
        } else {
            Icon oldIcon = this.icons.get(this.icons.indexOf(icon));
            if (!oldIcon.getBitmap().sameAs(icon.getBitmap())) {
                throw new IconBitmapChangedException();
            }
        }
        return icon;
    }

    Icon loadIconForMarkerView(MarkerView marker) {
        Icon icon = marker.getIcon();
        int iconSize = this.icons.size() + 1;
        if (icon == null) {
            icon = IconFactory.getInstance(this.nativeMapView.getContext()).defaultMarkerView();
            marker.setIcon(icon);
        }
        Bitmap bitmap = icon.getBitmap();
        this.averageIconHeight += (bitmap.getHeight() - this.averageIconHeight) / iconSize;
        this.averageIconWidth += (bitmap.getWidth() - this.averageIconWidth) / iconSize;
        if (!this.icons.contains(icon)) {
            this.icons.add(icon);
        } else {
            Icon oldIcon = this.icons.get(this.icons.indexOf(icon));
            if (!oldIcon.getBitmap().sameAs(icon.getBitmap())) {
                throw new IconBitmapChangedException();
            }
        }
        return icon;
    }

    int getTopOffsetPixelsForIcon(Icon icon) {
        return (int)(this.nativeMapView.getTopOffsetPixelsForAnnotationSymbol(icon.getId()) * (double)this.nativeMapView.getPixelRatio());
    }

    void loadIcon(Icon icon) {
        Bitmap bitmap = icon.getBitmap();
        String id = icon.getId();
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
        }
        ByteBuffer buffer = ByteBuffer.allocate(bitmap.getRowBytes() * bitmap.getHeight());
        bitmap.copyPixelsToBuffer((Buffer)buffer);
        float density = bitmap.getDensity();
        if (density == 0.0f) {
            density = 160.0f;
        }
        float scale = density / 160.0f;
        this.nativeMapView.addAnnotationIcon(id, bitmap.getWidth(), bitmap.getHeight(), scale, buffer.array());
    }

    void reloadIcons() {
        int count = this.icons.size();
        for (int i = 0; i < count; ++i) {
            Icon icon = this.icons.get(i);
            this.loadIcon(icon);
        }
    }

    void ensureIconLoaded(Marker marker, MapboxMap mapboxMap) {
        Marker previousMarker;
        Icon icon = marker.getIcon();
        if (icon == null) {
            icon = IconFactory.getInstance(this.nativeMapView.getContext()).defaultMarker();
            marker.setIcon(icon);
        }
        if (!this.icons.contains(icon)) {
            this.icons.add(icon);
            this.loadIcon(icon);
        } else {
            Icon oldIcon = this.icons.get(this.icons.indexOf(icon));
            if (!oldIcon.getBitmap().sameAs(icon.getBitmap())) {
                throw new IconBitmapChangedException();
            }
        }
        Marker marker2 = previousMarker = marker.getId() != -1L ? (Marker)mapboxMap.getAnnotation(marker.getId()) : null;
        if (previousMarker == null || previousMarker.getIcon() == null || previousMarker.getIcon() != marker.getIcon()) {
            marker.setTopOffsetPixels(this.getTopOffsetPixelsForIcon(icon));
        }
    }

    int getAverageIconHeight() {
        return this.averageIconHeight;
    }

    int getAverageIconWidth() {
        return this.averageIconWidth;
    }
}

