/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class FillLayer
extends Layer {
    public FillLayer(long nativePtr) {
        super(nativePtr);
    }

    public FillLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.nativeSetSourceLayer(sourceLayer);
    }

    public FillLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public void setFilter(Filter.Statement filter) {
        this.nativeSetFilter(filter.toArray());
    }

    public FillLayer withFilter(Filter.Statement filter) {
        this.setFilter(filter);
        return this;
    }

    public FillLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Boolean> getFillAntialias() {
        return new PropertyValue<Object>("fill-antialias", this.nativeGetFillAntialias());
    }

    public PropertyValue<Float> getFillOpacity() {
        return new PropertyValue<Object>("fill-opacity", this.nativeGetFillOpacity());
    }

    public PropertyValue<String> getFillColor() {
        return new PropertyValue<Object>("fill-color", this.nativeGetFillColor());
    }

    @ColorInt
    public int getFillColorAsInt() {
        PropertyValue<String> value = this.getFillColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("fill-color was set as a Function");
    }

    public PropertyValue<String> getFillOutlineColor() {
        return new PropertyValue<Object>("fill-outline-color", this.nativeGetFillOutlineColor());
    }

    @ColorInt
    public int getFillOutlineColorAsInt() {
        PropertyValue<String> value = this.getFillOutlineColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("fill-outline-color was set as a Function");
    }

    public PropertyValue<Float[]> getFillTranslate() {
        return new PropertyValue<Object>("fill-translate", this.nativeGetFillTranslate());
    }

    public PropertyValue<String> getFillTranslateAnchor() {
        return new PropertyValue<Object>("fill-translate-anchor", this.nativeGetFillTranslateAnchor());
    }

    public PropertyValue<String> getFillPattern() {
        return new PropertyValue<Object>("fill-pattern", this.nativeGetFillPattern());
    }

    private native Object nativeGetFillAntialias();

    private native Object nativeGetFillOpacity();

    private native Object nativeGetFillColor();

    private native Object nativeGetFillOutlineColor();

    private native Object nativeGetFillTranslate();

    private native Object nativeGetFillTranslateAnchor();

    private native Object nativeGetFillPattern();

    @Override
    protected native void finalize() throws Throwable;
}

