/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.style.functions.Function;
import timber.log.Timber;

public class PropertyValue<T> {
    public final String name;
    public final T value;

    PropertyValue(@NonNull String name, T value) {
        this.name = name;
        this.value = value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isFunction() {
        return !this.isNull() && this.value instanceof Function;
    }

    public boolean isValue() {
        return !this.isNull() && !this.isFunction();
    }

    @Nullable
    public Function<?, T> getFunction() {
        if (this.isFunction()) {
            return (Function)this.value;
        }
        Timber.w((String)"not a function, try value", (Object[])new Object[0]);
        return null;
    }

    @Nullable
    public T getValue() {
        if (this.isValue()) {
            return this.value;
        }
        Timber.w((String)"not a value, try function", (Object[])new Object[0]);
        return null;
    }

    public String toString() {
        return String.format("%s: %s", this.name, this.value);
    }
}

