/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.exceptions.InvalidAccessTokenException;
import com.mapbox.mapboxsdk.location.LocationSource;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.services.android.telemetry.MapboxTelemetry;
import com.mapbox.services.android.telemetry.location.LocationEngine;

public final class Mapbox {
    private static Mapbox INSTANCE;
    private Context context;
    private String accessToken;
    private Boolean connected;

    public static synchronized Mapbox getInstance(@NonNull Context context, @NonNull String accessToken) {
        if (INSTANCE == null) {
            Context appContext = context.getApplicationContext();
            INSTANCE = new Mapbox(appContext, accessToken);
            LocationSource locationEngine = new LocationSource(appContext);
            locationEngine.setPriority(0);
            MapboxTelemetry.getInstance().initialize(appContext, accessToken, (LocationEngine)locationEngine);
            ConnectivityReceiver.instance(appContext);
        }
        return INSTANCE;
    }

    private Mapbox(@NonNull Context context, @NonNull String accessToken) {
        this.context = context;
        this.accessToken = accessToken;
    }

    public static String getAccessToken() {
        Mapbox.validateAccessToken();
        return Mapbox.INSTANCE.accessToken;
    }

    private static void validateAccessToken() throws InvalidAccessTokenException {
        String accessToken = Mapbox.INSTANCE.accessToken;
        if (TextUtils.isEmpty((CharSequence)accessToken) || !accessToken.toLowerCase(MapboxConstants.MAPBOX_LOCALE).startsWith("pk.") && !accessToken.toLowerCase(MapboxConstants.MAPBOX_LOCALE).startsWith("sk.")) {
            throw new InvalidAccessTokenException();
        }
    }

    public static Context getApplicationContext() {
        return Mapbox.INSTANCE.context;
    }

    public static synchronized void setConnected(Boolean connected) {
        Mapbox.INSTANCE.connected = connected;
    }

    public static synchronized Boolean isConnected() {
        if (Mapbox.INSTANCE.connected != null) {
            return Mapbox.INSTANCE.connected;
        }
        ConnectivityManager cm = (ConnectivityManager)Mapbox.INSTANCE.context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }
}

