/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.mapbox.mapboxsdk.location.LocationListener;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.api.LostApiClient;
import java.util.concurrent.CopyOnWriteArrayList;

public class LocationServices
implements com.mapzen.android.lost.api.LocationListener {
    private static final String TAG = "LocationServices";
    private static LocationServices instance;
    private Context context;
    private LostApiClient locationClient;
    private Location lastLocation;
    private CopyOnWriteArrayList<LocationListener> locationListeners;
    private boolean isGPSEnabled;

    private LocationServices(Context context) {
        this.context = context;
        this.locationClient = new LostApiClient.Builder(context).build();
        this.locationListeners = new CopyOnWriteArrayList();
    }

    public static LocationServices getLocationServices(@NonNull Context context) {
        if (instance == null) {
            instance = new LocationServices(context.getApplicationContext());
        }
        return instance;
    }

    public void toggleGPS(boolean enableGPS) {
        if (!this.areLocationPermissionsGranted()) {
            Log.w((String)TAG, (String)"Location Permissions Not Granted Yet.  Try again after requesting.");
            return;
        }
        if (this.locationClient.isConnected()) {
            com.mapzen.android.lost.api.LocationServices.FusedLocationApi.removeLocationUpdates((com.mapzen.android.lost.api.LocationListener)this);
            this.locationClient.disconnect();
        }
        this.locationClient.connect();
        Location lastLocation = com.mapzen.android.lost.api.LocationServices.FusedLocationApi.getLastLocation();
        if (lastLocation != null) {
            this.lastLocation = lastLocation;
        }
        if (enableGPS) {
            LocationRequest locationRequest = LocationRequest.create().setFastestInterval(1000L).setSmallestDisplacement(3.0f).setPriority(100);
            com.mapzen.android.lost.api.LocationServices.FusedLocationApi.requestLocationUpdates(locationRequest, (com.mapzen.android.lost.api.LocationListener)this);
        } else {
            LocationRequest locationRequest = LocationRequest.create().setFastestInterval(1000L).setSmallestDisplacement(3.0f).setPriority(105);
            com.mapzen.android.lost.api.LocationServices.FusedLocationApi.requestLocationUpdates(locationRequest, (com.mapzen.android.lost.api.LocationListener)this);
        }
        this.isGPSEnabled = enableGPS;
    }

    public boolean isGPSEnabled() {
        return this.isGPSEnabled;
    }

    public void onLocationChanged(Location location) {
        this.lastLocation = location;
        for (LocationListener listener : this.locationListeners) {
            listener.onLocationChanged(location);
        }
        Intent locIntent = new Intent("com.mapbox.mapboxsdk.telemetry.TelemetryLocationReceiver");
        locIntent.putExtra("location", (Parcelable)location);
        LocalBroadcastManager.getInstance((Context)this.context.getApplicationContext()).sendBroadcast(locIntent);
    }

    public Location getLastLocation() {
        return this.lastLocation;
    }

    public void addLocationListener(@NonNull LocationListener locationListener) {
        if (!this.locationListeners.contains(locationListener)) {
            this.locationListeners.add(locationListener);
        }
    }

    public boolean removeLocationListener(@NonNull LocationListener locationListener) {
        return this.locationListeners.remove(locationListener);
    }

    public boolean areLocationPermissionsGranted() {
        if (ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0 && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            Log.w((String)TAG, (String)"Location Permissions Not Granted Yet.  Try again after requesting.");
            return false;
        }
        return true;
    }
}

