/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.util.Arrays;

public class MapboxMapOptions
implements Parcelable {
    private static final float DIMENSION_SEVEN_DP = 7.0f;
    private static final float DIMENSION_TEN_DP = 10.0f;
    private static final float DIMENSION_SIXTEEN_DP = 16.0f;
    private static final float DIMENSION_SEVENTY_SIX_DP = 76.0f;
    private CameraPosition cameraPosition;
    private boolean debugActive;
    private boolean compassEnabled = true;
    private boolean fadeCompassFacingNorth = true;
    private int compassGravity = 8388661;
    private int[] compassMargins;
    private boolean logoEnabled = true;
    private int logoGravity = 8388691;
    private int[] logoMargins;
    @ColorInt
    private int attributionTintColor = -1;
    private boolean attributionEnabled = true;
    private int attributionGravity = 80;
    private int[] attributionMargins;
    private float minZoom = 0.0f;
    private float maxZoom = 21.0f;
    private boolean rotateGesturesEnabled = true;
    private boolean scrollGesturesEnabled = true;
    private boolean tiltGesturesEnabled = true;
    private boolean zoomGesturesEnabled = true;
    private boolean zoomControlsEnabled = false;
    private boolean myLocationEnabled;
    private Drawable myLocationForegroundDrawable;
    private Drawable myLocationForegroundBearingDrawable;
    private Drawable myLocationBackgroundDrawable;
    private int myLocationForegroundTintColor;
    private int myLocationBackgroundTintColor;
    private int[] myLocationBackgroundPadding;
    private int myLocationAccuracyTintColor;
    private int myLocationAccuracyAlpha;
    private String apiBaseUrl;
    @Deprecated
    private boolean textureMode;
    private String style;
    @Deprecated
    private String accessToken;
    public static final Parcelable.Creator<MapboxMapOptions> CREATOR = new Parcelable.Creator<MapboxMapOptions>(){

        public MapboxMapOptions createFromParcel(Parcel in) {
            return new MapboxMapOptions(in);
        }

        public MapboxMapOptions[] newArray(int size) {
            return new MapboxMapOptions[size];
        }
    };

    public MapboxMapOptions() {
    }

    private MapboxMapOptions(Parcel in) {
        Bitmap backgroundBitmap;
        Bitmap foregroundBearingBitmap;
        this.cameraPosition = (CameraPosition)in.readParcelable(CameraPosition.class.getClassLoader());
        this.debugActive = in.readByte() != 0;
        this.compassEnabled = in.readByte() != 0;
        this.compassGravity = in.readInt();
        this.compassMargins = in.createIntArray();
        this.fadeCompassFacingNorth = in.readByte() != 0;
        this.logoEnabled = in.readByte() != 0;
        this.logoGravity = in.readInt();
        this.logoMargins = in.createIntArray();
        this.attributionEnabled = in.readByte() != 0;
        this.attributionGravity = in.readInt();
        this.attributionMargins = in.createIntArray();
        this.attributionTintColor = in.readInt();
        this.minZoom = in.readFloat();
        this.maxZoom = in.readFloat();
        this.rotateGesturesEnabled = in.readByte() != 0;
        this.scrollGesturesEnabled = in.readByte() != 0;
        this.tiltGesturesEnabled = in.readByte() != 0;
        this.zoomControlsEnabled = in.readByte() != 0;
        this.zoomGesturesEnabled = in.readByte() != 0;
        this.myLocationEnabled = in.readByte() != 0;
        Bitmap foregroundBitmap = (Bitmap)in.readParcelable(this.getClass().getClassLoader());
        if (foregroundBitmap != null) {
            this.myLocationForegroundDrawable = new BitmapDrawable(foregroundBitmap);
        }
        if ((foregroundBearingBitmap = (Bitmap)in.readParcelable(this.getClass().getClassLoader())) != null) {
            this.myLocationForegroundBearingDrawable = new BitmapDrawable(foregroundBearingBitmap);
        }
        if ((backgroundBitmap = (Bitmap)in.readParcelable(this.getClass().getClassLoader())) != null) {
            this.myLocationBackgroundDrawable = new BitmapDrawable(backgroundBitmap);
        }
        this.myLocationForegroundTintColor = in.readInt();
        this.myLocationBackgroundTintColor = in.readInt();
        this.myLocationBackgroundPadding = in.createIntArray();
        this.myLocationAccuracyAlpha = in.readInt();
        this.myLocationAccuracyTintColor = in.readInt();
        this.style = in.readString();
        this.accessToken = in.readString();
        this.apiBaseUrl = in.readString();
        this.textureMode = in.readByte() != 0;
    }

    public static Bitmap getBitmapFromDrawable(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapboxMapOptions createFromAttributes(@NonNull Context context, @Nullable AttributeSet attrs) {
        MapboxMapOptions mapboxMapOptions = new MapboxMapOptions();
        float screenDensity = context.getResources().getDisplayMetrics().density;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MapView, 0, 0);
        try {
            Drawable backgroundDrawable;
            Drawable foregroundBearingDrawable;
            mapboxMapOptions.debugActive(typedArray.getBoolean(R.styleable.MapView_debug_active, false));
            mapboxMapOptions.camera(new CameraPosition.Builder(typedArray).build());
            mapboxMapOptions.accessToken(typedArray.getString(R.styleable.MapView_access_token));
            mapboxMapOptions.styleUrl(typedArray.getString(R.styleable.MapView_style_url));
            mapboxMapOptions.apiBaseUrl(typedArray.getString(R.styleable.MapView_api_base_url));
            mapboxMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapView_zoom_enabled, true));
            mapboxMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapView_scroll_enabled, true));
            mapboxMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapView_rotate_enabled, true));
            mapboxMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapView_tilt_enabled, true));
            mapboxMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapView_zoom_controls_enabled, false));
            mapboxMapOptions.maxZoom(typedArray.getFloat(R.styleable.MapView_zoom_max, 21.0f));
            mapboxMapOptions.minZoom(typedArray.getFloat(R.styleable.MapView_zoom_min, 0.0f));
            mapboxMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapView_compass_enabled, true));
            mapboxMapOptions.compassGravity(typedArray.getInt(R.styleable.MapView_compass_gravity, 8388661));
            mapboxMapOptions.compassMargins(new int[]{(int)(typedArray.getDimension(R.styleable.MapView_compass_margin_left, 10.0f) * screenDensity), (int)typedArray.getDimension(R.styleable.MapView_compass_margin_top, 10.0f * screenDensity), (int)typedArray.getDimension(R.styleable.MapView_compass_margin_right, 10.0f * screenDensity), (int)typedArray.getDimension(R.styleable.MapView_compass_margin_bottom, 10.0f * screenDensity)});
            mapboxMapOptions.compassFadesWhenFacingNorth(typedArray.getBoolean(R.styleable.MapView_compass_fade_facing_north, true));
            mapboxMapOptions.logoEnabled(typedArray.getBoolean(R.styleable.MapView_logo_enabled, true));
            mapboxMapOptions.logoGravity(typedArray.getInt(R.styleable.MapView_logo_gravity, 8388691));
            mapboxMapOptions.logoMargins(new int[]{(int)(typedArray.getDimension(R.styleable.MapView_logo_margin_left, 16.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_logo_margin_top, 16.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_logo_margin_right, 16.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_logo_margin_bottom, 16.0f) * screenDensity)});
            mapboxMapOptions.attributionTintColor(typedArray.getColor(R.styleable.MapView_attribution_tint, -1));
            mapboxMapOptions.attributionEnabled(typedArray.getBoolean(R.styleable.MapView_attribution_enabled, true));
            mapboxMapOptions.attributionGravity(typedArray.getInt(R.styleable.MapView_attribution_gravity, 80));
            mapboxMapOptions.attributionMargins(new int[]{(int)(typedArray.getDimension(R.styleable.MapView_attribution_margin_left, 76.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_attribution_margin_top, 7.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_attribution_margin_right, 7.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_attribution_margin_bottom, 7.0f) * screenDensity)});
            mapboxMapOptions.locationEnabled(typedArray.getBoolean(R.styleable.MapView_my_location_enabled, false));
            mapboxMapOptions.myLocationForegroundTintColor(typedArray.getColor(R.styleable.MapView_my_location_foreground_tint, 0));
            mapboxMapOptions.myLocationBackgroundTintColor(typedArray.getColor(R.styleable.MapView_my_location_background_tint, 0));
            Drawable foregroundDrawable = typedArray.getDrawable(R.styleable.MapView_my_location_foreground);
            if (foregroundDrawable == null) {
                foregroundDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_mylocationview_normal);
            }
            if ((foregroundBearingDrawable = typedArray.getDrawable(R.styleable.MapView_my_location_foreground_bearing)) == null) {
                foregroundBearingDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_mylocationview_bearing);
            }
            if ((backgroundDrawable = typedArray.getDrawable(R.styleable.MapView_my_location_background)) == null) {
                backgroundDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_mylocationview_background);
            }
            mapboxMapOptions.myLocationForegroundDrawables(foregroundDrawable, foregroundBearingDrawable);
            mapboxMapOptions.myLocationBackgroundDrawable(backgroundDrawable);
            mapboxMapOptions.myLocationBackgroundPadding(new int[]{(int)(typedArray.getDimension(R.styleable.MapView_my_location_background_left, 0.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_my_location_background_top, 0.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_my_location_background_right, 0.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_my_location_background_bottom, 0.0f) * screenDensity)});
            mapboxMapOptions.myLocationAccuracyAlpha(typedArray.getInt(R.styleable.MapView_my_location_accuracy_alpha, 100));
            mapboxMapOptions.myLocationAccuracyTint(typedArray.getColor(R.styleable.MapView_my_location_accuracy_tint, ColorUtils.getPrimaryColor(context)));
            mapboxMapOptions.textureMode(typedArray.getBoolean(R.styleable.MapView_texture_mode, false));
        }
        finally {
            typedArray.recycle();
        }
        return mapboxMapOptions;
    }

    public MapboxMapOptions apiBaseUrl(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
        return this;
    }

    public MapboxMapOptions camera(CameraPosition cameraPosition) {
        this.cameraPosition = cameraPosition;
        return this;
    }

    @Deprecated
    public MapboxMapOptions accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public MapboxMapOptions styleUrl(String styleUrl) {
        this.style = styleUrl;
        return this;
    }

    public MapboxMapOptions debugActive(boolean enabled) {
        this.debugActive = enabled;
        return this;
    }

    public MapboxMapOptions minZoom(float minZoom) {
        this.minZoom = minZoom;
        return this;
    }

    public MapboxMapOptions maxZoom(float maxZoom) {
        this.maxZoom = maxZoom;
        return this;
    }

    public MapboxMapOptions compassEnabled(boolean enabled) {
        this.compassEnabled = enabled;
        return this;
    }

    public MapboxMapOptions compassGravity(int gravity) {
        this.compassGravity = gravity;
        return this;
    }

    public MapboxMapOptions compassMargins(int[] margins) {
        this.compassMargins = margins;
        return this;
    }

    public MapboxMapOptions compassFadesWhenFacingNorth(boolean compassFadeWhenFacingNorth) {
        this.fadeCompassFacingNorth = compassFadeWhenFacingNorth;
        return this;
    }

    public MapboxMapOptions logoEnabled(boolean enabled) {
        this.logoEnabled = enabled;
        return this;
    }

    public MapboxMapOptions logoGravity(int gravity) {
        this.logoGravity = gravity;
        return this;
    }

    public MapboxMapOptions logoMargins(int[] margins) {
        this.logoMargins = margins;
        return this;
    }

    public MapboxMapOptions attributionEnabled(boolean enabled) {
        this.attributionEnabled = enabled;
        return this;
    }

    public MapboxMapOptions attributionGravity(int gravity) {
        this.attributionGravity = gravity;
        return this;
    }

    public MapboxMapOptions attributionMargins(int[] margins) {
        this.attributionMargins = margins;
        return this;
    }

    public MapboxMapOptions attributionTintColor(@ColorInt int color2) {
        this.attributionTintColor = color2;
        return this;
    }

    public MapboxMapOptions rotateGesturesEnabled(boolean enabled) {
        this.rotateGesturesEnabled = enabled;
        return this;
    }

    public MapboxMapOptions scrollGesturesEnabled(boolean enabled) {
        this.scrollGesturesEnabled = enabled;
        return this;
    }

    public MapboxMapOptions tiltGesturesEnabled(boolean enabled) {
        this.tiltGesturesEnabled = enabled;
        return this;
    }

    public MapboxMapOptions zoomControlsEnabled(boolean enabled) {
        this.zoomControlsEnabled = enabled;
        return this;
    }

    public MapboxMapOptions zoomGesturesEnabled(boolean enabled) {
        this.zoomGesturesEnabled = enabled;
        return this;
    }

    public MapboxMapOptions locationEnabled(boolean locationEnabled) {
        this.myLocationEnabled = locationEnabled;
        return this;
    }

    public MapboxMapOptions myLocationForegroundDrawables(Drawable myLocationForegroundDrawable, Drawable myLocationBearingDrawable) {
        this.myLocationForegroundDrawable = myLocationForegroundDrawable;
        this.myLocationForegroundBearingDrawable = myLocationBearingDrawable;
        return this;
    }

    public MapboxMapOptions myLocationForegroundDrawable(Drawable myLocationForegroundDrawable) {
        this.myLocationForegroundDrawable = myLocationForegroundDrawable;
        return this;
    }

    public MapboxMapOptions myLocationBackgroundDrawable(Drawable myLocationBackgroundDrawable) {
        this.myLocationBackgroundDrawable = myLocationBackgroundDrawable;
        return this;
    }

    public MapboxMapOptions myLocationForegroundTintColor(@ColorInt int myLocationForegroundTintColor) {
        this.myLocationForegroundTintColor = myLocationForegroundTintColor;
        return this;
    }

    public MapboxMapOptions myLocationBackgroundTintColor(@ColorInt int myLocationBackgroundTintColor) {
        this.myLocationBackgroundTintColor = myLocationBackgroundTintColor;
        return this;
    }

    public MapboxMapOptions myLocationBackgroundPadding(int[] myLocationBackgroundPadding) {
        this.myLocationBackgroundPadding = myLocationBackgroundPadding;
        return this;
    }

    public MapboxMapOptions myLocationAccuracyTint(@ColorInt int myLocationAccuracyTintColor) {
        this.myLocationAccuracyTintColor = myLocationAccuracyTintColor;
        return this;
    }

    public MapboxMapOptions myLocationAccuracyAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.myLocationAccuracyAlpha = alpha;
        return this;
    }

    public MapboxMapOptions textureMode(boolean textureMode) {
        this.textureMode = textureMode;
        return this;
    }

    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    public CameraPosition getCamera() {
        return this.cameraPosition;
    }

    public float getMinZoom() {
        return this.minZoom;
    }

    public float getMaxZoom() {
        return this.maxZoom;
    }

    public boolean getCompassEnabled() {
        return this.compassEnabled;
    }

    public int getCompassGravity() {
        return this.compassGravity;
    }

    public int[] getCompassMargins() {
        return this.compassMargins;
    }

    public boolean getCompassFadeFacingNorth() {
        return this.fadeCompassFacingNorth;
    }

    public boolean getLogoEnabled() {
        return this.logoEnabled;
    }

    public int getLogoGravity() {
        return this.logoGravity;
    }

    public int[] getLogoMargins() {
        return this.logoMargins;
    }

    @Deprecated
    public String getAccessToken() {
        return this.accessToken;
    }

    public String getStyle() {
        return this.style;
    }

    public boolean getRotateGesturesEnabled() {
        return this.rotateGesturesEnabled;
    }

    public boolean getScrollGesturesEnabled() {
        return this.scrollGesturesEnabled;
    }

    public boolean getTiltGesturesEnabled() {
        return this.tiltGesturesEnabled;
    }

    public boolean getZoomControlsEnabled() {
        return this.zoomControlsEnabled;
    }

    public boolean getZoomGesturesEnabled() {
        return this.zoomGesturesEnabled;
    }

    public boolean getAttributionEnabled() {
        return this.attributionEnabled;
    }

    public int getAttributionGravity() {
        return this.attributionGravity;
    }

    public int[] getAttributionMargins() {
        return this.attributionMargins;
    }

    @ColorInt
    public int getAttributionTintColor() {
        return this.attributionTintColor;
    }

    public boolean getLocationEnabled() {
        return this.myLocationEnabled;
    }

    public Drawable getMyLocationForegroundDrawable() {
        return this.myLocationForegroundDrawable;
    }

    public Drawable getMyLocationForegroundBearingDrawable() {
        return this.myLocationForegroundBearingDrawable;
    }

    public Drawable getMyLocationBackgroundDrawable() {
        return this.myLocationBackgroundDrawable;
    }

    public int getMyLocationForegroundTintColor() {
        return this.myLocationForegroundTintColor;
    }

    public int getMyLocationBackgroundTintColor() {
        return this.myLocationBackgroundTintColor;
    }

    public int[] getMyLocationBackgroundPadding() {
        return this.myLocationBackgroundPadding;
    }

    public int getMyLocationAccuracyTintColor() {
        return this.myLocationAccuracyTintColor;
    }

    public int getMyLocationAccuracyAlpha() {
        return this.myLocationAccuracyAlpha;
    }

    public boolean getDebugActive() {
        return this.debugActive;
    }

    public boolean getTextureMode() {
        return this.textureMode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.cameraPosition, flags);
        dest.writeByte((byte)(this.debugActive ? 1 : 0));
        dest.writeByte((byte)(this.compassEnabled ? 1 : 0));
        dest.writeInt(this.compassGravity);
        dest.writeIntArray(this.compassMargins);
        dest.writeByte((byte)(this.fadeCompassFacingNorth ? 1 : 0));
        dest.writeByte((byte)(this.logoEnabled ? 1 : 0));
        dest.writeInt(this.logoGravity);
        dest.writeIntArray(this.logoMargins);
        dest.writeByte((byte)(this.attributionEnabled ? 1 : 0));
        dest.writeInt(this.attributionGravity);
        dest.writeIntArray(this.attributionMargins);
        dest.writeInt(this.attributionTintColor);
        dest.writeFloat(this.minZoom);
        dest.writeFloat(this.maxZoom);
        dest.writeByte((byte)(this.rotateGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.scrollGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.tiltGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.zoomControlsEnabled ? 1 : 0));
        dest.writeByte((byte)(this.zoomGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.myLocationEnabled ? 1 : 0));
        dest.writeParcelable((Parcelable)(this.myLocationForegroundDrawable != null ? MapboxMapOptions.getBitmapFromDrawable(this.myLocationForegroundDrawable) : null), flags);
        dest.writeParcelable((Parcelable)(this.myLocationForegroundBearingDrawable != null ? MapboxMapOptions.getBitmapFromDrawable(this.myLocationForegroundBearingDrawable) : null), flags);
        dest.writeParcelable((Parcelable)(this.myLocationBackgroundDrawable != null ? MapboxMapOptions.getBitmapFromDrawable(this.myLocationBackgroundDrawable) : null), flags);
        dest.writeInt(this.myLocationForegroundTintColor);
        dest.writeInt(this.myLocationBackgroundTintColor);
        dest.writeIntArray(this.myLocationBackgroundPadding);
        dest.writeInt(this.myLocationAccuracyAlpha);
        dest.writeInt(this.myLocationAccuracyTintColor);
        dest.writeString(this.style);
        dest.writeString(this.accessToken);
        dest.writeString(this.apiBaseUrl);
        dest.writeByte((byte)(this.textureMode ? 1 : 0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapboxMapOptions options = (MapboxMapOptions)o;
        if (this.debugActive != options.debugActive) {
            return false;
        }
        if (this.compassEnabled != options.compassEnabled) {
            return false;
        }
        if (this.fadeCompassFacingNorth != options.fadeCompassFacingNorth) {
            return false;
        }
        if (this.compassGravity != options.compassGravity) {
            return false;
        }
        if (this.logoEnabled != options.logoEnabled) {
            return false;
        }
        if (this.logoGravity != options.logoGravity) {
            return false;
        }
        if (this.attributionTintColor != options.attributionTintColor) {
            return false;
        }
        if (this.attributionEnabled != options.attributionEnabled) {
            return false;
        }
        if (this.attributionGravity != options.attributionGravity) {
            return false;
        }
        if (Float.compare(options.minZoom, this.minZoom) != 0) {
            return false;
        }
        if (Float.compare(options.maxZoom, this.maxZoom) != 0) {
            return false;
        }
        if (this.rotateGesturesEnabled != options.rotateGesturesEnabled) {
            return false;
        }
        if (this.scrollGesturesEnabled != options.scrollGesturesEnabled) {
            return false;
        }
        if (this.tiltGesturesEnabled != options.tiltGesturesEnabled) {
            return false;
        }
        if (this.zoomGesturesEnabled != options.zoomGesturesEnabled) {
            return false;
        }
        if (this.zoomControlsEnabled != options.zoomControlsEnabled) {
            return false;
        }
        if (this.myLocationEnabled != options.myLocationEnabled) {
            return false;
        }
        if (this.myLocationForegroundTintColor != options.myLocationForegroundTintColor) {
            return false;
        }
        if (this.myLocationBackgroundTintColor != options.myLocationBackgroundTintColor) {
            return false;
        }
        if (this.myLocationAccuracyTintColor != options.myLocationAccuracyTintColor) {
            return false;
        }
        if (this.myLocationAccuracyAlpha != options.myLocationAccuracyAlpha) {
            return false;
        }
        if (this.cameraPosition != null ? !this.cameraPosition.equals(options.cameraPosition) : options.cameraPosition != null) {
            return false;
        }
        if (!Arrays.equals(this.compassMargins, options.compassMargins)) {
            return false;
        }
        if (!Arrays.equals(this.logoMargins, options.logoMargins)) {
            return false;
        }
        if (!Arrays.equals(this.attributionMargins, options.attributionMargins)) {
            return false;
        }
        if (this.myLocationForegroundDrawable != null ? !this.myLocationForegroundDrawable.equals(options.myLocationForegroundDrawable) : options.myLocationForegroundDrawable != null) {
            return false;
        }
        if (this.myLocationForegroundBearingDrawable != null ? !this.myLocationForegroundBearingDrawable.equals(options.myLocationForegroundBearingDrawable) : options.myLocationForegroundBearingDrawable != null) {
            return false;
        }
        if (this.myLocationBackgroundDrawable != null ? !this.myLocationBackgroundDrawable.equals(options.myLocationBackgroundDrawable) : options.myLocationBackgroundDrawable != null) {
            return false;
        }
        if (!Arrays.equals(this.myLocationBackgroundPadding, options.myLocationBackgroundPadding)) {
            return false;
        }
        if (this.style != null ? !this.style.equals(options.style) : options.style != null) {
            return false;
        }
        if (this.apiBaseUrl != null ? !this.apiBaseUrl.equals(options.apiBaseUrl) : options.apiBaseUrl != null) {
            return false;
        }
        return this.accessToken != null ? this.accessToken.equals(options.accessToken) : options.accessToken == null;
    }

    public int hashCode() {
        int result = this.cameraPosition != null ? this.cameraPosition.hashCode() : 0;
        result = 31 * result + (this.debugActive ? 1 : 0);
        result = 31 * result + (this.compassEnabled ? 1 : 0);
        result = 31 * result + (this.fadeCompassFacingNorth ? 1 : 0);
        result = 31 * result + this.compassGravity;
        result = 31 * result + Arrays.hashCode(this.compassMargins);
        result = 31 * result + (this.logoEnabled ? 1 : 0);
        result = 31 * result + this.logoGravity;
        result = 31 * result + Arrays.hashCode(this.logoMargins);
        result = 31 * result + this.attributionTintColor;
        result = 31 * result + (this.attributionEnabled ? 1 : 0);
        result = 31 * result + this.attributionGravity;
        result = 31 * result + Arrays.hashCode(this.attributionMargins);
        result = 31 * result + (this.minZoom != 0.0f ? Float.floatToIntBits(this.minZoom) : 0);
        result = 31 * result + (this.maxZoom != 0.0f ? Float.floatToIntBits(this.maxZoom) : 0);
        result = 31 * result + (this.rotateGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.scrollGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.tiltGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.zoomGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.zoomControlsEnabled ? 1 : 0);
        result = 31 * result + (this.myLocationEnabled ? 1 : 0);
        result = 31 * result + (this.myLocationForegroundDrawable != null ? this.myLocationForegroundDrawable.hashCode() : 0);
        result = 31 * result + (this.myLocationForegroundBearingDrawable != null ? this.myLocationForegroundBearingDrawable.hashCode() : 0);
        result = 31 * result + (this.myLocationBackgroundDrawable != null ? this.myLocationBackgroundDrawable.hashCode() : 0);
        result = 31 * result + this.myLocationForegroundTintColor;
        result = 31 * result + this.myLocationBackgroundTintColor;
        result = 31 * result + Arrays.hashCode(this.myLocationBackgroundPadding);
        result = 31 * result + this.myLocationAccuracyTintColor;
        result = 31 * result + this.myLocationAccuracyAlpha;
        result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
        result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
        result = 31 * result + (this.apiBaseUrl != null ? this.apiBaseUrl.hashCode() : 0);
        return result;
    }
}

