/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.Property;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public class LineLayer
extends Layer {
    public LineLayer(long nativePtr) {
        super(nativePtr);
    }

    public LineLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.nativeSetSourceLayer(sourceLayer);
    }

    public LineLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public void setFilter(Filter.Statement filter) {
        this.setFilter(filter.toArray());
    }

    public void setFilter(Object[] filter) {
        this.nativeSetFilter(filter);
    }

    public LineLayer withFilter(Object[] filter) {
        this.setFilter(filter);
        return this;
    }

    public LineLayer withFilter(Filter.Statement filter) {
        this.setFilter(filter);
        return this;
    }

    public LineLayer withProperties(Property<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<String> getLineCap() {
        return new PropertyValue<String>(this.nativeGetLineCap());
    }

    public PropertyValue<String> getLineJoin() {
        return new PropertyValue<String>(this.nativeGetLineJoin());
    }

    public PropertyValue<Float> getLineMiterLimit() {
        return new PropertyValue<Float>(this.nativeGetLineMiterLimit());
    }

    public PropertyValue<Float> getLineRoundLimit() {
        return new PropertyValue<Float>(this.nativeGetLineRoundLimit());
    }

    public PropertyValue<Float> getLineOpacity() {
        return new PropertyValue<Float>(this.nativeGetLineOpacity());
    }

    public PropertyValue<String> getLineColor() {
        return new PropertyValue<String>(this.nativeGetLineColor());
    }

    @ColorInt
    public int getLineColorAsInt() {
        PropertyValue<String> value = this.getLineColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("line-color was set as a Function");
    }

    public PropertyValue<Float[]> getLineTranslate() {
        return new PropertyValue<Float[]>(this.nativeGetLineTranslate());
    }

    public PropertyValue<String> getLineTranslateAnchor() {
        return new PropertyValue<String>(this.nativeGetLineTranslateAnchor());
    }

    public PropertyValue<Float> getLineWidth() {
        return new PropertyValue<Float>(this.nativeGetLineWidth());
    }

    public PropertyValue<Float> getLineGapWidth() {
        return new PropertyValue<Float>(this.nativeGetLineGapWidth());
    }

    public PropertyValue<Float> getLineOffset() {
        return new PropertyValue<Float>(this.nativeGetLineOffset());
    }

    public PropertyValue<Float> getLineBlur() {
        return new PropertyValue<Float>(this.nativeGetLineBlur());
    }

    public PropertyValue<Float[]> getLineDasharray() {
        return new PropertyValue<Float[]>(this.nativeGetLineDasharray());
    }

    public PropertyValue<String> getLinePattern() {
        return new PropertyValue<String>(this.nativeGetLinePattern());
    }

    private native Object nativeGetLineCap();

    private native Object nativeGetLineJoin();

    private native Object nativeGetLineMiterLimit();

    private native Object nativeGetLineRoundLimit();

    private native Object nativeGetLineOpacity();

    private native Object nativeGetLineColor();

    private native Object nativeGetLineTranslate();

    private native Object nativeGetLineTranslateAnchor();

    private native Object nativeGetLineWidth();

    private native Object nativeGetLineGapWidth();

    private native Object nativeGetLineOffset();

    private native Object nativeGetLineBlur();

    private native Object nativeGetLineDasharray();

    private native Object nativeGetLinePattern();

    @Override
    protected native void finalize() throws Throwable;
}

