/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import android.location.Location;
import android.os.SystemClock;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.util.LongSparseArray;
import android.support.v4.util.Pools;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.BaseMarkerViewOptions;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.InfoWindow;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerOptions;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.annotations.MarkerViewManager;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.TrackingSettings;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationViewSettings;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.NoSuchLayerException;
import com.mapbox.mapboxsdk.style.sources.NoSuchSourceException;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.services.commons.geojson.Feature;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MapboxMap {
    private static final String TAG = MapboxMap.class.getSimpleName();
    private MapView mapView;
    private UiSettings uiSettings;
    private TrackingSettings trackingSettings;
    private MyLocationViewSettings myLocationViewSettings;
    private Projection projection;
    private CameraPosition cameraPosition;
    private boolean invalidCameraPosition;
    private LongSparseArray<Annotation> annotations;
    private List<Marker> selectedMarkers;
    private MarkerViewManager markerViewManager;
    private List<InfoWindow> infoWindows;
    private InfoWindowAdapter infoWindowAdapter;
    private boolean myLocationEnabled;
    private boolean allowConcurrentMultipleInfoWindows;
    private OnMapClickListener onMapClickListener;
    private OnMapLongClickListener onMapLongClickListener;
    private OnMarkerClickListener onMarkerClickListener;
    private OnInfoWindowClickListener onInfoWindowClickListener;
    private OnInfoWindowLongClickListener onInfoWindowLongClickListener;
    private OnInfoWindowCloseListener onInfoWindowCloseListener;
    private OnFlingListener onFlingListener;
    private OnScrollListener onScrollListener;
    private OnMyLocationTrackingModeChangeListener onMyLocationTrackingModeChangeListener;
    private OnMyBearingTrackingModeChangeListener onMyBearingTrackingModeChangeListener;
    private OnFpsChangedListener onFpsChangedListener;
    private OnCameraChangeListener onCameraChangeListener;
    private double maxZoomLevel = -1.0;
    private double minZoomLevel = -1.0;

    MapboxMap(@NonNull MapView mapView) {
        this.mapView = mapView;
        this.mapView.addOnMapChangedListener(new MapChangeCameraPositionListener());
        this.uiSettings = new UiSettings(mapView);
        this.trackingSettings = new TrackingSettings(this.mapView, this.uiSettings);
        this.projection = new Projection(mapView);
        this.annotations = new LongSparseArray();
        this.selectedMarkers = new ArrayList<Marker>();
        this.infoWindows = new ArrayList<InfoWindow>();
        this.markerViewManager = new MarkerViewManager(this, mapView);
    }

    @Nullable
    @UiThread
    public Layer getLayer(@NonNull String layerId) {
        return this.getMapView().getNativeMapView().getLayer(layerId);
    }

    @Nullable
    @UiThread
    public <T extends Layer> T getLayerAs(@NonNull String layerId) {
        try {
            return (T)this.getMapView().getNativeMapView().getLayer(layerId);
        }
        catch (ClassCastException e) {
            Log.e((String)TAG, (String)String.format("Layer: %s is a different type: %s", layerId, e.getMessage()));
            return null;
        }
    }

    @UiThread
    public void addLayer(@NonNull Layer layer) {
        this.addLayer(layer, null);
    }

    @UiThread
    public void addLayer(@NonNull Layer layer, String before) {
        this.getMapView().getNativeMapView().addLayer(layer, before);
    }

    @UiThread
    public void removeLayer(@NonNull String layerId) throws NoSuchLayerException {
        this.getMapView().getNativeMapView().removeLayer(layerId);
    }

    @UiThread
    public void removeLayer(@NonNull Layer layer) throws NoSuchLayerException {
        this.getMapView().getNativeMapView().removeLayer(layer);
    }

    @Nullable
    @UiThread
    public Source getSource(@NonNull String sourceId) {
        return this.getMapView().getNativeMapView().getSource(sourceId);
    }

    @Nullable
    @UiThread
    public <T extends Source> T getSourceAs(@NonNull String sourceId) {
        try {
            return (T)this.getMapView().getNativeMapView().getSource(sourceId);
        }
        catch (ClassCastException e) {
            Log.e((String)TAG, (String)String.format("Source: %s is a different type: %s", sourceId, e.getMessage()));
            return null;
        }
    }

    @UiThread
    public void addSource(@NonNull Source source) {
        this.getMapView().getNativeMapView().addSource(source);
    }

    @UiThread
    public void removeSource(@NonNull String sourceId) throws NoSuchSourceException {
        this.getMapView().getNativeMapView().removeSource(sourceId);
    }

    @UiThread
    public void removeSource(@NonNull Source source) throws NoSuchSourceException {
        this.getMapView().getNativeMapView().removeSource(source);
    }

    @UiThread
    public void addImage(@NonNull String name, @NonNull Bitmap image) {
        this.getMapView().getNativeMapView().addImage(name, image);
    }

    @UiThread
    public void removeImage(String name) {
        this.getMapView().getNativeMapView().removeImage(name);
    }

    @UiThread
    public void setMinZoom(@FloatRange(from=0.0, to=21.0) double minZoom) {
        if (minZoom < 0.0 || minZoom > 21.0) {
            Log.e((String)"MapboxMap", (String)("Not setting minZoom, value is in unsupported range: " + minZoom));
            return;
        }
        this.minZoomLevel = minZoom;
        this.mapView.setMinZoom(minZoom);
    }

    @UiThread
    public double getMinZoom() {
        if (this.minZoomLevel == -1.0) {
            this.minZoomLevel = this.mapView.getMinZoom();
            return this.minZoomLevel;
        }
        return this.minZoomLevel;
    }

    @UiThread
    public void setMaxZoom(@FloatRange(from=0.0, to=21.0) double maxZoom) {
        if (maxZoom < 0.0 || maxZoom > 21.0) {
            Log.e((String)"MapboxMap", (String)("Not setting maxZoom, value is in unsupported range: " + maxZoom));
            return;
        }
        this.maxZoomLevel = maxZoom;
        this.mapView.setMaxZoom(maxZoom);
    }

    @UiThread
    public double getMaxZoom() {
        if (this.maxZoomLevel == -1.0) {
            this.maxZoomLevel = this.mapView.getMaxZoom();
            return this.maxZoomLevel;
        }
        return this.maxZoomLevel;
    }

    public UiSettings getUiSettings() {
        return this.uiSettings;
    }

    public TrackingSettings getTrackingSettings() {
        return this.trackingSettings;
    }

    public MyLocationViewSettings getMyLocationViewSettings() {
        if (this.myLocationViewSettings == null) {
            this.myLocationViewSettings = new MyLocationViewSettings(this.mapView, this.mapView.getUserLocationView());
        }
        return this.myLocationViewSettings;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public final CameraPosition getCameraPosition() {
        boolean bl = this.invalidCameraPosition = this.invalidCameraPosition || this.cameraPosition == null;
        if (this.invalidCameraPosition) {
            this.invalidateCameraPosition();
        }
        return this.cameraPosition;
    }

    public void setCameraPosition(@NonNull CameraPosition cameraPosition) {
        this.moveCamera(CameraUpdateFactory.newCameraPosition(cameraPosition));
    }

    @UiThread
    public final void moveCamera(CameraUpdate update) {
        this.moveCamera(update, null);
    }

    @UiThread
    public final void moveCamera(final CameraUpdate update, final CancelableCallback callback) {
        this.mapView.post(new Runnable(){

            @Override
            public void run() {
                MapboxMap.this.cameraPosition = update.getCameraPosition(MapboxMap.this);
                MapboxMap.this.mapView.resetTrackingModesIfRequired(MapboxMap.this.cameraPosition);
                MapboxMap.this.mapView.jumpTo(((MapboxMap)MapboxMap.this).cameraPosition.bearing, ((MapboxMap)MapboxMap.this).cameraPosition.target, ((MapboxMap)MapboxMap.this).cameraPosition.tilt, ((MapboxMap)MapboxMap.this).cameraPosition.zoom);
                if (callback != null) {
                    callback.onFinish();
                }
                if (MapboxMap.this.onCameraChangeListener != null) {
                    MapboxMap.this.onCameraChangeListener.onCameraChange(MapboxMap.this.cameraPosition);
                }
            }
        });
    }

    @UiThread
    public final void easeCamera(CameraUpdate update) {
        this.easeCamera(update, 300);
    }

    @UiThread
    public final void easeCamera(CameraUpdate update, int durationMs) {
        this.easeCamera(update, durationMs, null);
    }

    @UiThread
    public final void easeCamera(CameraUpdate update, int durationMs, CancelableCallback callback) {
        this.easeCamera(update, durationMs, true, callback);
    }

    @UiThread
    public final void easeCamera(CameraUpdate update, int durationMs, boolean easingInterpolator) {
        this.easeCamera(update, durationMs, easingInterpolator, null);
    }

    @UiThread
    public final void easeCamera(CameraUpdate update, int durationMs, boolean easingInterpolator, CancelableCallback callback) {
        this.easeCamera(update, durationMs, easingInterpolator, true, callback);
    }

    @UiThread
    public final void easeCamera(final CameraUpdate update, final int durationMs, final boolean easingInterpolator, final boolean resetTrackingMode, final CancelableCallback callback) {
        this.mapView.post(new Runnable(){

            @Override
            public void run() {
                MapboxMap.this.cameraPosition = update.getCameraPosition(MapboxMap.this);
                if (resetTrackingMode) {
                    MapboxMap.this.mapView.resetTrackingModesIfRequired(MapboxMap.this.cameraPosition);
                }
                MapboxMap.this.mapView.easeTo(((MapboxMap)MapboxMap.this).cameraPosition.bearing, ((MapboxMap)MapboxMap.this).cameraPosition.target, MapboxMap.this.getDurationNano(durationMs), ((MapboxMap)MapboxMap.this).cameraPosition.tilt, ((MapboxMap)MapboxMap.this).cameraPosition.zoom, easingInterpolator, new CancelableCallback(){

                    @Override
                    public void onCancel() {
                        if (callback != null) {
                            callback.onCancel();
                        }
                        MapboxMap.this.invalidateCameraPosition();
                    }

                    @Override
                    public void onFinish() {
                        if (callback != null) {
                            callback.onFinish();
                        }
                        MapboxMap.this.invalidateCameraPosition();
                    }
                });
            }
        });
    }

    @UiThread
    public final void animateCamera(CameraUpdate update) {
        this.animateCamera(update, 300, null);
    }

    @UiThread
    public final void animateCamera(CameraUpdate update, CancelableCallback callback) {
        this.animateCamera(update, 300, callback);
    }

    @UiThread
    public final void animateCamera(CameraUpdate update, int durationMs) {
        this.animateCamera(update, durationMs, null);
    }

    @UiThread
    public final void animateCamera(final CameraUpdate update, final int durationMs, final CancelableCallback callback) {
        this.mapView.post(new Runnable(){

            @Override
            public void run() {
                MapboxMap.this.cameraPosition = update.getCameraPosition(MapboxMap.this);
                MapboxMap.this.mapView.resetTrackingModesIfRequired(MapboxMap.this.cameraPosition);
                MapboxMap.this.mapView.flyTo(((MapboxMap)MapboxMap.this).cameraPosition.bearing, ((MapboxMap)MapboxMap.this).cameraPosition.target, MapboxMap.this.getDurationNano(durationMs), ((MapboxMap)MapboxMap.this).cameraPosition.tilt, ((MapboxMap)MapboxMap.this).cameraPosition.zoom, new CancelableCallback(){

                    @Override
                    public void onCancel() {
                        if (callback != null) {
                            callback.onCancel();
                        }
                        MapboxMap.this.invalidateCameraPosition();
                    }

                    @Override
                    public void onFinish() {
                        if (MapboxMap.this.onCameraChangeListener != null) {
                            MapboxMap.this.onCameraChangeListener.onCameraChange(MapboxMap.this.cameraPosition);
                        }
                        if (callback != null) {
                            callback.onFinish();
                        }
                        MapboxMap.this.invalidateCameraPosition();
                    }
                });
            }
        });
    }

    private long getDurationNano(long durationMs) {
        return durationMs > 0L ? TimeUnit.NANOSECONDS.convert(durationMs, TimeUnit.MILLISECONDS) : 0L;
    }

    private void invalidateCameraPosition() {
        if (this.invalidCameraPosition) {
            this.invalidCameraPosition = false;
            CameraPosition cameraPosition = this.mapView.invalidateCameraPosition();
            if (cameraPosition != null) {
                this.cameraPosition = cameraPosition;
            }
            if (this.onCameraChangeListener != null) {
                this.onCameraChangeListener.onCameraChange(this.cameraPosition);
            }
        }
    }

    public void resetNorth() {
        this.mapView.resetNorth();
    }

    @UiThread
    public boolean isDebugActive() {
        return this.mapView.isDebugActive();
    }

    @UiThread
    public void setDebugActive(boolean debugActive) {
        this.mapView.setDebugActive(debugActive);
    }

    @UiThread
    public void cycleDebugOptions() {
        this.mapView.cycleDebugOptions();
    }

    @UiThread
    public void setStyleUrl(@NonNull String url) {
        this.mapView.setStyleUrl(url);
    }

    @Deprecated
    @UiThread
    public void setStyle(String style2) {
        this.setStyleUrl(style2);
    }

    @UiThread
    @NonNull
    public String getStyleUrl() {
        return this.mapView.getStyleUrl();
    }

    @Deprecated
    @UiThread
    public void setAccessToken(@NonNull String accessToken) {
        this.mapView.setAccessToken(accessToken);
    }

    @Deprecated
    @UiThread
    @Nullable
    public String getAccessToken() {
        return this.mapView.getAccessToken();
    }

    void setTilt(double tilt) {
        this.mapView.setTilt(tilt);
    }

    @UiThread
    @NonNull
    public Marker addMarker(@NonNull MarkerOptions markerOptions) {
        return this.addMarker((BaseMarkerOptions)markerOptions);
    }

    @UiThread
    @NonNull
    public Marker addMarker(@NonNull BaseMarkerOptions markerOptions) {
        Marker marker = this.prepareMarker(markerOptions);
        long id2 = this.mapView.addMarker(marker);
        marker.setMapboxMap(this);
        marker.setId(id2);
        this.annotations.put(id2, (Object)marker);
        return marker;
    }

    @UiThread
    @NonNull
    public MarkerView addMarker(@NonNull BaseMarkerViewOptions markerOptions) {
        MarkerView marker = this.prepareViewMarker(markerOptions);
        marker.setMapboxMap(this);
        long id2 = this.mapView.addMarker(marker);
        marker.setId(id2);
        this.annotations.put(id2, (Object)marker);
        this.markerViewManager.invalidateViewMarkersInVisibleRegion();
        return marker;
    }

    @UiThread
    @NonNull
    public List<MarkerView> addMarkerViews(@NonNull List<? extends BaseMarkerViewOptions> markerViewOptions) {
        ArrayList<MarkerView> markers = new ArrayList<MarkerView>();
        for (BaseMarkerViewOptions baseMarkerViewOptions : markerViewOptions) {
            MarkerView marker = this.prepareViewMarker(baseMarkerViewOptions);
            marker.setMapboxMap(this);
            long id2 = this.mapView.addMarker(marker);
            marker.setId(id2);
            this.annotations.put(id2, (Object)marker);
            markers.add(marker);
        }
        this.markerViewManager.invalidateViewMarkersInVisibleRegion();
        return markers;
    }

    @UiThread
    @NonNull
    public List<Marker> addMarkers(@NonNull List<? extends BaseMarkerOptions> markerOptionsList) {
        int count = markerOptionsList.size();
        ArrayList<Marker> markers = new ArrayList<Marker>(count);
        if (count > 0) {
            long[] ids;
            for (int i = 0; i < count; ++i) {
                BaseMarkerOptions markerOptions = markerOptionsList.get(i);
                Marker marker = this.prepareMarker(markerOptions);
                markers.add(marker);
            }
            if (markers.size() > 0 && ((ids = this.mapView.addMarkers(markers)) == null || ids.length == markers.size())) {
                long id2 = 0L;
                for (int i = 0; i < markers.size(); ++i) {
                    Marker m = (Marker)markers.get(i);
                    m.setMapboxMap(this);
                    id2 = ids != null ? ids[i] : ++id2;
                    m.setId(id2);
                    this.annotations.put(id2, (Object)m);
                }
            }
        }
        return markers;
    }

    @UiThread
    public void updateMarker(@NonNull Marker updatedMarker) {
        this.mapView.updateMarker(updatedMarker);
        int index = this.annotations.indexOfKey(updatedMarker.getId());
        if (index > -1) {
            this.annotations.setValueAt(index, (Object)updatedMarker);
        }
    }

    @UiThread
    public void updatePolygon(Polygon polygon) {
        this.mapView.updatePolygon(polygon);
        int index = this.annotations.indexOfKey(polygon.getId());
        if (index > -1) {
            this.annotations.setValueAt(index, (Object)polygon);
        }
    }

    @UiThread
    public void updatePolyline(Polyline polyline) {
        this.mapView.updatePolyline(polyline);
        int index = this.annotations.indexOfKey(polyline.getId());
        if (index > -1) {
            this.annotations.setValueAt(index, (Object)polyline);
        }
    }

    @UiThread
    @NonNull
    public Polyline addPolyline(@NonNull PolylineOptions polylineOptions) {
        Polyline polyline = polylineOptions.getPolyline();
        if (!polyline.getPoints().isEmpty()) {
            long id2 = this.mapView.addPolyline(polyline);
            polyline.setMapboxMap(this);
            polyline.setId(id2);
            this.annotations.put(id2, (Object)polyline);
        }
        return polyline;
    }

    @UiThread
    @NonNull
    public List<Polyline> addPolylines(@NonNull List<PolylineOptions> polylineOptionsList) {
        int count = polylineOptionsList.size();
        ArrayList<Polyline> polylines = new ArrayList<Polyline>(count);
        if (count > 0) {
            for (PolylineOptions options : polylineOptionsList) {
                Polyline polyline = options.getPolyline();
                if (polyline.getPoints().isEmpty()) continue;
                polylines.add(polyline);
            }
            long[] ids = this.mapView.addPolylines(polylines);
            if (ids == null || ids.length == polylines.size()) {
                long id2 = 0L;
                for (int i = 0; i < polylines.size(); ++i) {
                    Polyline p = (Polyline)polylines.get(i);
                    p.setMapboxMap(this);
                    id2 = ids != null ? ids[i] : ++id2;
                    p.setId(id2);
                    this.annotations.put(id2, (Object)p);
                }
            }
        }
        return polylines;
    }

    @UiThread
    @NonNull
    public Polygon addPolygon(@NonNull PolygonOptions polygonOptions) {
        Polygon polygon = polygonOptions.getPolygon();
        if (!polygon.getPoints().isEmpty()) {
            long id2 = this.mapView.addPolygon(polygon);
            polygon.setId(id2);
            polygon.setMapboxMap(this);
            this.annotations.put(id2, (Object)polygon);
        }
        return polygon;
    }

    @UiThread
    @NonNull
    public List<Polygon> addPolygons(@NonNull List<PolygonOptions> polygonOptionsList) {
        int count = polygonOptionsList.size();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(count);
        if (count > 0) {
            Polygon polygon;
            for (PolygonOptions polygonOptions : polygonOptionsList) {
                polygon = polygonOptions.getPolygon();
                if (polygon.getPoints().isEmpty()) continue;
                polygons.add(polygon);
            }
            long[] ids = this.mapView.addPolygons(polygons);
            if (ids == null || ids.length == polygons.size()) {
                long id2 = 0L;
                for (int i = 0; i < polygons.size(); ++i) {
                    polygon = (Polygon)polygons.get(i);
                    polygon.setMapboxMap(this);
                    id2 = ids != null ? ids[i] : ++id2;
                    polygon.setId(id2);
                    this.annotations.put(id2, (Object)polygon);
                }
            }
        }
        return polygons;
    }

    @UiThread
    public void removeMarker(@NonNull Marker marker) {
        this.removeAnnotation(marker);
    }

    @UiThread
    public void removePolyline(@NonNull Polyline polyline) {
        this.removeAnnotation(polyline);
    }

    @UiThread
    public void removePolygon(@NonNull Polygon polygon) {
        this.removeAnnotation(polygon);
    }

    @UiThread
    public void removeAnnotation(@NonNull Annotation annotation) {
        if (annotation instanceof Marker) {
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (marker instanceof MarkerView) {
                this.markerViewManager.removeMarkerView((MarkerView)marker);
            }
        }
        long id2 = annotation.getId();
        this.mapView.removeAnnotation(id2);
        this.annotations.remove(id2);
    }

    @UiThread
    public void removeAnnotation(long id2) {
        this.mapView.removeAnnotation(id2);
        this.annotations.remove(id2);
    }

    @UiThread
    public void removeAnnotations(@NonNull List<? extends Annotation> annotationList) {
        int count = annotationList.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (annotation instanceof Marker) {
                Marker marker = (Marker)annotation;
                marker.hideInfoWindow();
                if (marker instanceof MarkerView) {
                    this.markerViewManager.removeMarkerView((MarkerView)marker);
                }
            }
            ids[i] = annotationList.get(i).getId();
        }
        this.mapView.removeAnnotations(ids);
        for (long id2 : ids) {
            this.annotations.remove(id2);
        }
    }

    @UiThread
    public void removeAnnotations() {
        int count = this.annotations.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = this.annotations.keyAt(i);
            Annotation annotation = (Annotation)this.annotations.get(ids[i]);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (!(marker instanceof MarkerView)) continue;
            this.markerViewManager.removeMarkerView((MarkerView)marker);
        }
        this.mapView.removeAnnotations(ids);
        this.annotations.clear();
    }

    @UiThread
    public void clear() {
        this.removeAnnotations();
    }

    @Nullable
    public Annotation getAnnotation(long id2) {
        return (Annotation)this.annotations.get(id2);
    }

    @NonNull
    public List<Annotation> getAnnotations() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            annotations.add((Annotation)this.annotations.get(this.annotations.keyAt(i)));
        }
        return annotations;
    }

    @NonNull
    public List<Marker> getMarkers() {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Marker)) continue;
            markers.add((Marker)annotation);
        }
        return markers;
    }

    @NonNull
    public List<Polygon> getPolygons() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Polygon)) continue;
            polygons.add((Polygon)annotation);
        }
        return polygons;
    }

    @NonNull
    public List<Polyline> getPolylines() {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Polyline)) continue;
            polylines.add((Polyline)annotation);
        }
        return polylines;
    }

    @UiThread
    public void selectMarker(@NonNull Marker marker) {
        if (marker == null) {
            Log.w((String)"MapboxMap", (String)"marker was null, so just returning");
            return;
        }
        if (this.selectedMarkers.contains(marker)) {
            return;
        }
        if (!this.isAllowConcurrentMultipleOpenInfoWindows()) {
            this.deselectMarkers();
        }
        boolean handledDefaultClick = false;
        if (this.onMarkerClickListener != null) {
            handledDefaultClick = this.onMarkerClickListener.onMarkerClick(marker);
        }
        if (!handledDefaultClick) {
            if (marker instanceof MarkerView) {
                this.markerViewManager.select((MarkerView)marker, false);
                this.markerViewManager.ensureInfoWindowOffset((MarkerView)marker);
            }
            if (this.isInfoWindowValidForMarker(marker) || this.getInfoWindowAdapter() != null) {
                this.infoWindows.add(marker.showInfoWindow(this, this.mapView));
            }
        }
        this.selectedMarkers.add(marker);
    }

    @UiThread
    public void deselectMarkers() {
        if (this.selectedMarkers.isEmpty()) {
            return;
        }
        for (Marker marker : this.selectedMarkers) {
            if (marker.isInfoWindowShown()) {
                marker.hideInfoWindow();
            }
            if (!(marker instanceof MarkerView)) continue;
            this.markerViewManager.deselect((MarkerView)marker, false);
        }
        this.selectedMarkers.clear();
    }

    @UiThread
    public void deselectMarker(@NonNull Marker marker) {
        if (!this.selectedMarkers.contains(marker)) {
            return;
        }
        if (marker.isInfoWindowShown()) {
            marker.hideInfoWindow();
        }
        if (marker instanceof MarkerView) {
            this.markerViewManager.deselect((MarkerView)marker, false);
        }
        this.selectedMarkers.remove(marker);
    }

    @UiThread
    public List<Marker> getSelectedMarkers() {
        return this.selectedMarkers;
    }

    private Marker prepareMarker(BaseMarkerOptions markerOptions) {
        Object marker = markerOptions.getMarker();
        Icon icon = this.mapView.loadIconForMarker((Marker)marker);
        ((Marker)marker).setTopOffsetPixels(this.mapView.getTopOffsetPixelsForIcon(icon));
        return marker;
    }

    private MarkerView prepareViewMarker(BaseMarkerViewOptions markerViewOptions) {
        Object marker = markerViewOptions.getMarker();
        this.mapView.loadIconForMarkerView((MarkerView)marker);
        return marker;
    }

    public MarkerViewManager getMarkerViewManager() {
        return this.markerViewManager;
    }

    @UiThread
    public void setInfoWindowAdapter(@Nullable InfoWindowAdapter infoWindowAdapter) {
        this.infoWindowAdapter = infoWindowAdapter;
    }

    @UiThread
    @Nullable
    public InfoWindowAdapter getInfoWindowAdapter() {
        return this.infoWindowAdapter;
    }

    @UiThread
    public void setAllowConcurrentMultipleOpenInfoWindows(boolean allow) {
        this.allowConcurrentMultipleInfoWindows = allow;
    }

    @UiThread
    public boolean isAllowConcurrentMultipleOpenInfoWindows() {
        return this.allowConcurrentMultipleInfoWindows;
    }

    List<InfoWindow> getInfoWindows() {
        return this.infoWindows;
    }

    private boolean isInfoWindowValidForMarker(@NonNull Marker marker) {
        return !TextUtils.isEmpty((CharSequence)marker.getTitle()) || !TextUtils.isEmpty((CharSequence)marker.getSnippet());
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.mapView.setContentPadding(left, top, right, bottom);
        this.uiSettings.invalidate();
    }

    public int[] getPadding() {
        return new int[]{this.mapView.getContentPaddingLeft(), this.mapView.getContentPaddingTop(), this.mapView.getContentPaddingRight(), this.mapView.getContentPaddingBottom()};
    }

    @UiThread
    public void setOnCameraChangeListener(@Nullable OnCameraChangeListener listener) {
        this.onCameraChangeListener = listener;
    }

    @UiThread
    public void setOnFpsChangedListener(@Nullable OnFpsChangedListener listener) {
        this.onFpsChangedListener = listener;
    }

    OnFpsChangedListener getOnFpsChangedListener() {
        return this.onFpsChangedListener;
    }

    @UiThread
    public void setOnScrollListener(@Nullable OnScrollListener listener) {
        this.onScrollListener = listener;
    }

    OnScrollListener getOnScrollListener() {
        return this.onScrollListener;
    }

    @UiThread
    public void setOnFlingListener(@Nullable OnFlingListener listener) {
        this.onFlingListener = listener;
    }

    OnFlingListener getOnFlingListener() {
        return this.onFlingListener;
    }

    @UiThread
    public void setOnMapClickListener(@Nullable OnMapClickListener listener) {
        this.onMapClickListener = listener;
    }

    OnMapClickListener getOnMapClickListener() {
        return this.onMapClickListener;
    }

    @UiThread
    public void setOnMapLongClickListener(@Nullable OnMapLongClickListener listener) {
        this.onMapLongClickListener = listener;
    }

    OnMapLongClickListener getOnMapLongClickListener() {
        return this.onMapLongClickListener;
    }

    @UiThread
    public void setOnMarkerClickListener(@Nullable OnMarkerClickListener listener) {
        this.onMarkerClickListener = listener;
    }

    @UiThread
    public void setOnInfoWindowClickListener(@Nullable OnInfoWindowClickListener listener) {
        this.onInfoWindowClickListener = listener;
    }

    @UiThread
    public OnInfoWindowClickListener getOnInfoWindowClickListener() {
        return this.onInfoWindowClickListener;
    }

    @UiThread
    public void setOnInfoWindowLongClickListener(@Nullable OnInfoWindowLongClickListener listener) {
        this.onInfoWindowLongClickListener = listener;
    }

    public OnInfoWindowLongClickListener getOnInfoWindowLongClickListener() {
        return this.onInfoWindowLongClickListener;
    }

    public void setOnInfoWindowCloseListener(@Nullable OnInfoWindowCloseListener listener) {
        this.onInfoWindowCloseListener = listener;
    }

    @UiThread
    public OnInfoWindowCloseListener getOnInfoWindowCloseListener() {
        return this.onInfoWindowCloseListener;
    }

    @UiThread
    public boolean isMyLocationEnabled() {
        return this.myLocationEnabled;
    }

    @UiThread
    public void setMyLocationEnabled(boolean enabled) {
        if (!this.mapView.isPermissionsAccepted()) {
            Log.e((String)"MapboxMap", (String)"Could not activate user location tracking: user did not accept the permission or permissions were not requested.");
            return;
        }
        this.myLocationEnabled = enabled;
        this.mapView.setMyLocationEnabled(enabled);
    }

    @UiThread
    @Nullable
    public Location getMyLocation() {
        return this.mapView.getMyLocation();
    }

    @UiThread
    public void setOnMyLocationChangeListener(@Nullable OnMyLocationChangeListener listener) {
        this.mapView.setOnMyLocationChangeListener(listener);
    }

    @UiThread
    public void setOnMyLocationTrackingModeChangeListener(@Nullable OnMyLocationTrackingModeChangeListener listener) {
        this.onMyLocationTrackingModeChangeListener = listener;
    }

    OnMyLocationTrackingModeChangeListener getOnMyLocationTrackingModeChangeListener() {
        return this.onMyLocationTrackingModeChangeListener;
    }

    @UiThread
    public void setOnMyBearingTrackingModeChangeListener(@Nullable OnMyBearingTrackingModeChangeListener listener) {
        this.onMyBearingTrackingModeChangeListener = listener;
    }

    OnMyBearingTrackingModeChangeListener getOnMyBearingTrackingModeChangeListener() {
        return this.onMyBearingTrackingModeChangeListener;
    }

    MapView getMapView() {
        return this.mapView;
    }

    void setUiSettings(UiSettings uiSettings) {
        this.uiSettings = uiSettings;
    }

    void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void invalidate() {
        this.mapView.invalidate();
    }

    @UiThread
    public void snapshot(@NonNull SnapshotReadyCallback callback, @Nullable Bitmap bitmap) {
        this.mapView.snapshot(callback, bitmap);
    }

    @UiThread
    public void snapshot(@NonNull SnapshotReadyCallback callback) {
        this.mapView.snapshot(callback, null);
    }

    @UiThread
    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull PointF coordinates, String ... layerIds) {
        return this.mapView.getNativeMapView().queryRenderedFeatures(coordinates, layerIds);
    }

    @UiThread
    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull RectF coordinates, String ... layerIds) {
        return this.mapView.getNativeMapView().queryRenderedFeatures(coordinates, layerIds);
    }

    private class MapChangeCameraPositionListener
    implements MapView.OnMapChangedListener {
        private static final long UPDATE_RATE_MS = 400L;
        private long previousUpdateTimestamp = 0L;

        private MapChangeCameraPositionListener() {
        }

        @Override
        public void onMapChanged(int change) {
            if (change >= 0 && change <= 4) {
                MapboxMap.this.invalidCameraPosition = true;
                long currentTime = SystemClock.elapsedRealtime();
                if (currentTime < this.previousUpdateTimestamp) {
                    return;
                }
                MapboxMap.this.invalidateCameraPosition();
                this.previousUpdateTimestamp = currentTime + 400L;
            }
        }
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface CancelableCallback {
        public void onCancel();

        public void onFinish();
    }

    public static interface OnMyBearingTrackingModeChangeListener {
        public void onMyBearingTrackingModeChange(int var1);
    }

    public static interface OnMyLocationTrackingModeChangeListener {
        public void onMyLocationTrackingModeChange(int var1);
    }

    public static interface OnMyLocationChangeListener {
        public void onMyLocationChange(@Nullable Location var1);
    }

    public static interface OnMarkerViewClickListener {
        public boolean onMarkerClick(@NonNull Marker var1, @NonNull View var2, @NonNull MarkerViewAdapter var3);
    }

    public static abstract class MarkerViewAdapter<U extends MarkerView> {
        private Context context;
        private final Class<U> persistentClass;
        private final Pools.SimplePool<View> viewReusePool;

        public MarkerViewAdapter(Context context) {
            this.context = context;
            this.persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            this.viewReusePool = new Pools.SimplePool(10000);
        }

        @Nullable
        public abstract View getView(@NonNull U var1, @Nullable View var2, @NonNull ViewGroup var3);

        public boolean prepareViewForReuse(@NonNull MarkerView marker, @NonNull View convertView) {
            return true;
        }

        public boolean onSelect(@NonNull U marker, @NonNull View convertView, boolean reselectionFromRecycling) {
            return true;
        }

        public void onDeselect(@NonNull U marker, @NonNull View convertView) {
        }

        public final Class<U> getMarkerClass() {
            return this.persistentClass;
        }

        public final Pools.SimplePool<View> getViewReusePool() {
            return this.viewReusePool;
        }

        public final Context getContext() {
            return this.context;
        }

        public final void releaseView(View view) {
            view.setVisibility(8);
            this.viewReusePool.release((Object)view);
        }
    }

    public static interface InfoWindowAdapter {
        @Nullable
        public View getInfoWindow(@NonNull Marker var1);
    }

    public static interface OnInfoWindowCloseListener {
        public void onInfoWindowClose(Marker var1);
    }

    public static interface OnInfoWindowLongClickListener {
        public void onInfoWindowLongClick(Marker var1);
    }

    public static interface OnInfoWindowClickListener {
        public boolean onInfoWindowClick(@NonNull Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(@NonNull Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(@NonNull LatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(@NonNull LatLng var1);
    }

    public static interface OnFpsChangedListener {
        public void onFpsChanged(double var1);
    }

    public static interface OnCameraChangeListener {
        public void onCameraChange(CameraPosition var1);
    }

    public static interface OnScrollListener {
        public void onScroll();
    }

    public static interface OnFlingListener {
        public void onFling();
    }
}

