/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.Property;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public class SymbolLayer
extends Layer {
    public SymbolLayer(long nativePtr) {
        super(nativePtr);
    }

    public SymbolLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.nativeSetSourceLayer(sourceLayer);
    }

    public SymbolLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public void setFilter(Filter.Statement filter) {
        this.setFilter(filter.toArray());
    }

    public void setFilter(Object[] filter) {
        this.nativeSetFilter(filter);
    }

    public SymbolLayer withFilter(Object[] filter) {
        this.setFilter(filter);
        return this;
    }

    public SymbolLayer withFilter(Filter.Statement filter) {
        this.setFilter(filter);
        return this;
    }

    public SymbolLayer withProperties(Property<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<String> getSymbolPlacement() {
        return new PropertyValue<String>(this.nativeGetSymbolPlacement());
    }

    public PropertyValue<Float> getSymbolSpacing() {
        return new PropertyValue<Float>(this.nativeGetSymbolSpacing());
    }

    public PropertyValue<Boolean> getSymbolAvoidEdges() {
        return new PropertyValue<Boolean>(this.nativeGetSymbolAvoidEdges());
    }

    public PropertyValue<Boolean> getIconAllowOverlap() {
        return new PropertyValue<Boolean>(this.nativeGetIconAllowOverlap());
    }

    public PropertyValue<Boolean> getIconIgnorePlacement() {
        return new PropertyValue<Boolean>(this.nativeGetIconIgnorePlacement());
    }

    public PropertyValue<Boolean> getIconOptional() {
        return new PropertyValue<Boolean>(this.nativeGetIconOptional());
    }

    public PropertyValue<String> getIconRotationAlignment() {
        return new PropertyValue<String>(this.nativeGetIconRotationAlignment());
    }

    public PropertyValue<Float> getIconSize() {
        return new PropertyValue<Float>(this.nativeGetIconSize());
    }

    public PropertyValue<String> getIconTextFit() {
        return new PropertyValue<String>(this.nativeGetIconTextFit());
    }

    public PropertyValue<Float[]> getIconTextFitPadding() {
        return new PropertyValue<Float[]>(this.nativeGetIconTextFitPadding());
    }

    public PropertyValue<String> getIconImage() {
        return new PropertyValue<String>(this.nativeGetIconImage());
    }

    public PropertyValue<Float> getIconRotate() {
        return new PropertyValue<Float>(this.nativeGetIconRotate());
    }

    public PropertyValue<Float> getIconPadding() {
        return new PropertyValue<Float>(this.nativeGetIconPadding());
    }

    public PropertyValue<Boolean> getIconKeepUpright() {
        return new PropertyValue<Boolean>(this.nativeGetIconKeepUpright());
    }

    public PropertyValue<Float[]> getIconOffset() {
        return new PropertyValue<Float[]>(this.nativeGetIconOffset());
    }

    public PropertyValue<String> getTextPitchAlignment() {
        return new PropertyValue<String>(this.nativeGetTextPitchAlignment());
    }

    public PropertyValue<String> getTextRotationAlignment() {
        return new PropertyValue<String>(this.nativeGetTextRotationAlignment());
    }

    public PropertyValue<String> getTextField() {
        return new PropertyValue<String>(this.nativeGetTextField());
    }

    public PropertyValue<String[]> getTextFont() {
        return new PropertyValue<String[]>(this.nativeGetTextFont());
    }

    public PropertyValue<Float> getTextSize() {
        return new PropertyValue<Float>(this.nativeGetTextSize());
    }

    public PropertyValue<Float> getTextMaxWidth() {
        return new PropertyValue<Float>(this.nativeGetTextMaxWidth());
    }

    public PropertyValue<Float> getTextLineHeight() {
        return new PropertyValue<Float>(this.nativeGetTextLineHeight());
    }

    public PropertyValue<Float> getTextLetterSpacing() {
        return new PropertyValue<Float>(this.nativeGetTextLetterSpacing());
    }

    public PropertyValue<String> getTextJustify() {
        return new PropertyValue<String>(this.nativeGetTextJustify());
    }

    public PropertyValue<String> getTextAnchor() {
        return new PropertyValue<String>(this.nativeGetTextAnchor());
    }

    public PropertyValue<Float> getTextMaxAngle() {
        return new PropertyValue<Float>(this.nativeGetTextMaxAngle());
    }

    public PropertyValue<Float> getTextRotate() {
        return new PropertyValue<Float>(this.nativeGetTextRotate());
    }

    public PropertyValue<Float> getTextPadding() {
        return new PropertyValue<Float>(this.nativeGetTextPadding());
    }

    public PropertyValue<Boolean> getTextKeepUpright() {
        return new PropertyValue<Boolean>(this.nativeGetTextKeepUpright());
    }

    public PropertyValue<String> getTextTransform() {
        return new PropertyValue<String>(this.nativeGetTextTransform());
    }

    public PropertyValue<Float[]> getTextOffset() {
        return new PropertyValue<Float[]>(this.nativeGetTextOffset());
    }

    public PropertyValue<Boolean> getTextAllowOverlap() {
        return new PropertyValue<Boolean>(this.nativeGetTextAllowOverlap());
    }

    public PropertyValue<Boolean> getTextIgnorePlacement() {
        return new PropertyValue<Boolean>(this.nativeGetTextIgnorePlacement());
    }

    public PropertyValue<Boolean> getTextOptional() {
        return new PropertyValue<Boolean>(this.nativeGetTextOptional());
    }

    public PropertyValue<Float> getIconOpacity() {
        return new PropertyValue<Float>(this.nativeGetIconOpacity());
    }

    public PropertyValue<String> getIconColor() {
        return new PropertyValue<String>(this.nativeGetIconColor());
    }

    @ColorInt
    public int getIconColorAsInt() {
        PropertyValue<String> value = this.getIconColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("icon-color was set as a Function");
    }

    public PropertyValue<String> getIconHaloColor() {
        return new PropertyValue<String>(this.nativeGetIconHaloColor());
    }

    @ColorInt
    public int getIconHaloColorAsInt() {
        PropertyValue<String> value = this.getIconHaloColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("icon-halo-color was set as a Function");
    }

    public PropertyValue<Float> getIconHaloWidth() {
        return new PropertyValue<Float>(this.nativeGetIconHaloWidth());
    }

    public PropertyValue<Float> getIconHaloBlur() {
        return new PropertyValue<Float>(this.nativeGetIconHaloBlur());
    }

    public PropertyValue<Float[]> getIconTranslate() {
        return new PropertyValue<Float[]>(this.nativeGetIconTranslate());
    }

    public PropertyValue<String> getIconTranslateAnchor() {
        return new PropertyValue<String>(this.nativeGetIconTranslateAnchor());
    }

    public PropertyValue<Float> getTextOpacity() {
        return new PropertyValue<Float>(this.nativeGetTextOpacity());
    }

    public PropertyValue<String> getTextColor() {
        return new PropertyValue<String>(this.nativeGetTextColor());
    }

    @ColorInt
    public int getTextColorAsInt() {
        PropertyValue<String> value = this.getTextColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("text-color was set as a Function");
    }

    public PropertyValue<String> getTextHaloColor() {
        return new PropertyValue<String>(this.nativeGetTextHaloColor());
    }

    @ColorInt
    public int getTextHaloColorAsInt() {
        PropertyValue<String> value = this.getTextHaloColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("text-halo-color was set as a Function");
    }

    public PropertyValue<Float> getTextHaloWidth() {
        return new PropertyValue<Float>(this.nativeGetTextHaloWidth());
    }

    public PropertyValue<Float> getTextHaloBlur() {
        return new PropertyValue<Float>(this.nativeGetTextHaloBlur());
    }

    public PropertyValue<Float[]> getTextTranslate() {
        return new PropertyValue<Float[]>(this.nativeGetTextTranslate());
    }

    public PropertyValue<String> getTextTranslateAnchor() {
        return new PropertyValue<String>(this.nativeGetTextTranslateAnchor());
    }

    private native Object nativeGetSymbolPlacement();

    private native Object nativeGetSymbolSpacing();

    private native Object nativeGetSymbolAvoidEdges();

    private native Object nativeGetIconAllowOverlap();

    private native Object nativeGetIconIgnorePlacement();

    private native Object nativeGetIconOptional();

    private native Object nativeGetIconRotationAlignment();

    private native Object nativeGetIconSize();

    private native Object nativeGetIconTextFit();

    private native Object nativeGetIconTextFitPadding();

    private native Object nativeGetIconImage();

    private native Object nativeGetIconRotate();

    private native Object nativeGetIconPadding();

    private native Object nativeGetIconKeepUpright();

    private native Object nativeGetIconOffset();

    private native Object nativeGetTextPitchAlignment();

    private native Object nativeGetTextRotationAlignment();

    private native Object nativeGetTextField();

    private native Object nativeGetTextFont();

    private native Object nativeGetTextSize();

    private native Object nativeGetTextMaxWidth();

    private native Object nativeGetTextLineHeight();

    private native Object nativeGetTextLetterSpacing();

    private native Object nativeGetTextJustify();

    private native Object nativeGetTextAnchor();

    private native Object nativeGetTextMaxAngle();

    private native Object nativeGetTextRotate();

    private native Object nativeGetTextPadding();

    private native Object nativeGetTextKeepUpright();

    private native Object nativeGetTextTransform();

    private native Object nativeGetTextOffset();

    private native Object nativeGetTextAllowOverlap();

    private native Object nativeGetTextIgnorePlacement();

    private native Object nativeGetTextOptional();

    private native Object nativeGetIconOpacity();

    private native Object nativeGetIconColor();

    private native Object nativeGetIconHaloColor();

    private native Object nativeGetIconHaloWidth();

    private native Object nativeGetIconHaloBlur();

    private native Object nativeGetIconTranslate();

    private native Object nativeGetIconTranslateAnchor();

    private native Object nativeGetTextOpacity();

    private native Object nativeGetTextColor();

    private native Object nativeGetTextHaloColor();

    private native Object nativeGetTextHaloWidth();

    private native Object nativeGetTextHaloBlur();

    private native Object nativeGetTextTranslate();

    private native Object nativeGetTextTranslateAnchor();

    @Override
    protected native void finalize() throws Throwable;
}

