/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.widgets;

import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationView;

public class MyLocationViewSettings {
    private MapView mapView;
    private MyLocationView myLocationView;
    private boolean enabled;
    private Drawable foregroundDrawable;
    private Drawable foregroundBearingDrawable;
    @ColorInt
    private int foregroundTintColor;
    private Drawable backgroundDrawable;
    private int[] backgroundOffset = new int[4];
    @ColorInt
    private int backgroundTintColor;
    private int accuracyAlpha;
    @ColorInt
    private int accuracyTintColor;
    private int[] padding = new int[4];

    public MyLocationViewSettings(MapView mapView, MyLocationView myLocationView) {
        this.mapView = mapView;
        this.myLocationView = myLocationView;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.myLocationView.setEnabled(enabled);
    }

    public void setForegroundDrawable(Drawable foregroundDrawable, Drawable foregroundBearingDrawable) {
        this.foregroundDrawable = foregroundDrawable;
        this.foregroundBearingDrawable = foregroundBearingDrawable;
        this.myLocationView.setForegroundDrawables(foregroundDrawable, foregroundBearingDrawable);
    }

    public Drawable getForegroundDrawable() {
        return this.foregroundDrawable;
    }

    public Drawable getForegroundBearingDrawable() {
        return this.foregroundBearingDrawable;
    }

    public void setForegroundTintColor(@ColorInt int foregroundTintColor) {
        this.foregroundTintColor = foregroundTintColor;
        this.myLocationView.setForegroundDrawableTint(foregroundTintColor);
    }

    public int getForegroundTintColor() {
        return this.foregroundTintColor;
    }

    public void setBackgroundDrawable(Drawable backgroundDrawable, int[] padding) {
        this.backgroundDrawable = backgroundDrawable;
        this.backgroundOffset = padding;
        if (padding != null && padding.length == 4) {
            this.myLocationView.setShadowDrawable(backgroundDrawable, padding[0], padding[1], padding[2], padding[3]);
        } else {
            this.myLocationView.setShadowDrawable(backgroundDrawable);
        }
    }

    public Drawable getBackgroundDrawable() {
        return this.backgroundDrawable;
    }

    public void setBackgroundTintColor(@ColorInt int backgroundTintColor) {
        this.backgroundTintColor = backgroundTintColor;
        this.myLocationView.setShadowDrawableTint(backgroundTintColor);
    }

    public int getBackgroundTintColor() {
        return this.backgroundTintColor;
    }

    public int[] getBackgroundOffset() {
        return this.backgroundOffset;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.padding = new int[]{left, top, right, bottom};
        this.myLocationView.setContentPadding(this.padding);
        this.mapView.invalidateContentPadding();
    }

    public int[] getPadding() {
        return this.padding;
    }

    public int getAccuracyAlpha() {
        return this.accuracyAlpha;
    }

    public void setAccuracyAlpha(@IntRange(from=0L, to=255L) int accuracyAlpha) {
        this.accuracyAlpha = accuracyAlpha;
        this.myLocationView.setAccuracyAlpha(accuracyAlpha);
    }

    public int getAccuracyTintColor() {
        return this.accuracyTintColor;
    }

    public void setAccuracyTintColor(@ColorInt int accuracyTintColor) {
        this.accuracyTintColor = accuracyTintColor;
        this.myLocationView.setAccuracyTint(accuracyTintColor);
    }
}

