/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.VisibleRegion;
import com.mapbox.mapboxsdk.maps.MapView;

public class Projection {
    private final MapView mapView;
    private final float screenDensity;
    private final PointF screenLocationPoint;

    Projection(@NonNull MapView mapView) {
        this.mapView = mapView;
        this.screenLocationPoint = new PointF();
        this.screenDensity = mapView.getContext() != null ? mapView.getContext().getResources().getDisplayMetrics().density : 1.0f;
    }

    public double getMetersPerPixelAtLatitude(@FloatRange(from=-90.0, to=90.0) double latitude) {
        return this.mapView.getMetersPerPixelAtLatitude(latitude);
    }

    public LatLng fromScreenLocation(PointF point) {
        this.screenLocationPoint.set(point.x / this.screenDensity, point.y / this.screenDensity);
        return this.mapView.fromNativeScreenLocation(this.screenLocationPoint);
    }

    public VisibleRegion getVisibleRegion() {
        LatLngBounds.Builder builder = new LatLngBounds.Builder();
        float left = this.mapView.getContentPaddingLeft();
        float right = this.mapView.getWidth() - this.mapView.getContentPaddingRight();
        float top = this.mapView.getContentPaddingTop();
        float bottom = this.mapView.getHeight() - this.mapView.getContentPaddingBottom();
        LatLng topLeft = this.fromScreenLocation(new PointF(left, top));
        LatLng topRight = this.fromScreenLocation(new PointF(right, top));
        LatLng bottomRight = this.fromScreenLocation(new PointF(right, bottom));
        LatLng bottomLeft = this.fromScreenLocation(new PointF(left, bottom));
        builder.include(topLeft).include(topRight).include(bottomRight).include(bottomLeft);
        return new VisibleRegion(topLeft, topRight, bottomLeft, bottomRight, builder.build());
    }

    public PointF toScreenLocation(LatLng location) {
        PointF pointF = this.mapView.toNativeScreenLocation(location);
        pointF.set(pointF.x * this.screenDensity, pointF.y * this.screenDensity);
        return pointF;
    }

    public double calculateZoom(float minScale) {
        return Math.log(this.mapView.getScale() * (double)minScale) / Math.log(2.0);
    }
}

