/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.Property;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public class BackgroundLayer
extends Layer {
    public BackgroundLayer(long nativePtr) {
        super(nativePtr);
    }

    public BackgroundLayer(String layerId) {
        this.initialize(layerId);
    }

    protected native void initialize(String var1);

    public BackgroundLayer withProperties(Property<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<String> getBackgroundColor() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetBackgroundColor());
    }

    @ColorInt
    public int getBackgroundColorAsInt() {
        this.checkValidity();
        PropertyValue<String> value = this.getBackgroundColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("background-color was set as a Function");
    }

    public PropertyValue<String> getBackgroundPattern() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetBackgroundPattern());
    }

    public PropertyValue<Float> getBackgroundOpacity() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetBackgroundOpacity());
    }

    private native Object nativeGetBackgroundColor();

    private native Object nativeGetBackgroundPattern();

    private native Object nativeGetBackgroundOpacity();

    @Override
    protected native void finalize() throws Throwable;
}

