/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.support.annotation.AnimatorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Property;
import android.view.View;

public class AnimatorUtils {
    public static void animate(@NonNull View view, @AnimatorRes int animatorRes, @Nullable OnAnimationEndListener listener) {
        AnimatorUtils.animate(view, animatorRes, -1, listener);
    }

    public static void animate(final View view, @AnimatorRes int animatorRes, int duration, final @Nullable OnAnimationEndListener listener) {
        if (view == null) {
            return;
        }
        view.setLayerType(2, null);
        Animator animator = AnimatorInflater.loadAnimator((Context)view.getContext(), (int)animatorRes);
        if (duration != -1) {
            animator.setDuration((long)duration);
        }
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                view.setLayerType(0, null);
                if (listener != null) {
                    listener.onAnimationEnd();
                }
            }
        });
        animator.setTarget((Object)view);
        animator.start();
    }

    public static void animate(@NonNull View view, @AnimatorRes int animatorRes) {
        AnimatorUtils.animate(view, animatorRes, -1);
    }

    public static void animate(@NonNull View view, @AnimatorRes int animatorRes, int duration) {
        AnimatorUtils.animate(view, animatorRes, duration, null);
    }

    public static void rotate(final @NonNull View view, float rotation) {
        view.setLayerType(2, null);
        ObjectAnimator rotateAnimator = ObjectAnimator.ofFloat((Object)view, (Property)View.ROTATION, (float[])new float[]{view.getRotation(), rotation});
        rotateAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                view.setLayerType(0, null);
            }
        });
        rotateAnimator.start();
    }

    public static void alpha(final @NonNull View convertView, float alpha, final @Nullable OnAnimationEndListener listener) {
        convertView.setLayerType(2, null);
        ObjectAnimator rotateAnimator = ObjectAnimator.ofFloat((Object)convertView, (Property)View.ALPHA, (float[])new float[]{convertView.getAlpha(), alpha});
        rotateAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                convertView.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                convertView.setLayerType(0, null);
                if (listener != null) {
                    listener.onAnimationEnd();
                }
            }
        });
        rotateAnimator.start();
    }

    public static void alpha(@NonNull View convertView, float alpha) {
        AnimatorUtils.alpha(convertView, alpha, null);
    }

    public static interface OnAnimationEndListener {
        public void onAnimationEnd();
    }
}

