/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.mapbox.mapboxsdk.offline.OfflineManager;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.offline.OfflineRegionError;
import com.mapbox.mapboxsdk.offline.OfflineRegionStatus;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class OfflineRegion {
    private static final String LOG_TAG = "OfflineRegion";
    private OfflineManager offlineManager;
    private long mId = 0L;
    private OfflineRegionDefinition mDefinition = null;
    private byte[] mMetadata = null;
    private long mOfflineRegionPtr = 0L;
    private Handler handler;
    public static final int STATE_INACTIVE = 0;
    public static final int STATE_ACTIVE = 1;
    private int state = 0;
    private boolean deliverInactiveMessages = false;

    public boolean isDeliveringInactiveMessages() {
        return this.deliverInactiveMessages;
    }

    public void setDeliverInactiveMessages(boolean deliverInactiveMessages) {
        this.deliverInactiveMessages = deliverInactiveMessages;
    }

    private boolean deliverMessages() {
        if (this.state == 1) {
            return true;
        }
        return this.isDeliveringInactiveMessages();
    }

    private OfflineRegion() {
    }

    public long getID() {
        return this.mId;
    }

    public OfflineRegionDefinition getDefinition() {
        return this.mDefinition;
    }

    public byte[] getMetadata() {
        return this.mMetadata;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler(Looper.getMainLooper());
        }
        return this.handler;
    }

    public void setObserver(final @NonNull OfflineRegionObserver observer) {
        this.setOfflineRegionObserver(new OfflineRegionObserver(){

            @Override
            public void onStatusChanged(final OfflineRegionStatus status) {
                if (OfflineRegion.this.deliverMessages()) {
                    OfflineRegion.this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            observer.onStatusChanged(status);
                        }
                    });
                }
            }

            @Override
            public void onError(final OfflineRegionError error) {
                if (OfflineRegion.this.deliverMessages()) {
                    OfflineRegion.this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            observer.onError(error);
                        }
                    });
                }
            }

            @Override
            public void mapboxTileCountLimitExceeded(final long limit) {
                if (OfflineRegion.this.deliverMessages()) {
                    OfflineRegion.this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            observer.mapboxTileCountLimitExceeded(limit);
                        }
                    });
                }
            }
        });
    }

    public void setDownloadState(int state) {
        this.state = state;
        this.setOfflineRegionDownloadState(state);
    }

    public void getStatus(final @NonNull OfflineRegionStatusCallback callback) {
        this.getOfflineRegionStatus(new OfflineRegionStatusCallback(){

            @Override
            public void onStatus(final OfflineRegionStatus status) {
                OfflineRegion.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onStatus(status);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineRegion.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(error);
                    }
                });
            }
        });
    }

    public void delete(final @NonNull OfflineRegionDeleteCallback callback) {
        this.deleteOfflineRegion(new OfflineRegionDeleteCallback(){

            @Override
            public void onDelete() {
                OfflineRegion.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onDelete();
                        OfflineRegion.this.finalize();
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineRegion.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(error);
                    }
                });
            }
        });
    }

    protected void finalize() {
        try {
            super.finalize();
            this.destroyOfflineRegion();
        }
        catch (Throwable throwable) {
            Log.e((String)LOG_TAG, (String)("Failed to finalize OfflineRegion: " + throwable.getMessage()));
        }
    }

    private native void destroyOfflineRegion();

    private native void setOfflineRegionObserver(OfflineRegionObserver var1);

    private native void setOfflineRegionDownloadState(int var1);

    private native void getOfflineRegionStatus(OfflineRegionStatusCallback var1);

    private native void deleteOfflineRegion(OfflineRegionDeleteCallback var1);

    static {
        System.loadLibrary("mapbox-gl");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DownloadState {
    }

    public static interface OfflineRegionDeleteCallback {
        public void onDelete();

        public void onError(String var1);
    }

    public static interface OfflineRegionStatusCallback {
        public void onStatus(OfflineRegionStatus var1);

        public void onError(String var1);
    }

    public static interface OfflineRegionObserver {
        public void onStatusChanged(OfflineRegionStatus var1);

        public void onError(OfflineRegionError var1);

        public void mapboxTileCountLimitExceeded(long var1);
    }
}

