/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.mapbox.mapboxsdk.style.layers.Property;
import java.util.HashMap;
import java.util.Map;

public class Function<T> {
    private final Stop<Float, T>[] stops;
    private Float base;

    @SafeVarargs
    public static <T> Function<T> zoom(Stop<Float, T> ... stops) {
        return new Function<T>(stops);
    }

    @SafeVarargs
    public static <T> Function<T> zoom(@FloatRange(from=0.0, to=1.0, fromInclusive=false, toInclusive=false) float base, Stop<Float, T> ... stops) {
        return new Function<T>(stops).withBase(base);
    }

    public static <T> Stop<Float, T> stop(float in, Property<T> output) {
        return new Stop(Float.valueOf(in), output.value);
    }

    Function(@NonNull @Size(min=1L) Stop<Float, T>[] stops) {
        this.stops = stops;
    }

    Function<T> withBase(float base) {
        this.base = Float.valueOf(base);
        return this;
    }

    @Nullable
    public Float getBase() {
        return this.base;
    }

    public Stop<Float, T>[] getStops() {
        return this.stops;
    }

    Map<String, Object> toValueObject() {
        Object[] stopsValue = new Object[this.stops.length];
        for (int i = 0; i < stopsValue.length; ++i) {
            Stop<Float, T> stop = this.stops[i];
            stopsValue[i] = stop.toValueObject();
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        if (this.base != null) {
            value.put("base", this.base);
        }
        value.put("stops", stopsValue);
        return value;
    }

    public static class Stop<I, O> {
        public final I in;
        public final O out;

        Stop(I in, O out) {
            this.in = in;
            this.out = out;
        }

        Object[] toValueObject() {
            return new Object[]{this.in, this.out};
        }
    }
}

