/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.graphics.PointF;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.utils.AnimatorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MarkerViewManager {
    private Map<MarkerView, View> markerViewMap;
    private MapboxMap mapboxMap;
    private MapView mapView;
    private List<MapboxMap.MarkerViewAdapter> markerViewAdapters;
    private long viewMarkerBoundsUpdateTime;
    private MapboxMap.OnMarkerViewClickListener onMarkerViewClickListener;
    private ImageMarkerViewAdapter defaultMarkerViewAdapter;

    public MarkerViewManager(@NonNull MapboxMap mapboxMap, @NonNull MapView mapView) {
        this.mapboxMap = mapboxMap;
        this.markerViewAdapters = new ArrayList<MapboxMap.MarkerViewAdapter>();
        this.mapView = mapView;
        this.markerViewMap = new HashMap<MarkerView, View>();
        this.defaultMarkerViewAdapter = new ImageMarkerViewAdapter(mapView.getContext());
        this.markerViewAdapters.add(this.defaultMarkerViewAdapter);
    }

    public void animateRotation(@NonNull MarkerView marker, float rotation) {
        View convertView = this.markerViewMap.get(marker);
        if (convertView != null) {
            AnimatorUtils.rotate(convertView, rotation);
        }
    }

    public void animateAlpha(@NonNull MarkerView marker, float alpha) {
        View convertView = this.markerViewMap.get(marker);
        if (convertView != null) {
            AnimatorUtils.alpha(convertView, alpha);
        }
    }

    public void animateVisible(@NonNull MarkerView marker, boolean visible) {
        View convertView = this.markerViewMap.get(marker);
        if (convertView != null) {
            convertView.setVisibility(visible ? 0 : 8);
        }
    }

    public void update() {
        for (MarkerView marker : this.markerViewMap.keySet()) {
            View convertView = this.markerViewMap.get(marker);
            if (convertView == null) continue;
            PointF point = this.mapboxMap.getProjection().toScreenLocation(marker.getPosition());
            if (marker.getOffsetX() == -1.0f) {
                int x = (int)(marker.getAnchorU() * (float)convertView.getMeasuredWidth());
                int y = (int)(marker.getAnchorV() * (float)convertView.getMeasuredHeight());
                marker.setOffset(x, y);
            }
            convertView.setX(point.x - marker.getOffsetX());
            convertView.setY(point.y - marker.getOffsetY());
            if (!marker.isVisible() || convertView.getVisibility() != 8) continue;
            convertView.animate().cancel();
            convertView.setAlpha(0.0f);
            AnimatorUtils.alpha(convertView, 1.0f);
        }
    }

    public void setTilt(float tilt) {
        for (MarkerView markerView : this.markerViewMap.keySet()) {
            View convertView;
            if (!markerView.isFlat() || (convertView = this.markerViewMap.get(markerView)) == null) continue;
            markerView.setTilt(tilt);
            convertView.setRotationX(tilt);
        }
    }

    public void updateIcon(@NonNull MarkerView markerView) {
        View convertView = this.markerViewMap.get(markerView);
        if (convertView != null && convertView instanceof ImageView) {
            ((ImageView)convertView).setImageBitmap(markerView.getIcon().getBitmap());
        }
    }

    public void deselect(@NonNull MarkerView marker) {
        View convertView = this.markerViewMap.get(marker);
        if (convertView != null) {
            for (MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
                if (!adapter.getMarkerClass().equals(marker.getClass())) continue;
                adapter.onDeselect(marker, convertView);
            }
        }
    }

    public void select(@NonNull MarkerView marker) {
        View convertView = this.markerViewMap.get(marker);
        for (MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
            if (!adapter.getMarkerClass().equals(marker.getClass())) continue;
            this.select(marker, convertView, adapter);
        }
    }

    public void select(@NonNull MarkerView marker, View convertView, MapboxMap.MarkerViewAdapter adapter) {
        if (convertView != null) {
            if (adapter.onSelect(marker, convertView, false)) {
                this.mapboxMap.selectMarker(marker);
            }
            marker.setSelected(true);
            convertView.bringToFront();
        }
    }

    @Nullable
    public View getView(MarkerView marker) {
        return this.markerViewMap.get(marker);
    }

    public void removeMarkerView(MarkerView marker) {
        View viewHolder = this.markerViewMap.get(marker);
        if (viewHolder != null && marker != null) {
            for (MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
                if (!adapter.getMarkerClass().equals(marker.getClass()) || !adapter.prepareViewForReuse(marker, viewHolder)) continue;
                marker.setOffset(-1.0f, -1.0f);
                adapter.releaseView(viewHolder);
            }
        }
        this.markerViewMap.remove(marker);
    }

    public void addMarkerViewAdapter(MapboxMap.MarkerViewAdapter markerViewAdapter) {
        if (markerViewAdapter.getMarkerClass().equals(MarkerView.class)) {
            throw new RuntimeException("Providing a custom MarkerViewAdapter requires subclassing MarkerView");
        }
        if (!this.markerViewAdapters.contains(markerViewAdapter)) {
            this.markerViewAdapters.add(markerViewAdapter);
            this.invalidateViewMarkersInBounds();
        }
    }

    public List<MapboxMap.MarkerViewAdapter> getMarkerViewAdapters() {
        return this.markerViewAdapters;
    }

    public void setOnMarkerViewClickListener(@Nullable MapboxMap.OnMarkerViewClickListener listener) {
        this.onMarkerViewClickListener = listener;
    }

    public void scheduleViewMarkerInvalidation() {
        if (!this.markerViewAdapters.isEmpty()) {
            long currentTime = SystemClock.elapsedRealtime();
            if (currentTime < this.viewMarkerBoundsUpdateTime) {
                return;
            }
            this.invalidateViewMarkersInBounds();
            this.viewMarkerBoundsUpdateTime = currentTime + 250L;
        }
    }

    public void invalidateViewMarkersInBounds() {
        View convertView;
        Projection projection = this.mapboxMap.getProjection();
        List<MarkerView> markers = this.mapView.getMarkerViewsInBounds(projection.getVisibleRegion().latLngBounds);
        Iterator<MarkerView> iterator = this.markerViewMap.keySet().iterator();
        while (iterator.hasNext()) {
            MarkerView m = iterator.next();
            if (markers.contains(m)) continue;
            convertView = this.markerViewMap.get(m);
            for (MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
                if (!adapter.getMarkerClass().equals(m.getClass())) continue;
                adapter.prepareViewForReuse(m, convertView);
                adapter.releaseView(convertView);
                iterator.remove();
            }
        }
        for (final MarkerView marker : markers) {
            if (this.markerViewMap.containsKey(marker)) continue;
            for (final MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
                View adaptedView;
                if (!adapter.getMarkerClass().equals(marker.getClass()) || (adaptedView = adapter.getView(marker, convertView = (View)adapter.getViewReusePool().acquire(), (ViewGroup)this.mapView)) == null) continue;
                adaptedView.setRotationX(marker.getTilt());
                adaptedView.setRotation(marker.getRotation());
                adaptedView.setAlpha(marker.getAlpha());
                adaptedView.setVisibility(8);
                if (this.mapboxMap.getSelectedMarkers().contains(marker) && adapter.onSelect(marker, adaptedView, true)) {
                    this.mapboxMap.selectMarker(marker);
                }
                adaptedView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        boolean clickHandled = false;
                        if (MarkerViewManager.this.onMarkerViewClickListener != null) {
                            clickHandled = MarkerViewManager.this.onMarkerViewClickListener.onMarkerClick(marker, v, adapter);
                        }
                        if (!clickHandled) {
                            MarkerViewManager.this.ensureInfoWindowOffset(marker);
                            MarkerViewManager.this.select(marker, v, adapter);
                        }
                    }
                });
                this.markerViewMap.put(marker, adaptedView);
                if (convertView != null) continue;
                adaptedView.setVisibility(8);
                this.mapView.getMarkerViewContainer().addView(adaptedView);
            }
        }
    }

    public void ensureInfoWindowOffset(MarkerView marker) {
        View view = null;
        if (this.markerViewMap.containsKey(marker)) {
            view = this.markerViewMap.get(marker);
        } else {
            for (MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
                if (!adapter.getMarkerClass().equals(marker.getClass())) continue;
                View convertView = (View)adapter.getViewReusePool().acquire();
                view = adapter.getView(marker, convertView, (ViewGroup)this.mapView);
                break;
            }
        }
        if (view != null) {
            if (view.getMeasuredWidth() == 0) {
                view.measure(0, 0);
            }
            if (marker.getOffsetX() == -1.0f) {
                int x = (int)(marker.getAnchorU() * (float)view.getMeasuredWidth());
                int y = (int)(marker.getAnchorV() * (float)view.getMeasuredHeight());
                marker.setOffset(x, y);
            }
            int infoWindowOffsetX = (int)((float)view.getMeasuredWidth() * marker.getInfoWindowAnchorU() - marker.getOffsetX());
            int infoWindowOffsetY = (int)((float)view.getMeasuredHeight() * marker.getInfoWindowAnchorV() - marker.getOffsetY());
            marker.setTopOffsetPixels(infoWindowOffsetY);
            marker.setRightOffsetPixels(infoWindowOffsetX);
        }
    }

    public static class ImageMarkerViewAdapter
    extends MapboxMap.MarkerViewAdapter<MarkerView> {
        private LayoutInflater inflater;

        public ImageMarkerViewAdapter(Context context) {
            super(context);
            this.inflater = LayoutInflater.from((Context)context);
        }

        @Override
        @Nullable
        public View getView(@NonNull MarkerView marker, @Nullable View convertView, @NonNull ViewGroup parent) {
            ViewHolder viewHolder;
            if (convertView == null) {
                viewHolder = new ViewHolder();
                convertView = this.inflater.inflate(R.layout.view_image_marker, parent, false);
                viewHolder.imageView = (ImageView)convertView.findViewById(R.id.image);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            viewHolder.imageView.setImageBitmap(marker.getIcon().getBitmap());
            return convertView;
        }

        private static class ViewHolder {
            ImageView imageView;

            private ViewHolder() {
            }
        }
    }
}

