/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.camera;

import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.FloatRange;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.utils.MathUtils;

public final class CameraPosition
implements Parcelable {
    public static final Parcelable.Creator<CameraPosition> CREATOR = new Parcelable.Creator<CameraPosition>(){

        public CameraPosition createFromParcel(Parcel in) {
            double bearing = in.readDouble();
            LatLng target = (LatLng)in.readParcelable(LatLng.class.getClassLoader());
            double tilt = in.readDouble();
            double zoom = in.readDouble();
            return new CameraPosition(target, zoom, tilt, bearing);
        }

        public CameraPosition[] newArray(int size) {
            return new CameraPosition[size];
        }
    };
    public final double bearing;
    public final LatLng target;
    public final double tilt;
    public final double zoom;

    CameraPosition(LatLng target, double zoom, double tilt, double bearing) {
        this.target = target;
        this.bearing = bearing;
        this.tilt = tilt;
        this.zoom = zoom;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeDouble(this.bearing);
        out.writeParcelable((Parcelable)this.target, flags);
        out.writeDouble(this.tilt);
        out.writeDouble(this.zoom);
    }

    public String toString() {
        return "Target: " + this.target + ", Zoom:" + this.zoom + ", Bearing:" + this.bearing + ", Tilt:" + this.tilt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CameraPosition cameraPosition = (CameraPosition)o;
        if (this.target != null && !this.target.equals(cameraPosition.target)) {
            return false;
        }
        if (this.zoom != cameraPosition.zoom) {
            return false;
        }
        if (this.tilt != cameraPosition.tilt) {
            return false;
        }
        return this.bearing == cameraPosition.bearing;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private double bearing = -1.0;
        private LatLng target = null;
        private double tilt = -1.0;
        private double zoom = -1.0;
        private boolean isRadiant;

        public Builder() {
        }

        public Builder(boolean isRadiant) {
            this.isRadiant = isRadiant;
        }

        public Builder(CameraPosition previous) {
            if (previous != null) {
                this.bearing = previous.bearing;
                this.target = previous.target;
                this.tilt = previous.tilt;
                this.zoom = previous.zoom;
            }
        }

        public Builder(TypedArray typedArray) {
            if (typedArray != null) {
                this.bearing = typedArray.getFloat(R.styleable.MapView_direction, 0.0f);
                double lat = typedArray.getFloat(R.styleable.MapView_center_latitude, 0.0f);
                double lng = typedArray.getFloat(R.styleable.MapView_center_longitude, 0.0f);
                this.target = new LatLng(lat, lng);
                this.tilt = typedArray.getFloat(R.styleable.MapView_tilt, 0.0f);
                this.zoom = typedArray.getFloat(R.styleable.MapView_zoom, 0.0f);
            }
        }

        public Builder(CameraUpdateFactory.CameraPositionUpdate update) {
            if (update != null) {
                this.bearing = update.getBearing();
                this.target = update.getTarget();
                this.tilt = update.getTilt();
                this.zoom = update.getZoom();
            }
        }

        public Builder(CameraUpdateFactory.ZoomUpdate update) {
            if (update != null) {
                this.zoom = update.getZoom();
            }
        }

        public Builder(double[] values) {
            if (values != null && values.length == 5) {
                this.target = new LatLng(values[0], values[1]);
                this.bearing = (float)values[2];
                this.tilt = (float)values[3];
                this.zoom = (float)values[4];
            }
        }

        public Builder bearing(double bearing) {
            this.bearing = this.isRadiant ? bearing : (double)((float)(-bearing * (Math.PI / 180)));
            return this;
        }

        public CameraPosition build() {
            return new CameraPosition(this.target, this.zoom, this.tilt, this.bearing);
        }

        public Builder target(LatLng location) {
            this.target = location;
            return this;
        }

        @FloatRange(from=0.0, to=60.0)
        public Builder tilt(double tilt) {
            this.tilt = this.isRadiant ? tilt : (double)((float)(MathUtils.clamp(tilt, 0.0, 60.0) * (Math.PI / 180)));
            return this;
        }

        public Builder zoom(double zoom) {
            this.zoom = zoom;
            return this;
        }
    }
}

