/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.camera;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.utils.MathUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class CameraUpdateFactory {
    public static CameraUpdate newCameraPosition(@NonNull CameraPosition cameraPosition) {
        return new CameraPositionUpdate(cameraPosition.bearing, cameraPosition.target, cameraPosition.tilt, cameraPosition.zoom);
    }

    public static CameraUpdate newLatLng(@NonNull LatLng latLng) {
        return new CameraPositionUpdate(-1.0, latLng, -1.0, -1.0);
    }

    public static CameraUpdate newLatLngBounds(@NonNull LatLngBounds bounds, int padding) {
        return CameraUpdateFactory.newLatLngBounds(bounds, padding, padding, padding, padding);
    }

    public static CameraUpdate newLatLngBounds(@NonNull LatLngBounds bounds, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        return new CameraBoundsUpdate(bounds, paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    public static CameraUpdate newLatLngZoom(@NonNull LatLng latLng, float zoom) {
        return new CameraPositionUpdate(-1.0, latLng, -1.0, zoom);
    }

    public static CameraUpdate scrollBy(float xPixel, float yPixel) {
        return new CameraMoveUpdate(xPixel, yPixel);
    }

    public static CameraUpdate zoomBy(float amount, Point focus) {
        return new ZoomUpdate(amount, focus.x, focus.y);
    }

    public static CameraUpdate zoomBy(float amount) {
        return new ZoomUpdate(2, amount);
    }

    public static CameraUpdate zoomIn() {
        return new ZoomUpdate(0);
    }

    public static CameraUpdate zoomOut() {
        return new ZoomUpdate(1);
    }

    public static CameraUpdate zoomTo(float zoom) {
        return new ZoomUpdate(3, zoom);
    }

    static final class ZoomUpdate
    implements CameraUpdate {
        public static final int ZOOM_IN = 0;
        public static final int ZOOM_OUT = 1;
        public static final int ZOOM_BY = 2;
        public static final int ZOOM_TO = 3;
        public static final int ZOOM_TO_POINT = 4;
        private final int type;
        private final double zoom;
        private float x;
        private float y;

        ZoomUpdate(int type) {
            this.type = type;
            this.zoom = 0.0;
        }

        ZoomUpdate(int type, float zoom) {
            this.type = type;
            this.zoom = zoom;
        }

        ZoomUpdate(float zoom, float x, float y) {
            this.type = 4;
            this.zoom = zoom;
            this.x = x;
            this.y = y;
        }

        public double getZoom() {
            return this.zoom;
        }

        public int getType() {
            return this.type;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public double transformZoom(double currentZoom) {
            switch (this.getType()) {
                case 0: {
                    currentZoom += 1.0;
                    break;
                }
                case 1: {
                    currentZoom -= 1.0;
                    if (!(currentZoom < 0.0)) break;
                    currentZoom = 0.0;
                    break;
                }
                case 3: {
                    currentZoom = this.getZoom();
                    break;
                }
                case 2: {
                    currentZoom += this.getZoom();
                    break;
                }
                case 4: {
                    currentZoom += this.getZoom();
                }
            }
            return currentZoom;
        }

        @Override
        public CameraPosition getCameraPosition(@NonNull MapboxMap mapboxMap) {
            CameraPosition cameraPosition = mapboxMap.getCameraPosition();
            if (this.getType() != 4) {
                return new CameraPosition.Builder(cameraPosition).zoom(this.transformZoom(cameraPosition.zoom)).build();
            }
            return new CameraPosition.Builder(cameraPosition).zoom(this.transformZoom(cameraPosition.zoom)).target(mapboxMap.getProjection().fromScreenLocation(new PointF(this.getX(), this.getY()))).build();
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Type {
        }
    }

    static final class CameraMoveUpdate
    implements CameraUpdate {
        private float x;
        private float y;

        public CameraMoveUpdate(float x, float y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public CameraPosition getCameraPosition(@NonNull MapboxMap mapboxMap) {
            UiSettings uiSettings = mapboxMap.getUiSettings();
            Projection projection = mapboxMap.getProjection();
            float viewPortWidth = uiSettings.getWidth();
            float viewPortHeight = uiSettings.getHeight();
            PointF targetPoint = new PointF(viewPortWidth / 2.0f + this.x, viewPortHeight / 2.0f + this.y);
            LatLng latLng = projection.fromScreenLocation(targetPoint);
            CameraPosition previousPosition = mapboxMap.getCameraPosition();
            if (latLng != null) {
                return new CameraPosition.Builder().target(latLng).zoom(previousPosition.zoom).tilt(previousPosition.tilt).bearing(previousPosition.bearing).build();
            }
            return new CameraPosition.Builder(true).tilt(previousPosition.tilt).zoom(previousPosition.zoom).bearing(previousPosition.bearing).target(previousPosition.target).build();
        }
    }

    static final class CameraBoundsUpdate
    implements CameraUpdate {
        private LatLngBounds bounds;
        private RectF padding;

        public CameraBoundsUpdate(LatLngBounds bounds, RectF padding) {
            this.bounds = bounds;
            this.padding = padding;
        }

        public CameraBoundsUpdate(LatLngBounds bounds, int[] padding) {
            this(bounds, new RectF((float)padding[0], (float)padding[1], (float)padding[2], (float)padding[3]));
        }

        public CameraBoundsUpdate(LatLngBounds bounds, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
            this(bounds, new int[]{paddingLeft, paddingTop, paddingRight, paddingBottom});
        }

        public LatLngBounds getBounds() {
            return this.bounds;
        }

        public RectF getPadding() {
            return this.padding;
        }

        @Override
        public CameraPosition getCameraPosition(@NonNull MapboxMap mapboxMap) {
            Projection projection = mapboxMap.getProjection();
            UiSettings uiSettings = mapboxMap.getUiSettings();
            int[] mapPadding = mapboxMap.getPadding();
            RectF latLngPadding = this.getPadding();
            RectF padding = new RectF(latLngPadding.left + (float)mapPadding[0], latLngPadding.top + (float)mapPadding[1], latLngPadding.right + (float)mapPadding[2], latLngPadding.bottom + (float)mapPadding[3]);
            PointF nePixel = new PointF(-3.4028235E38f, -3.4028235E38f);
            PointF swPixel = new PointF(Float.MAX_VALUE, Float.MAX_VALUE);
            float viewportHeight = uiSettings.getHeight();
            for (LatLng latLng : this.getBounds().toLatLngs()) {
                PointF pixel = projection.toScreenLocation(latLng);
                swPixel.x = Math.min(swPixel.x, pixel.x);
                nePixel.x = Math.max(nePixel.x, pixel.x);
                swPixel.y = Math.min(swPixel.y, viewportHeight - pixel.y);
                nePixel.y = Math.max(nePixel.y, viewportHeight - pixel.y);
            }
            float width = nePixel.x - swPixel.x;
            float height = nePixel.y - swPixel.y;
            double zoom = 0.0;
            float minScale = 1.0f;
            if (padding != null) {
                float scaleY;
                float scaleX = (uiSettings.getWidth() - padding.left - padding.right) / width;
                minScale = scaleX < (scaleY = (uiSettings.getHeight() - padding.top - padding.bottom) / height) ? scaleX : scaleY;
                zoom = projection.calculateZoom(minScale);
                zoom = MathUtils.clamp(zoom, (double)((float)mapboxMap.getMinZoom()), (double)((float)mapboxMap.getMaxZoom()));
            }
            PointF paddedNEPixel = new PointF(nePixel.x + padding.right / minScale, nePixel.y + padding.top / minScale);
            PointF paddedSWPixel = new PointF(swPixel.x - padding.left / minScale, swPixel.y - padding.bottom / minScale);
            PointF centerPixel = new PointF((paddedNEPixel.x + paddedSWPixel.x) / 2.0f, (paddedNEPixel.y + paddedSWPixel.y) / 2.0f);
            centerPixel.y = viewportHeight - centerPixel.y;
            LatLng center = projection.fromScreenLocation(centerPixel);
            return new CameraPosition.Builder().target(center).zoom((float)zoom).tilt(0.0).bearing(0.0).build();
        }
    }

    static final class CameraPositionUpdate
    implements CameraUpdate {
        private final double bearing;
        private final LatLng target;
        private final double tilt;
        private final double zoom;

        CameraPositionUpdate(double bearing, LatLng target, double tilt, double zoom) {
            this.bearing = bearing;
            this.target = target;
            this.tilt = tilt;
            this.zoom = zoom;
        }

        public LatLng getTarget() {
            return this.target;
        }

        public double getBearing() {
            return this.bearing;
        }

        public double getTilt() {
            return this.tilt;
        }

        public double getZoom() {
            return this.zoom;
        }

        @Override
        public CameraPosition getCameraPosition(@NonNull MapboxMap mapboxMap) {
            CameraPosition previousPosition = mapboxMap.getCameraPosition();
            if (this.target == null) {
                return new CameraPosition.Builder(true).tilt(this.tilt).zoom(this.zoom).bearing(this.bearing).target(previousPosition.target).build();
            }
            return new CameraPosition.Builder(this).build();
        }
    }
}

