/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.BaseMarkerViewOptions;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.InfoWindow;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;

public class Marker
extends Annotation {
    private LatLng position;
    private String snippet;
    private Icon icon;
    private String title;
    private InfoWindow infoWindow;
    private boolean infoWindowShown;
    private int topOffsetPixels;
    private int rightOffsetPixels;

    Marker() {
    }

    public Marker(BaseMarkerOptions baseMarkerOptions) {
        this.position = baseMarkerOptions.position;
        this.snippet = baseMarkerOptions.snippet;
        this.icon = baseMarkerOptions.icon;
        this.title = baseMarkerOptions.title;
    }

    Marker(BaseMarkerViewOptions baseMarkerViewOptions) {
        this.position = baseMarkerViewOptions.position;
        this.snippet = baseMarkerViewOptions.snippet;
        this.icon = baseMarkerViewOptions.icon;
        this.title = baseMarkerViewOptions.title;
    }

    public LatLng getPosition() {
        return this.position;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public String getTitle() {
        return this.title;
    }

    public void hideInfoWindow() {
        if (this.infoWindow != null) {
            this.infoWindow.close();
        }
        this.infoWindowShown = false;
    }

    public boolean isInfoWindowShown() {
        return this.infoWindowShown;
    }

    public void setPosition(LatLng position) {
        this.position = position;
        MapboxMap map = this.getMapboxMap();
        if (map != null) {
            map.updateMarker(this);
        }
    }

    void setSnippet(String snippet) {
        this.snippet = snippet;
    }

    public void setIcon(@Nullable Icon icon) {
        this.icon = icon;
        MapboxMap map = this.getMapboxMap();
        if (map != null) {
            map.updateMarker(this);
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    void setTitle(String title) {
        this.title = title;
    }

    public InfoWindow showInfoWindow(@NonNull MapboxMap mapboxMap, @NonNull MapView mapView) {
        View content;
        this.setMapboxMap(mapboxMap);
        MapboxMap.InfoWindowAdapter infoWindowAdapter = this.getMapboxMap().getInfoWindowAdapter();
        if (infoWindowAdapter != null && (content = infoWindowAdapter.getInfoWindow(this)) != null) {
            this.infoWindow = new InfoWindow(content, mapboxMap);
            this.showInfoWindow(this.infoWindow, mapView);
            return this.infoWindow;
        }
        InfoWindow infoWindow = this.getInfoWindow(mapView);
        if (mapView.getContext() != null) {
            infoWindow.adaptDefaultMarker(this, mapboxMap, mapView);
        }
        return this.showInfoWindow(infoWindow, mapView);
    }

    private InfoWindow showInfoWindow(InfoWindow iw, MapView mapView) {
        iw.open(mapView, this, this.getPosition(), this.rightOffsetPixels, this.topOffsetPixels);
        this.infoWindowShown = true;
        return iw;
    }

    private InfoWindow getInfoWindow(@NonNull MapView mapView) {
        if (this.infoWindow == null && mapView.getContext() != null) {
            this.infoWindow = new InfoWindow(mapView, R.layout.infowindow_view, this.getMapboxMap());
        }
        return this.infoWindow;
    }

    public void setTopOffsetPixels(int topOffsetPixels) {
        this.topOffsetPixels = topOffsetPixels;
    }

    public void setRightOffsetPixels(int rightOffsetPixels) {
        this.rightOffsetPixels = rightOffsetPixels;
    }

    public String toString() {
        return "Marker [position[" + this.getPosition() + "]]";
    }
}

