/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import com.mapbox.mapboxsdk.annotations.BaseMarkerViewOptions;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerViewManager;
import com.mapbox.mapboxsdk.maps.MapboxMap;

public class MarkerView
extends Marker {
    private MarkerViewManager markerViewManager;
    private float anchorU;
    private float anchorV;
    private float offsetX;
    private float offsetY;
    private float infoWindowAnchorU;
    private float infoWindowAnchorV;
    private boolean flat;
    private boolean visible = true;
    private int selectAnimRes;
    private int deselectAnimRes;
    private float tiltValue;
    private float rotation;
    private float alpha = 1.0f;

    MarkerView() {
    }

    public MarkerView(BaseMarkerViewOptions baseMarkerViewOptions) {
        super(baseMarkerViewOptions);
        this.anchorU = baseMarkerViewOptions.getAnchorU();
        this.anchorV = baseMarkerViewOptions.getAnchorV();
        this.infoWindowAnchorU = baseMarkerViewOptions.getInfoWindowAnchorU();
        this.infoWindowAnchorV = baseMarkerViewOptions.getInfoWindowAnchorV();
        this.flat = baseMarkerViewOptions.isFlat();
        this.selectAnimRes = baseMarkerViewOptions.getSelectAnimRes();
        this.deselectAnimRes = baseMarkerViewOptions.getDeselectAnimRes();
        this.infoWindowAnchorU = baseMarkerViewOptions.infoWindowAnchorU;
        this.infoWindowAnchorV = baseMarkerViewOptions.infoWindowAnchorV;
        this.anchorU = baseMarkerViewOptions.anchorU;
        this.anchorV = baseMarkerViewOptions.anchorV;
    }

    public void setAnchor(float u, float v) {
        this.anchorU = u;
        this.anchorV = v;
    }

    public float getAnchorU() {
        return this.anchorU;
    }

    public float getAnchorV() {
        return this.anchorV;
    }

    void setOffsetX(float x) {
        this.offsetX = x;
    }

    void setOffsetY(float y) {
        this.offsetY = y;
    }

    float getOffsetX() {
        return this.offsetX;
    }

    float getOffsetY() {
        return this.offsetY;
    }

    public void setInfoWindowAnchor(float u, float v) {
        this.infoWindowAnchorU = u;
        this.infoWindowAnchorV = v;
    }

    public float getInfoWindowAnchorU() {
        return this.infoWindowAnchorU;
    }

    public float getInfoWindowAnchorV() {
        return this.infoWindowAnchorV;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setFlat(boolean flat) {
        this.flat = flat;
    }

    public int getSelectAnimRes() {
        return this.selectAnimRes;
    }

    public void setSelectAnimRes(int selectAnimRes) {
        this.selectAnimRes = selectAnimRes;
    }

    public int getDeselectAnimRes() {
        return this.deselectAnimRes;
    }

    public void setDeselectAnimRes(int deselectAnimRes) {
        this.deselectAnimRes = deselectAnimRes;
    }

    float getTilt() {
        return this.tiltValue;
    }

    void setTilt(float tiltValue) {
        this.tiltValue = tiltValue;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.markerViewManager != null) {
            this.markerViewManager.animateVisible(this, visible);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
        if (this.markerViewManager != null) {
            this.markerViewManager.animateRotation(this, rotation);
        }
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        if (this.markerViewManager != null) {
            this.markerViewManager.animateAlpha(this, alpha);
        }
    }

    @Override
    public void setMapboxMap(MapboxMap mapboxMap) {
        super.setMapboxMap(mapboxMap);
        this.markerViewManager = mapboxMap.getMarkerViewManager();
    }

    @Override
    public String toString() {
        return "MarkerView [position[" + this.getPosition() + "]]";
    }
}

