/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.app.Fragment;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;

public final class MapFragment
extends Fragment {
    private MapView mMap;
    private OnMapReadyCallback mOnMapReadyCallback;

    public static MapFragment newInstance(@Nullable MapboxMapOptions mapboxMapOptions) {
        MapFragment mapFragment = new MapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapboxMapOptions", (Parcelable)mapboxMapOptions);
        mapFragment.setArguments(bundle);
        return mapFragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        MapboxMapOptions options = (MapboxMapOptions)this.getArguments().getParcelable("MapboxMapOptions");
        this.mMap = new MapView(inflater.getContext(), options);
        return this.mMap;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mMap.onCreate(savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.mMap.getMapAsync(this.mOnMapReadyCallback);
    }

    public void onResume() {
        super.onResume();
        this.mMap.onResume();
    }

    public void onPause() {
        super.onPause();
        this.mMap.onPause();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mMap.onSaveInstanceState(outState);
    }

    public void onStop() {
        super.onStop();
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.mMap.onLowMemory();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mMap.onDestroy();
    }

    public void getMapAsync(@NonNull OnMapReadyCallback onMapReadyCallback) {
        this.mOnMapReadyCallback = onMapReadyCallback;
    }
}

