/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.support.annotation.LayoutRes;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.InfoWindowView;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.views.MapView;
import java.lang.ref.WeakReference;

public class InfoWindow {
    private WeakReference<Marker> mBoundMarker;
    private WeakReference<MapView> mMapView;
    protected WeakReference<View> mView;
    private float mMarkerHeightOffset;
    private float mViewWidthOffset;
    private PointF mCoordinates;
    private boolean mIsVisible;
    @LayoutRes
    private int mLayoutRes;

    InfoWindow(int layoutResId, MapView mapView) {
        this.mLayoutRes = layoutResId;
        View view = LayoutInflater.from((Context)mapView.getContext()).inflate(layoutResId, (ViewGroup)mapView, false);
        this.initialize(view, mapView);
    }

    InfoWindow(View view, MapView mapView) {
        this.initialize(view, mapView);
    }

    private void initialize(View view, MapView mapView) {
        this.mMapView = new WeakReference<MapView>(mapView);
        this.mIsVisible = false;
        this.mView = new WeakReference<View>(view);
        view.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent e) {
                if (e.getAction() == 1) {
                    boolean handledDefaultClick = false;
                    MapView.OnInfoWindowClickListener onInfoWindowClickListener = ((MapView)((Object)InfoWindow.this.mMapView.get())).getOnInfoWindowClickListener();
                    if (onInfoWindowClickListener != null) {
                        handledDefaultClick = onInfoWindowClickListener.onMarkerClick(InfoWindow.this.getBoundMarker());
                    }
                    if (!handledDefaultClick) {
                        InfoWindow.this.close();
                    }
                }
                return true;
            }
        });
    }

    InfoWindow open(MapView mapView, Marker boundMarker, LatLng position, int offsetX, int offsetY) {
        this.setBoundMarker(boundMarker);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
        View view = (View)this.mView.get();
        if (view != null) {
            view.measure(0, 0);
            this.mMarkerHeightOffset = -view.getMeasuredHeight() + offsetY;
            this.mCoordinates = mapView.toScreenLocation(position);
            float x = this.mCoordinates.x - (float)(view.getMeasuredWidth() / 2) + (float)offsetX;
            float y = this.mCoordinates.y - (float)view.getMeasuredHeight() + (float)offsetY;
            if (view instanceof InfoWindowView) {
                Resources resources = mapView.getContext().getResources();
                float rightSideInfowWindow = x + (float)view.getMeasuredWidth();
                float leftSideInfoWindow = x;
                float mapRight = mapView.getRight();
                float mapLeft = mapView.getLeft();
                float marginHorizontal = resources.getDimension(R.dimen.infowindow_margin);
                float tipViewOffset = resources.getDimension(R.dimen.infowindow_tipview_width) / 2.0f;
                float tipViewMarginLeft = (float)(view.getMeasuredWidth() / 2) - tipViewOffset;
                boolean outOfBoundsLeft = false;
                boolean outOfBoundsRight = false;
                if (rightSideInfowWindow > mapRight) {
                    outOfBoundsRight = true;
                    x -= rightSideInfowWindow - mapRight;
                    tipViewMarginLeft += rightSideInfowWindow - mapRight + tipViewOffset;
                    rightSideInfowWindow = x + (float)view.getMeasuredWidth();
                }
                if (leftSideInfoWindow < mapLeft) {
                    outOfBoundsLeft = true;
                    x += mapLeft - leftSideInfoWindow;
                    tipViewMarginLeft -= mapLeft - leftSideInfoWindow + tipViewOffset;
                    leftSideInfoWindow = x;
                }
                if (outOfBoundsRight && mapRight - rightSideInfowWindow < marginHorizontal) {
                    tipViewMarginLeft += marginHorizontal - (mapRight - rightSideInfowWindow) - tipViewOffset;
                    leftSideInfoWindow = x -= marginHorizontal - (mapRight - rightSideInfowWindow);
                }
                if (outOfBoundsLeft && leftSideInfoWindow - mapLeft < marginHorizontal) {
                    x += marginHorizontal - (leftSideInfoWindow - mapLeft);
                    tipViewMarginLeft -= marginHorizontal - (leftSideInfoWindow - mapLeft) - tipViewOffset;
                }
                InfoWindowView infoWindowView = (InfoWindowView)view;
                infoWindowView.setTipViewMarginLeft((int)tipViewMarginLeft);
            }
            view.setX(x);
            view.setY(y);
            this.mViewWidthOffset = x - this.mCoordinates.x - (float)offsetX;
            this.close();
            mapView.addView(view, (ViewGroup.LayoutParams)lp);
            this.mIsVisible = true;
        }
        return this;
    }

    InfoWindow close() {
        if (this.mIsVisible) {
            this.mIsVisible = false;
            View view = (View)this.mView.get();
            if (view != null) {
                ((ViewGroup)view.getParent()).removeView(view);
                this.setBoundMarker(null);
                this.onClose();
            }
        }
        return this;
    }

    void adaptDefaultMarker(Marker overlayItem, MapView mapView) {
        View view = (View)this.mView.get();
        if (view == null) {
            view = LayoutInflater.from((Context)mapView.getContext()).inflate(this.mLayoutRes, (ViewGroup)mapView, false);
            this.initialize(view, mapView);
        }
        this.mMapView = new WeakReference<MapView>(mapView);
        String title = overlayItem.getTitle();
        ((TextView)view.findViewById(R.id.infowindow_title)).setText((CharSequence)title);
        String snippet = overlayItem.getSnippet();
        ((TextView)view.findViewById(R.id.infowindow_description)).setText((CharSequence)snippet);
    }

    private void onClose() {
        ((MapView)((Object)this.mMapView.get())).deselectMarker(this.getBoundMarker());
    }

    InfoWindow setBoundMarker(Marker boundMarker) {
        this.mBoundMarker = new WeakReference<Marker>(boundMarker);
        return this;
    }

    Marker getBoundMarker() {
        if (this.mBoundMarker == null) {
            return null;
        }
        return (Marker)this.mBoundMarker.get();
    }

    public void update() {
        MapView mapView = (MapView)((Object)this.mMapView.get());
        Marker marker = (Marker)this.mBoundMarker.get();
        View view = (View)this.mView.get();
        if (mapView != null && marker != null && view != null) {
            this.mCoordinates = mapView.toScreenLocation(marker.getPosition());
            view.setX(this.mCoordinates.x + this.mViewWidthOffset);
            view.setY(this.mCoordinates.y + this.mMarkerHeightOffset);
        }
    }
}

