/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.camera;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.FloatRange;
import com.mapbox.mapboxsdk.geometry.LatLng;

public final class CameraPosition
implements Parcelable {
    public static final Parcelable.Creator<CameraPosition> CREATOR = new Parcelable.Creator<CameraPosition>(){

        public CameraPosition createFromParcel(Parcel in) {
            float bearing = in.readFloat();
            LatLng target = (LatLng)in.readParcelable(LatLng.class.getClassLoader());
            float tilt = in.readFloat();
            float zoom = in.readFloat();
            return new CameraPosition(target, zoom, tilt, bearing);
        }

        public CameraPosition[] newArray(int size) {
            return new CameraPosition[size];
        }
    };
    public final float bearing;
    public final LatLng target;
    public final float tilt;
    public final float zoom;

    public CameraPosition(LatLng target, float zoom, float tilt, float bearing) throws NullPointerException, IllegalArgumentException {
        if (target == null) {
            throw new NullPointerException("target is NULL");
        }
        this.target = target;
        if (tilt != -1.0f && (tilt < 0.0f || tilt > 90.0f)) {
            throw new IllegalArgumentException("tilt is outside of 0 to 90 degrees range");
        }
        this.tilt = tilt;
        this.bearing = bearing;
        this.zoom = zoom;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeFloat(this.bearing);
        out.writeParcelable((Parcelable)this.target, flags);
        out.writeFloat(this.tilt);
        out.writeFloat(this.zoom);
    }

    public static final class Builder {
        private float bearing = -1.0f;
        private LatLng target = null;
        private float tilt = -1.0f;
        private float zoom = -1.0f;

        public Builder() {
        }

        public Builder(CameraPosition previous) {
            if (previous != null) {
                this.bearing = previous.bearing;
                this.target = previous.target;
                this.tilt = previous.tilt;
                this.zoom = previous.zoom;
            }
        }

        public Builder bearing(float bearing) {
            this.bearing = bearing;
            return this;
        }

        public CameraPosition build() {
            return new CameraPosition(this.target, this.zoom, this.tilt, this.bearing);
        }

        public Builder target(LatLng location) {
            this.target = location;
            return this;
        }

        @FloatRange(from=0.0, to=60.0)
        public Builder tilt(float tilt) {
            this.tilt = tilt;
            return this;
        }

        public Builder zoom(float zoom) {
            this.zoom = zoom;
            return this;
        }
    }
}

