/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Sprite;
import com.mapbox.mapboxsdk.exceptions.TooManySpritesException;
import com.mapbox.mapboxsdk.views.MapView;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public final class SpriteFactory {
    private static final String SPRITE_ID_PREFIX = "com.mapbox.sprites.sprite_";
    private MapView mMapView;
    private Sprite mDefaultMarker;
    private BitmapFactory.Options mOptions;
    private int mNextId = 0;

    public SpriteFactory(MapView mapView) {
        this.mMapView = mapView;
        DisplayMetrics realMetrics = null;
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.mMapView.getContext().getSystemService("window");
        if (Build.VERSION.SDK_INT >= 17) {
            realMetrics = new DisplayMetrics();
            wm.getDefaultDisplay().getRealMetrics(realMetrics);
        }
        wm.getDefaultDisplay().getMetrics(metrics);
        this.mOptions = new BitmapFactory.Options();
        this.mOptions.inScaled = true;
        this.mOptions.inDensity = 160;
        this.mOptions.inTargetDensity = metrics.densityDpi;
        if (realMetrics != null) {
            this.mOptions.inScreenDensity = realMetrics.densityDpi;
        }
    }

    public Sprite fromBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        if (this.mNextId < 0) {
            throw new TooManySpritesException();
        }
        String id2 = SPRITE_ID_PREFIX + ++this.mNextId;
        return new Sprite(id2, bitmap);
    }

    public Sprite fromDrawable(Drawable drawable2) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        return this.fromDrawable(drawable2, width, height);
    }

    public Sprite fromDrawable(Drawable drawable2, int width, int height) {
        if (width < 0 || height < 0) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Rect temp = drawable2.getBounds();
        Rect bounds = new Rect(0, 0, width, height);
        drawable2.setBounds(bounds);
        drawable2.draw(canvas);
        drawable2.setBounds(temp);
        return this.fromBitmap(bitmap);
    }

    public Sprite fromResource(int resourceId) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.mMapView.getResources(), (int)resourceId);
        return this.fromBitmap(bitmap);
    }

    public Sprite defaultMarker() {
        if (this.mDefaultMarker == null) {
            this.mDefaultMarker = this.fromResource(R.drawable.default_marker);
        }
        return this.mDefaultMarker;
    }

    private Sprite fromInputStream(InputStream is) {
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)this.mOptions);
        return this.fromBitmap(bitmap);
    }

    public Sprite fromAsset(String assetName) {
        InputStream is;
        try {
            is = this.mMapView.getContext().getAssets().open(assetName);
        }
        catch (IOException e) {
            return null;
        }
        return this.fromInputStream(is);
    }

    public Sprite fromPath(String absolutePath) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)absolutePath, (BitmapFactory.Options)this.mOptions);
        return this.fromBitmap(bitmap);
    }

    public Sprite fromFile(String fileName) {
        FileInputStream is;
        try {
            is = this.mMapView.getContext().openFileInput(fileName);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return this.fromInputStream(is);
    }
}

