package com.mapbox.mapboxsdk.constants;

/**
 * GeoConstants exposes constants for doing locational calculations on Earth
 */
public class GeoConstants {

    /**
     * The equatorial radius value in meters
     */
    // http://en.wikipedia.org/wiki/Earth_radius#Equatorial_radius
    public static final int RADIUS_EARTH_METERS = 6378137;

    /**
     * The minimum latitude on Earth
     */
    public static final double MIN_LATITUDE = -85.05112878;

    /**
     * The maximum latitude on Earth
     */
    public static final double MAX_LATITUDE = 85.05112878;

    /**
     * The minimum longitude on Earth
     */
    public static final double MIN_LONGITUDE = -180;

    /**
     * The maximum longitude on Earth
     */
    public static final double MAX_LONGITUDE = 180;

}
