/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.graphics.Point;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.InfoWindow;
import com.mapbox.mapboxsdk.geometry.LatLng;

public final class Marker
extends Annotation {
    private float anchorU;
    private float anchorV;
    private boolean draggable;
    private boolean flat;
    private float infoWindowAnchorU;
    private float infoWindowAnchorV;
    private LatLng position;
    private float rotation;
    private String snippet;
    private String sprite = "default_marker";
    private String title;
    private InfoWindow infoWindow = null;
    private boolean infoWindowShown = false;
    private int topOffsetPixels;

    Marker() {
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Marker)) {
            return false;
        }
        double lat = this.position.getLatitude();
        double lng = this.position.getLongitude();
        LatLng otherPosition = ((Marker)other).getPosition();
        double otherLat = otherPosition.getLatitude();
        double otherLng = otherPosition.getLongitude();
        return lat == otherLat && otherLng == lng;
    }

    Point getAnchor() {
        return new Point((int)this.anchorU, (int)this.anchorV);
    }

    float getAnchorU() {
        return this.anchorU;
    }

    float getAnchorV() {
        return this.anchorV;
    }

    float getInfoWindowAnchorU() {
        return this.infoWindowAnchorU;
    }

    float getInfoWindowAnchorV() {
        return this.infoWindowAnchorV;
    }

    public LatLng getPosition() {
        return this.position;
    }

    float getRotation() {
        return this.rotation;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public String getTitle() {
        return this.title;
    }

    public void hideInfoWindow() {
        if (this.infoWindow != null) {
            this.infoWindow.close();
        }
        this.infoWindowShown = false;
    }

    boolean isDraggable() {
        return this.draggable;
    }

    boolean isFlat() {
        return this.flat;
    }

    public boolean isInfoWindowShown() {
        return this.infoWindowShown;
    }

    void setAnchor(float u, float v) {
        this.anchorU = u;
        this.anchorV = v;
    }

    void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    void setFlat(boolean flat) {
        this.flat = flat;
    }

    void setInfoWindowAnchor(float u, float v) {
        this.infoWindowAnchorU = u;
        this.infoWindowAnchorV = v;
    }

    void setPosition(LatLng position) {
        this.position = position;
    }

    void setRotation(float rotation) {
        this.rotation = rotation;
    }

    void setSnippet(String snippet) {
        this.snippet = snippet;
    }

    void setSprite(@Nullable String sprite) {
        if (!TextUtils.isEmpty((CharSequence)sprite)) {
            this.sprite = sprite;
        }
    }

    public String getSprite() {
        return this.sprite;
    }

    void setTitle(String title) {
        this.title = title;
    }

    public void showInfoWindow() {
        if (!this.isVisible() || this.getMapView() == null) {
            return;
        }
        this.getInfoWindow().adaptDefaultMarker(this);
        this.showInfoWindow(this.getInfoWindow());
    }

    public void showInfoWindow(View view) {
        if (!this.isVisible() || this.getMapView() == null) {
            return;
        }
        this.infoWindow = new InfoWindow(view, this.getMapView());
        this.showInfoWindow(this.infoWindow);
    }

    private void showInfoWindow(InfoWindow iw) {
        iw.open(this, this.getPosition(), 0, this.topOffsetPixels);
        iw.setBoundMarker(this);
        this.infoWindowShown = true;
    }

    public void setInfoWindowOnTouchListener(View.OnTouchListener listener) {
        if (listener == null) {
            return;
        }
        this.getInfoWindow().setOnTouchListener(listener);
    }

    private InfoWindow getInfoWindow() {
        if (this.infoWindow == null) {
            this.infoWindow = new InfoWindow(R.layout.infowindow_view, this.getMapView());
        }
        return this.infoWindow;
    }

    @Override
    void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible && this.infoWindowShown) {
            this.hideInfoWindow();
        }
    }

    public int getTopOffsetPixels() {
        return this.topOffsetPixels;
    }

    public void setTopOffsetPixels(int topOffsetPixels) {
        this.topOffsetPixels = topOffsetPixels;
    }
}

