/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.InfoWindowView;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.views.MapView;

final class InfoWindow {
    private Marker boundMarker;
    private MapView mMapView;
    private boolean mIsVisible;
    protected View mView;
    static int mTitleId = 0;
    static int mDescriptionId = 0;
    static int mSubDescriptionId = 0;
    static int mImageId = 0;

    public InfoWindow(int layoutResId, MapView mapView) {
        this.mMapView = mapView;
        this.mIsVisible = false;
        this.mView = LayoutInflater.from((Context)mapView.getContext()).inflate(layoutResId, (ViewGroup)mapView, false);
        if (mTitleId == 0) {
            InfoWindow.setResIds(mapView.getContext());
        }
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent e) {
                if (e.getAction() == 1) {
                    InfoWindow.this.close();
                }
                return true;
            }
        });
    }

    public InfoWindow(View view, MapView mapView) {
        this.mMapView = mapView;
        this.mIsVisible = false;
        this.mView = view;
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent e) {
                if (e.getAction() == 1) {
                    InfoWindow.this.close();
                }
                return true;
            }
        });
    }

    public InfoWindow open(Marker object, LatLng position, int offsetX, int offsetY) {
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
        this.mView.measure(0, 0);
        PointF coords = this.mMapView.toScreenLocation(position);
        float x = coords.x - (float)(this.mView.getMeasuredWidth() / 2) + (float)offsetX;
        float y = coords.y - (float)this.mView.getMeasuredHeight() + (float)offsetY;
        float right = x + (float)this.mView.getMeasuredWidth();
        float left = x;
        float mapRight = this.mMapView.getRight();
        float mapLeft = this.mMapView.getLeft();
        if (this.mView instanceof InfoWindowView) {
            Resources resources = this.mMapView.getContext().getResources();
            float margin = resources.getDimension(R.dimen.infowindow_margin);
            float tipViewOffset = resources.getDimension(R.dimen.infowindow_tipview_width) / 2.0f;
            float tipViewMarginLeft = (float)(this.mView.getMeasuredWidth() / 2) - tipViewOffset;
            if (right > (float)this.mMapView.getRight()) {
                x -= right - mapRight;
                tipViewMarginLeft += right - mapRight + tipViewOffset;
                right = x + (float)this.mView.getMeasuredWidth();
            }
            if (left < (float)this.mMapView.getLeft()) {
                x += mapLeft - left;
                tipViewMarginLeft -= mapLeft - left + tipViewOffset;
                left = x;
            }
            if (mapRight - right < margin) {
                tipViewMarginLeft += margin - (mapRight - right) - tipViewOffset;
                left = x -= margin - (mapRight - right);
            }
            if (left - mapLeft < margin) {
                x += margin - (left - mapLeft);
                tipViewMarginLeft -= margin - (left - mapLeft) - tipViewOffset;
            }
            InfoWindowView infoWindowView = (InfoWindowView)this.mView;
            infoWindowView.setTipViewMarginLeft((int)tipViewMarginLeft);
        }
        this.mView.setX(x);
        this.mView.setY(y);
        this.close();
        this.mMapView.addView(this.mView, (ViewGroup.LayoutParams)lp);
        this.mIsVisible = true;
        return this;
    }

    public InfoWindow close() {
        if (this.mIsVisible) {
            this.mIsVisible = false;
            ((ViewGroup)this.mView.getParent()).removeView(this.mView);
            this.setBoundMarker(null);
            this.onClose();
        }
        return this;
    }

    public View getView() {
        return this.mView;
    }

    public MapView getMapView() {
        return this.mMapView;
    }

    public void adaptDefaultMarker(Marker overlayItem) {
        String title = overlayItem.getTitle();
        ((TextView)this.mView.findViewById(mTitleId)).setText((CharSequence)title);
        String snippet = overlayItem.getSnippet();
        ((TextView)this.mView.findViewById(mDescriptionId)).setText((CharSequence)snippet);
    }

    public void onClose() {
    }

    public InfoWindow setBoundMarker(Marker aBoundMarker) {
        this.boundMarker = aBoundMarker;
        return this;
    }

    public Marker getBoundMarker() {
        return this.boundMarker;
    }

    private static void setResIds(Context context) {
        String packageName = context.getPackageName();
        mTitleId = context.getResources().getIdentifier("id/infowindow_title", null, packageName);
        mDescriptionId = context.getResources().getIdentifier("id/infowindow_description", null, packageName);
        mSubDescriptionId = context.getResources().getIdentifier("id/infowindow_subdescription", null, packageName);
        mImageId = context.getResources().getIdentifier("id/infowindow_image", null, packageName);
    }

    public void setOnTouchListener(View.OnTouchListener listener) {
        this.mView.setOnTouchListener(listener);
    }
}

