/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views;

import android.app.ActivityManager;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.GeomagneticField;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.ScaleGestureDetectorCompat;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ZoomButtonsController;
import com.almeros.android.multitouch.gesturedetectors.RotateGestureDetector;
import com.almeros.android.multitouch.gesturedetectors.TwoFingerGestureDetector;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerOptions;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngZoom;
import com.mapbox.mapboxsdk.views.NativeMapView;
import com.mapzen.android.lost.api.LocationListener;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.api.LocationServices;
import com.mapzen.android.lost.api.LostApiClient;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class MapView
extends FrameLayout
implements LocationListener {
    private static final String TAG = "MapView";
    private static final long ANIMATION_DURATION = 300L;
    private static final String STATE_CENTER_COORDINATE = "centerCoordinate";
    private static final String STATE_CENTER_DIRECTION = "centerDirection";
    private static final String STATE_ZOOM_LEVEL = "zoomLevel";
    private static final String STATE_DIRECTION = "direction";
    private static final String STATE_ZOOM_ENABLED = "zoomEnabled";
    private static final String STATE_SCROLL_ENABLED = "scrollEnabled";
    private static final String STATE_ROTATE_ENABLED = "rotateEnabled";
    private static final String STATE_DEBUG_ACTIVE = "debugActive";
    private static final String STATE_STYLE_URL = "styleUrl";
    private static final String STATE_ACCESS_TOKEN = "accessToken";
    private static final String STATE_STYLE_CLASSES = "styleClasses";
    private static final String STATE_DEFAULT_TRANSITION_DURATION = "defaultTransitionDuration";
    private static final String STATE_MY_LOCATION_ENABLED = "myLocationEnabled";
    private static final String STATE_USER_LOCATION_TRACKING_MODE = "userLocationTrackingMode";
    private static final String STATE_COMPASS_ENABLED = "compassEnabled";
    private static final String STATE_COMPASS_GRAVITY = "compassGravity";
    private static final String STATE_COMPASS_MARGIN_LEFT = "compassMarginLeft";
    private static final String STATE_COMPASS_MARGIN_TOP = "compassMarginTop";
    private static final String STATE_COMPASS_MARGIN_RIGHT = "compassMarginRight";
    private static final String STATE_COMPASS_MARGIN_BOTTOM = "compassMarginBottom";
    private static final String STATE_LOGO_GRAVITY = "logoGravity";
    private static final String STATE_LOGO_MARGIN_LEFT = "logoMarginLeft";
    private static final String STATE_LOGO_MARGIN_TOP = "logoMarginTop";
    private static final String STATE_LOGO_MARGIN_RIGHT = "logoMarginRight";
    private static final String STATE_LOGO_MARGIN_BOTTOM = "logoMarginBottom";
    private static final String STATE_ATTRIBUTION_GRAVITY = "attrGravity";
    private static final String STATE_ATTRIBUTION_MARGIN_LEFT = "attrMarginLeft";
    private static final String STATE_ATTRIBUTION_MARGIN_TOP = "attrMarginTop";
    private static final String STATE_ATTRIBUTION_MARGIN_RIGHT = "attrMarginRight";
    private static final String STATE_ATTRIBUTION_MARGIN_BOTTOM = "atrrMarginBottom";
    private static final float DIMENSION_SEVEN_DP = 7.0f;
    private static final float DIMENSION_TEN_DP = 10.0f;
    private static final float DIMENSION_SIXTEEN_DP = 16.0f;
    private static final float DIMENSION_SEVENTYSIX_DP = 76.0f;
    private static final int ATTRIBUTION_INDEX_IMPROVE_THIS_MAP = 2;
    private List<Annotation> mAnnotations = new ArrayList<Annotation>();
    private List<Annotation> mAnnotationsNearLastTap = new ArrayList<Annotation>();
    private Annotation mSelectedAnnotation = null;
    private NativeMapView mNativeMapView;
    private float mScreenDensity = 1.0f;
    private GestureDetectorCompat mGestureDetector;
    private ScaleGestureDetector mScaleGestureDetector;
    private RotateGestureDetector mRotateGestureDetector;
    private boolean mTwoTap = false;
    private ZoomButtonsController mZoomButtonsController;
    private TrackballLongPressTimeOut mCurrentTrackballLongPressTimeOut;
    private ConnectivityReceiver mConnectivityReceiver;
    private Context mContext;
    private boolean mIsMyLocationEnabled = false;
    private LostApiClient mLocationClient;
    private LocationRequest mLocationRequest;
    private ImageView mGpsMarker;
    private Location mGpsLocation;
    private UserLocationTrackingMode mUserLocationTrackingMode = UserLocationTrackingMode.FOLLOW;
    private boolean mIsCompassEnabled = true;
    private ImageView mCompassView;
    private SensorManager mSensorManager;
    private Sensor mSensorAccelerometer;
    private Sensor mSensorMagneticField;
    private CompassListener mCompassListener;
    private float[] mValuesAccelerometer = new float[3];
    private float[] mValuesMagneticField = new float[3];
    private float[] mMatrixR = new float[9];
    private float[] mMatrixI = new float[9];
    private float[] mMatrixValues = new float[3];
    private float mCompassBearing;
    private boolean mCompassValid = false;
    private ImageView mLogoView;
    private ImageView mAttributionsView;
    private long t0 = new Date().getTime();
    private ArrayList<OnMapChangedListener> mOnMapChangedListener;
    private OnFlingListener onFlingListener;
    private OnScrollListener onScrollListener;
    private boolean mZoomEnabled = true;
    private boolean mScrollEnabled = true;
    private boolean mRotateEnabled = true;
    private String mStyleUrl;
    private OnFpsChangedListener mOnFpsChangedListener;

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.onScrollListener = onScrollListener;
    }

    public void setOnFlingListener(OnFlingListener onFlingListener) {
        this.onFlingListener = onFlingListener;
    }

    public MapView(Context context) {
        super(context);
        this.initialize(context, null);
    }

    public MapView(Context context, @NonNull String accessToken) {
        super(context);
        this.initialize(context, null);
        this.setAccessToken(accessToken);
    }

    public MapView(Context context, @NonNull String accessToken, String styleUrl) {
        super(context);
        this.initialize(context, null);
        this.setAccessToken(accessToken);
        this.setStyleUrl(styleUrl);
    }

    public MapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    public MapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialize(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(Context context, AttributeSet attrs) {
        this.mContext = context;
        TextureView textureView = new TextureView(this.mContext);
        this.addView((View)textureView);
        if (this.isInEditMode()) {
            return;
        }
        this.mScreenDensity = context.getResources().getDisplayMetrics().density;
        int tenDp = (int)(10.0f * this.mScreenDensity);
        int sixteenDp = (int)(16.0f * this.mScreenDensity);
        String cachePath = context.getCacheDir().getAbsolutePath();
        String dataPath = context.getFilesDir().getAbsolutePath();
        String apkPath = context.getPackageCodePath();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        activityManager.getMemoryInfo(memoryInfo);
        long maxMemory = memoryInfo.availMem;
        if (Build.VERSION.SDK_INT >= 16) {
            maxMemory = memoryInfo.totalMem;
        }
        this.mNativeMapView = new NativeMapView(this, cachePath, dataPath, apkPath, this.mScreenDensity, availableProcessors, maxMemory);
        this.setClickable(true);
        this.setLongClickable(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)new SurfaceTextureListener());
        this.mGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureListener());
        this.mGestureDetector.setIsLongpressEnabled(true);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureListener());
        ScaleGestureDetectorCompat.setQuickScaleEnabled((Object)this.mScaleGestureDetector, (boolean)true);
        this.mRotateGestureDetector = new RotateGestureDetector(context, new RotateGestureListener());
        if (!this.isInEditMode()) {
            ConnectivityManager connectivityManager;
            NetworkInfo activeNetwork;
            if (!context.getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch")) {
                this.mZoomButtonsController = new ZoomButtonsController((View)this);
                this.mZoomButtonsController.setZoomSpeed(300L);
                this.mZoomButtonsController.setOnZoomListener((ZoomButtonsController.OnZoomListener)new OnZoomListener());
            }
            boolean isConnected = (activeNetwork = (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && activeNetwork.isConnectedOrConnecting();
            this.onConnectivityChanged(isConnected);
        }
        this.mLocationClient = new LostApiClient.Builder(this.getContext()).build();
        this.mLocationRequest = LocationRequest.create().setInterval(1000L).setSmallestDisplacement(1.0f).setPriority(100);
        this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        this.mSensorAccelerometer = this.mSensorManager.getDefaultSensor(1);
        this.mSensorMagneticField = this.mSensorManager.getDefaultSensor(2);
        this.mCompassListener = new CompassListener();
        this.mCompassView = new ImageView(this.mContext);
        this.mCompassView.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.compass));
        this.mCompassView.setContentDescription((CharSequence)this.getResources().getString(R.string.compassContentDescription));
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams((int)(48.0f * this.mScreenDensity), (int)(48.0f * this.mScreenDensity));
        this.mCompassView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.addView((View)this.mCompassView);
        this.mCompassView.setOnClickListener((View.OnClickListener)new CompassOnClickListener());
        this.mLogoView = new ImageView(this.mContext);
        this.mLogoView.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.ic_logo_mapbox));
        this.mLogoView.setContentDescription((CharSequence)this.getResources().getString(R.string.mapboxIconContentDescription));
        FrameLayout.LayoutParams logoParams = new FrameLayout.LayoutParams(-2, -2);
        this.mLogoView.setLayoutParams((ViewGroup.LayoutParams)logoParams);
        this.addView((View)this.mLogoView);
        this.mAttributionsView = new ImageView(this.mContext);
        this.mAttributionsView.setClickable(true);
        this.mAttributionsView.setImageResource(R.drawable.ic_info_selector);
        int attrPadding = (int)(7.0f * this.mScreenDensity);
        this.mAttributionsView.setPadding(attrPadding, attrPadding, attrPadding, attrPadding);
        this.mAttributionsView.setAdjustViewBounds(true);
        this.mAttributionsView.setContentDescription((CharSequence)this.getResources().getString(R.string.attributionsIconContentDescription));
        FrameLayout.LayoutParams attrParams = new FrameLayout.LayoutParams(-2, -2);
        this.mAttributionsView.setLayoutParams((ViewGroup.LayoutParams)attrParams);
        this.addView((View)this.mAttributionsView);
        this.mAttributionsView.setOnClickListener((View.OnClickListener)new AttributionOnClickListener(this));
        this.mOnMapChangedListener = new ArrayList();
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MapView, 0, 0);
        try {
            double centerLatitude = typedArray.getFloat(R.styleable.MapView_centerLatitude, 0.0f);
            double centerLongitude = typedArray.getFloat(R.styleable.MapView_centerLongitude, 0.0f);
            LatLng centerCoordinate = new LatLng(centerLatitude, centerLongitude);
            this.setCenterCoordinate(centerCoordinate);
            this.setZoomLevel(typedArray.getFloat(R.styleable.MapView_zoomLevel, 0.0f));
            this.setDirection(typedArray.getFloat(R.styleable.MapView_direction, 0.0f));
            this.setZoomEnabled(typedArray.getBoolean(R.styleable.MapView_zoomEnabled, true));
            this.setScrollEnabled(typedArray.getBoolean(R.styleable.MapView_scrollEnabled, true));
            this.setRotateEnabled(typedArray.getBoolean(R.styleable.MapView_rotateEnabled, true));
            this.setDebugActive(typedArray.getBoolean(R.styleable.MapView_debugActive, false));
            if (typedArray.getString(R.styleable.MapView_styleUrl) != null) {
                this.setStyleUrl(typedArray.getString(R.styleable.MapView_styleUrl));
            }
            if (typedArray.getString(R.styleable.MapView_accessToken) != null) {
                this.setAccessToken(typedArray.getString(R.styleable.MapView_accessToken));
            }
            if (typedArray.getString(R.styleable.MapView_styleClasses) != null) {
                List<String> styleClasses = Arrays.asList(typedArray.getString(R.styleable.MapView_styleClasses).split("\\s*,\\s*"));
                for (String styleClass : styleClasses) {
                    if (styleClass.length() != 0) continue;
                    styleClasses.remove(styleClass);
                }
                this.setStyleClasses(styleClasses);
            }
            this.setCompassEnabled(typedArray.getBoolean(R.styleable.MapView_compassEnabled, true));
            this.setCompassGravity(typedArray.getInt(R.styleable.MapView_compassGravity, 8388661));
            this.setWidgetMargins((View)this.mCompassView, typedArray.getDimension(R.styleable.MapView_compassMarginLeft, 10.0f), typedArray.getDimension(R.styleable.MapView_compassMarginTop, 10.0f), typedArray.getDimension(R.styleable.MapView_compassMarginRight, 10.0f), typedArray.getDimension(R.styleable.MapView_compassMarginBottom, 10.0f));
            this.setLogoGravity(typedArray.getInt(R.styleable.MapView_logoGravity, 8388691));
            this.setWidgetMargins((View)this.mLogoView, typedArray.getDimension(R.styleable.MapView_logoMarginLeft, 16.0f), typedArray.getDimension(R.styleable.MapView_logoMarginTop, 16.0f), typedArray.getDimension(R.styleable.MapView_logoMarginRight, 16.0f), typedArray.getDimension(R.styleable.MapView_logoMarginBottom, 16.0f));
            this.setAttributionGravity(typedArray.getInt(R.styleable.MapView_attributionGravity, 80));
            this.setWidgetMargins((View)this.mAttributionsView, typedArray.getDimension(R.styleable.MapView_attributionMarginLeft, 76.0f), typedArray.getDimension(R.styleable.MapView_attributionMarginTop, 7.0f), typedArray.getDimension(R.styleable.MapView_attributionMarginRight, 7.0f), typedArray.getDimension(R.styleable.MapView_attributionMarginBottom, 7.0f));
            this.setMyLocationEnabled(typedArray.getBoolean(R.styleable.MapView_myLocationEnabled, false));
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setSprite(String symbol, float scale, Bitmap bitmap) {
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
        }
        ByteBuffer buffer = ByteBuffer.allocate(bitmap.getRowBytes() * bitmap.getHeight());
        bitmap.copyPixelsToBuffer((Buffer)buffer);
        this.mNativeMapView.setSprite(symbol, bitmap.getWidth(), bitmap.getHeight(), scale, buffer.array());
    }

    public Marker addMarker(MarkerOptions markerOptions) {
        Marker marker = markerOptions.getMarker();
        long id2 = this.mNativeMapView.addMarker(marker);
        marker.setId(id2);
        marker.setMapView(this);
        this.mAnnotations.add(marker);
        return marker;
    }

    public Polyline addPolyline(PolylineOptions polylineOptions) {
        Polyline polyline = polylineOptions.getPolyline();
        long id2 = this.mNativeMapView.addPolyline(polyline);
        polyline.setId(id2);
        polyline.setMapView(this);
        this.mAnnotations.add(polyline);
        return polyline;
    }

    public Polygon addPolygon(PolygonOptions polygonOptions) {
        Polygon polygon = polygonOptions.getPolygon();
        long id2 = this.mNativeMapView.addPolygon(polygon);
        polygon.setId(id2);
        polygon.setMapView(this);
        this.mAnnotations.add(polygon);
        return polygon;
    }

    public List<Polygon> addPolygons(List<PolygonOptions> polygonOptions) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (PolygonOptions popts : polygonOptions) {
            polygons.add(popts.getPolygon());
        }
        long[] ids = this.mNativeMapView.addPolygons(polygons);
        for (int i = 0; i < polygons.size(); ++i) {
            ((Polygon)polygons.get(i)).setId(ids[i]);
            ((Polygon)polygons.get(i)).setMapView(this);
            this.mAnnotations.add((Annotation)polygons.get(i));
        }
        return Collections.unmodifiableList(polygons);
    }

    private void removeAnnotationsWithId(long annotationId) {
        Iterator<Annotation> iterator = this.mAnnotations.iterator();
        while (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            if (annotation instanceof Marker) {
                ((Marker)annotation).hideInfoWindow();
            }
            if (annotation.getId() != annotationId) continue;
            iterator.remove();
        }
    }

    public void removeAnnotation(Annotation annotation) {
        if (annotation instanceof Marker) {
            ((Marker)annotation).hideInfoWindow();
        }
        long id2 = annotation.getId();
        this.mNativeMapView.removeAnnotation(id2);
        this.mAnnotations.remove(annotation);
    }

    public void removeAnnotation(long annotationId) {
        this.mNativeMapView.removeAnnotation(annotationId);
        this.removeAnnotationsWithId(annotationId);
    }

    public void removeAnnotations() {
        long[] ids = new long[this.mAnnotations.size()];
        for (int i = 0; i < this.mAnnotations.size(); ++i) {
            long id2;
            Annotation annotation = this.mAnnotations.get(i);
            ids[i] = id2 = annotation.getId();
            if (!(annotation instanceof Marker)) continue;
            ((Marker)annotation).hideInfoWindow();
        }
        this.mNativeMapView.removeAnnotations(ids);
        this.mAnnotations.clear();
    }

    public List<Annotation> getAnnotations() {
        return Collections.unmodifiableList(this.mAnnotations);
    }

    public List<Annotation> getAnnotationsInBounds(BoundingBox bbox) {
        int i;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        long[] ids = this.mNativeMapView.getAnnotationsInBounds(bbox);
        ArrayList<Long> idsList = new ArrayList<Long>();
        for (i = 0; i < ids.length; ++i) {
            idsList.add(new Long(ids[i]));
        }
        for (i = 0; i < this.mAnnotations.size(); ++i) {
            Annotation annotation = this.mAnnotations.get(i);
            if (!(annotation instanceof Marker) || !idsList.contains(annotation.getId())) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    public LatLng getCenterCoordinate() {
        return this.mNativeMapView.getLatLng();
    }

    public void setCenterCoordinate(LatLng centerCoordinate) {
        this.setCenterCoordinate(centerCoordinate, false);
    }

    public void setCenterCoordinate(LatLng centerCoordinate, boolean animated) {
        long duration = animated ? 300L : 0L;
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.setLatLng(centerCoordinate, duration);
    }

    public void setCenterCoordinate(LatLngZoom centerCoordinate) {
        this.setCenterCoordinate(centerCoordinate, false);
    }

    public void setCenterCoordinate(LatLngZoom centerCoordinate, boolean animated) {
        long duration = animated ? 300L : 0L;
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.setLatLngZoom(centerCoordinate, duration);
    }

    public double getDirection() {
        double direction;
        for (direction = -this.mNativeMapView.getBearing(); direction > 360.0; direction -= 360.0) {
        }
        while (direction < 0.0) {
            direction += 360.0;
        }
        return direction;
    }

    public void setDirection(double direction) {
        this.setDirection(direction, false);
    }

    public void setDirection(double direction, boolean animated) {
        long duration = animated ? 300L : 0L;
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.setBearing(-direction, duration);
    }

    public void resetPosition() {
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.resetPosition();
    }

    public void resetNorth() {
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.resetNorth();
    }

    public double getZoomLevel() {
        return this.mNativeMapView.getZoom();
    }

    public void setZoomLevel(double zoomLevel) {
        this.setZoomLevel(zoomLevel, false);
    }

    public void setZoomLevel(double zoomLevel, boolean animated) {
        long duration = animated ? 300L : 0L;
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.setZoom(zoomLevel, duration);
    }

    public boolean isZoomEnabled() {
        return this.mZoomEnabled;
    }

    public void setZoomEnabled(boolean zoomEnabled) {
        this.mZoomEnabled = zoomEnabled;
        if (this.mZoomButtonsController != null && this.getVisibility() == 0 && this.mZoomEnabled) {
            this.mZoomButtonsController.setVisible(true);
        }
    }

    public boolean isScrollEnabled() {
        return this.mScrollEnabled;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        this.mScrollEnabled = scrollEnabled;
    }

    public boolean isRotateEnabled() {
        return this.mRotateEnabled;
    }

    public void setRotateEnabled(boolean rotateEnabled) {
        this.mRotateEnabled = rotateEnabled;
    }

    public boolean isDebugActive() {
        return this.mNativeMapView.getDebug() || this.mNativeMapView.getCollisionDebug();
    }

    public void setDebugActive(boolean debugActive) {
        this.mNativeMapView.setDebug(debugActive);
        this.mNativeMapView.setCollisionDebug(debugActive);
    }

    public void toggleDebug() {
        this.mNativeMapView.toggleDebug();
        this.mNativeMapView.toggleCollisionDebug();
    }

    public UserLocationTrackingMode getUserLocationTrackingMode() {
        return this.mUserLocationTrackingMode;
    }

    public void setUserLocationTrackingMode(UserLocationTrackingMode userLocationTrackingMode) {
        this.mUserLocationTrackingMode = userLocationTrackingMode;
    }

    public boolean isFullyLoaded() {
        return this.mNativeMapView.isFullyLoaded();
    }

    public void setStyleUrl(String url) {
        this.mStyleUrl = url;
        this.mNativeMapView.setStyleUrl(url);
    }

    public String getStyleUrl() {
        return this.mStyleUrl;
    }

    private void validateAccessToken(@NonNull String accessToken) {
        if (TextUtils.isEmpty((CharSequence)accessToken) || !accessToken.startsWith("pk.") && !accessToken.startsWith("sk.")) {
            throw new RuntimeException("Using MapView requires setting a valid access token. See the README.md");
        }
    }

    public void setAccessToken(@NonNull String accessToken) {
        this.validateAccessToken(accessToken);
        this.mNativeMapView.setAccessToken(accessToken);
    }

    public String getAccessToken() {
        return this.mNativeMapView.getAccessToken();
    }

    public List<String> getStyleClasses() {
        return Collections.unmodifiableList(this.mNativeMapView.getClasses());
    }

    public void setStyleClasses(List<String> styleClasses) {
        this.setStyleClasses(styleClasses, 0L);
    }

    public void setStyleClasses(List<String> styleClasses, long transitionDuration) {
        this.mNativeMapView.setDefaultTransitionDuration(transitionDuration);
        this.mNativeMapView.setClasses(styleClasses);
    }

    public void addStyleClass(String styleClass) {
        this.mNativeMapView.addClass(styleClass);
    }

    public void removeStyleClass(String styleClass) {
        this.mNativeMapView.removeClass(styleClass);
    }

    public boolean hasStyleClass(String styleClass) {
        return this.mNativeMapView.hasClass(styleClass);
    }

    public void removeAllStyleClasses() {
        this.removeAllStyleClasses(0L);
    }

    public void removeAllStyleClasses(long transitionDuration) {
        this.mNativeMapView.setDefaultTransitionDuration(transitionDuration);
        ArrayList<String> styleClasses = new ArrayList<String>(0);
        this.setStyleClasses(styleClasses);
    }

    public LatLng fromScreenLocation(PointF point) {
        return this.mNativeMapView.latLngForPixel(new PointF(point.x / this.mScreenDensity, point.y / this.mScreenDensity));
    }

    public PointF toScreenLocation(LatLng location) {
        PointF point = this.mNativeMapView.pixelForLatLng(location);
        return new PointF(point.x * this.mScreenDensity, point.y * this.mScreenDensity);
    }

    public double getTopOffsetPixelsForAnnotationSymbol(@NonNull String symbolName) {
        return this.mNativeMapView.getTopOffsetPixelsForAnnotationSymbol(symbolName);
    }

    public float getScreenDensity() {
        return this.mScreenDensity;
    }

    public void onCreate(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.setCenterCoordinate((LatLng)savedInstanceState.getParcelable(STATE_CENTER_COORDINATE));
            this.setZoomLevel(savedInstanceState.getDouble(STATE_ZOOM_LEVEL));
            this.setDirection(savedInstanceState.getDouble(STATE_CENTER_DIRECTION));
            this.setDirection(savedInstanceState.getDouble(STATE_DIRECTION));
            this.setZoomEnabled(savedInstanceState.getBoolean(STATE_ZOOM_ENABLED));
            this.setScrollEnabled(savedInstanceState.getBoolean(STATE_SCROLL_ENABLED));
            this.setRotateEnabled(savedInstanceState.getBoolean(STATE_ROTATE_ENABLED));
            this.setDebugActive(savedInstanceState.getBoolean(STATE_DEBUG_ACTIVE));
            this.setStyleUrl(savedInstanceState.getString(STATE_STYLE_URL));
            this.setAccessToken(savedInstanceState.getString(STATE_ACCESS_TOKEN));
            ArrayList appliedStyleClasses = savedInstanceState.getStringArrayList(STATE_STYLE_CLASSES);
            if (!appliedStyleClasses.isEmpty()) {
                this.setStyleClasses(appliedStyleClasses);
            }
            this.mNativeMapView.setDefaultTransitionDuration(savedInstanceState.getLong(STATE_DEFAULT_TRANSITION_DURATION));
            this.setMyLocationEnabled(savedInstanceState.getBoolean(STATE_MY_LOCATION_ENABLED));
            this.setUserLocationTrackingMode((UserLocationTrackingMode)((Object)savedInstanceState.getSerializable(STATE_USER_LOCATION_TRACKING_MODE)));
            this.setCompassEnabled(savedInstanceState.getBoolean(STATE_COMPASS_ENABLED));
            this.setCompassGravity(savedInstanceState.getInt(STATE_COMPASS_GRAVITY));
            this.setCompassMargins(savedInstanceState.getInt(STATE_COMPASS_MARGIN_LEFT), savedInstanceState.getInt(STATE_COMPASS_MARGIN_TOP), savedInstanceState.getInt(STATE_COMPASS_MARGIN_RIGHT), savedInstanceState.getInt(STATE_COMPASS_MARGIN_BOTTOM));
            this.setLogoGravity(savedInstanceState.getInt(STATE_LOGO_GRAVITY));
            this.setLogoMargins(savedInstanceState.getInt(STATE_LOGO_MARGIN_LEFT), savedInstanceState.getInt(STATE_LOGO_MARGIN_TOP), savedInstanceState.getInt(STATE_LOGO_MARGIN_RIGHT), savedInstanceState.getInt(STATE_LOGO_MARGIN_BOTTOM));
            this.setAttributionGravity(savedInstanceState.getInt(STATE_ATTRIBUTION_GRAVITY));
            this.setAttributionMargins(savedInstanceState.getInt(STATE_ATTRIBUTION_MARGIN_LEFT), savedInstanceState.getInt(STATE_ATTRIBUTION_MARGIN_TOP), savedInstanceState.getInt(STATE_ATTRIBUTION_MARGIN_RIGHT), savedInstanceState.getInt(STATE_ATTRIBUTION_MARGIN_BOTTOM));
        }
        this.validateAccessToken(this.getAccessToken());
        this.mNativeMapView.initializeDisplay();
        this.mNativeMapView.initializeContext();
        this.addOnMapChangedListener(new OnMapChangedListener(){

            @Override
            public void onMapChanged(MapChange change) {
                MapView.this.updateMap(change);
            }
        });
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putParcelable(STATE_CENTER_COORDINATE, (Parcelable)this.getCenterCoordinate());
        outState.putDouble(STATE_ZOOM_LEVEL, this.getZoomLevel());
        outState.putDouble(STATE_CENTER_DIRECTION, this.getDirection());
        outState.putBoolean(STATE_ZOOM_ENABLED, this.mZoomEnabled);
        outState.putBoolean(STATE_SCROLL_ENABLED, this.mScrollEnabled);
        outState.putBoolean(STATE_ROTATE_ENABLED, this.mRotateEnabled);
        outState.putBoolean(STATE_DEBUG_ACTIVE, this.isDebugActive());
        outState.putString(STATE_STYLE_URL, this.mStyleUrl);
        outState.putString(STATE_ACCESS_TOKEN, this.getAccessToken());
        outState.putStringArrayList(STATE_STYLE_CLASSES, new ArrayList<String>(this.getStyleClasses()));
        outState.putLong(STATE_DEFAULT_TRANSITION_DURATION, this.mNativeMapView.getDefaultTransitionDuration());
        outState.putBoolean(STATE_MY_LOCATION_ENABLED, this.isMyLocationEnabled());
        outState.putSerializable(STATE_USER_LOCATION_TRACKING_MODE, (Serializable)((Object)this.getUserLocationTrackingMode()));
        FrameLayout.LayoutParams compassParams = (FrameLayout.LayoutParams)this.mCompassView.getLayoutParams();
        outState.putBoolean(STATE_COMPASS_ENABLED, this.isCompassEnabled());
        outState.putInt(STATE_COMPASS_GRAVITY, compassParams.gravity);
        outState.putInt(STATE_COMPASS_MARGIN_LEFT, compassParams.leftMargin);
        outState.putInt(STATE_COMPASS_MARGIN_TOP, compassParams.topMargin);
        outState.putInt(STATE_COMPASS_MARGIN_BOTTOM, compassParams.bottomMargin);
        outState.putInt(STATE_COMPASS_MARGIN_RIGHT, compassParams.rightMargin);
        FrameLayout.LayoutParams logoParams = (FrameLayout.LayoutParams)this.mLogoView.getLayoutParams();
        outState.putInt(STATE_LOGO_GRAVITY, logoParams.gravity);
        outState.putInt(STATE_LOGO_MARGIN_LEFT, logoParams.leftMargin);
        outState.putInt(STATE_LOGO_MARGIN_TOP, logoParams.topMargin);
        outState.putInt(STATE_LOGO_MARGIN_RIGHT, logoParams.rightMargin);
        outState.putInt(STATE_LOGO_MARGIN_BOTTOM, logoParams.bottomMargin);
        FrameLayout.LayoutParams attrParams = (FrameLayout.LayoutParams)this.mAttributionsView.getLayoutParams();
        outState.putInt(STATE_ATTRIBUTION_GRAVITY, attrParams.gravity);
        outState.putInt(STATE_ATTRIBUTION_MARGIN_LEFT, attrParams.leftMargin);
        outState.putInt(STATE_ATTRIBUTION_MARGIN_TOP, attrParams.topMargin);
        outState.putInt(STATE_ATTRIBUTION_MARGIN_RIGHT, attrParams.rightMargin);
        outState.putInt(STATE_ATTRIBUTION_MARGIN_BOTTOM, attrParams.bottomMargin);
    }

    public void onDestroy() {
        this.mNativeMapView.terminateContext();
        this.mNativeMapView.terminateDisplay();
    }

    public void onStart() {
    }

    public void onStop() {
    }

    public void onPause() {
        this.getContext().unregisterReceiver((BroadcastReceiver)this.mConnectivityReceiver);
        this.mConnectivityReceiver = null;
        if (this.mIsMyLocationEnabled) {
            this.toggleGps(false);
        }
        this.mNativeMapView.pause();
    }

    public void onResume() {
        this.mConnectivityReceiver = new ConnectivityReceiver();
        this.mContext.registerReceiver((BroadcastReceiver)this.mConnectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        if (this.mIsMyLocationEnabled) {
            this.toggleGps(true);
        }
        this.mNativeMapView.resume();
    }

    public void onSizeChanged(int width, int height, int oldw, int oldh) {
        if (!this.isInEditMode()) {
            this.mNativeMapView.resizeView((int)((float)width / this.mScreenDensity), (int)((float)height / this.mScreenDensity));
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mZoomButtonsController != null) {
            this.mZoomButtonsController.setVisible(false);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        if (this.mZoomButtonsController != null && visibility != 0) {
            this.mZoomButtonsController.setVisible(false);
        }
        if (this.mZoomButtonsController != null && visibility == 0 && this.mZoomEnabled) {
            this.mZoomButtonsController.setVisible(true);
        }
    }

    public void onLowMemory() {
        this.mNativeMapView.onLowMemory();
    }

    private void zoom(boolean zoomIn) {
        this.zoom(zoomIn, -1.0f, -1.0f);
    }

    private void zoom(boolean zoomIn, float x, float y) {
        this.mNativeMapView.cancelTransitions();
        if (zoomIn) {
            this.mNativeMapView.scaleBy(2.0, x / this.mScreenDensity, y / this.mScreenDensity, 300L);
        } else {
            this.mNativeMapView.scaleBy(0.5, x / this.mScreenDensity, y / this.mScreenDensity, 300L);
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (Build.VERSION.SDK_INT >= 14 && event.getButtonState() != 0 && event.getButtonState() != 1) {
            return false;
        }
        this.mRotateGestureDetector.onTouchEvent(event);
        this.mScaleGestureDetector.onTouchEvent(event);
        switch (event.getActionMasked()) {
            case 0: {
                this.mNativeMapView.setGestureInProgress(true);
                break;
            }
            case 5: {
                this.mTwoTap = event.getPointerCount() == 2;
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                long tapInterval = event.getEventTime() - event.getDownTime();
                boolean isTap = tapInterval <= (long)ViewConfiguration.getTapTimeout();
                boolean inProgress = this.mRotateGestureDetector.isInProgress() || this.mScaleGestureDetector.isInProgress();
                this.mNativeMapView.setGestureInProgress(false);
                if (this.mTwoTap && isTap && !inProgress) {
                    PointF focalPoint = TwoFingerGestureDetector.determineFocalPoint(event);
                    this.zoom(false, focalPoint.x, focalPoint.y);
                    this.mTwoTap = false;
                    return true;
                }
                this.mTwoTap = false;
                break;
            }
            case 3: {
                this.mTwoTap = false;
                this.mNativeMapView.setGestureInProgress(false);
            }
        }
        boolean retVal = this.mGestureDetector.onTouchEvent(event);
        return retVal || super.onTouchEvent(event);
    }

    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        double scrollDist = event.getRepeatCount() >= 5 ? 50.0 : 10.0;
        switch (keyCode) {
            case 23: 
            case 66: {
                event.startTracking();
                return true;
            }
            case 21: {
                if (!this.mScrollEnabled) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(scrollDist / (double)this.mScreenDensity, 0.0 / (double)this.mScreenDensity);
                return true;
            }
            case 22: {
                if (!this.mScrollEnabled) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(-scrollDist / (double)this.mScreenDensity, 0.0 / (double)this.mScreenDensity);
                return true;
            }
            case 19: {
                if (!this.mScrollEnabled) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(0.0 / (double)this.mScreenDensity, scrollDist / (double)this.mScreenDensity);
                return true;
            }
            case 20: {
                if (!this.mScrollEnabled) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(0.0 / (double)this.mScreenDensity, -scrollDist / (double)this.mScreenDensity);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.mZoomEnabled) {
                    return false;
                }
                this.zoom(false);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (event.isCanceled()) {
            return super.onKeyUp(keyCode, event);
        }
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.mZoomEnabled) {
                    return false;
                }
                this.zoom(true);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 2: {
                if (!this.mScrollEnabled) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(-10.0 * (double)event.getX() / (double)this.mScreenDensity, -10.0 * (double)event.getY() / (double)this.mScreenDensity);
                return true;
            }
            case 0: {
                if (this.mCurrentTrackballLongPressTimeOut != null) {
                    this.mCurrentTrackballLongPressTimeOut.cancel();
                    this.mCurrentTrackballLongPressTimeOut = null;
                }
                this.mCurrentTrackballLongPressTimeOut = new TrackballLongPressTimeOut();
                this.postDelayed(this.mCurrentTrackballLongPressTimeOut, ViewConfiguration.getLongPressTimeout());
                return true;
            }
            case 1: {
                if (!this.mZoomEnabled) {
                    return false;
                }
                if (this.mCurrentTrackballLongPressTimeOut != null) {
                    this.zoom(true);
                }
                return true;
            }
            case 3: {
                if (this.mCurrentTrackballLongPressTimeOut != null) {
                    this.mCurrentTrackballLongPressTimeOut.cancel();
                    this.mCurrentTrackballLongPressTimeOut = null;
                }
                return true;
            }
        }
        return super.onTrackballEvent(event);
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 2) == 2) {
            switch (event.getActionMasked()) {
                case 8: {
                    if (!this.mZoomEnabled) {
                        return false;
                    }
                    this.mNativeMapView.cancelTransitions();
                    float scrollDist = event.getAxisValue(9);
                    this.mNativeMapView.scaleBy(Math.pow(2.0, scrollDist), event.getX() / this.mScreenDensity, event.getY() / this.mScreenDensity);
                    return true;
                }
            }
            return super.onGenericMotionEvent(event);
        }
        return super.onGenericMotionEvent(event);
    }

    public boolean onHoverEvent(@NonNull MotionEvent event) {
        switch (event.getActionMasked()) {
            case 7: 
            case 9: {
                if (this.mZoomButtonsController != null && this.mZoomEnabled) {
                    this.mZoomButtonsController.setVisible(true);
                }
                return true;
            }
            case 10: {
                if (this.mZoomButtonsController == null) break;
                this.mZoomButtonsController.setVisible(false);
            }
        }
        return super.onHoverEvent(event);
    }

    private void onConnectivityChanged(boolean isConnected) {
        this.mNativeMapView.setReachability(isConnected);
    }

    protected void onInvalidate() {
        this.post(new Runnable(){

            @Override
            public void run() {
                MapView.this.mNativeMapView.invalidate();
            }
        });
    }

    public void addOnMapChangedListener(@NonNull OnMapChangedListener listener) {
        if (listener != null) {
            this.mOnMapChangedListener.add(listener);
        }
    }

    public void removeOnMapChangedListener(@NonNull OnMapChangedListener listener) {
        if (listener != null) {
            this.mOnMapChangedListener.remove(listener);
        }
    }

    protected void onMapChanged(int rawChange) {
        final MapChange change = MapChange.fromInteger(rawChange);
        if (this.mOnMapChangedListener != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    for (OnMapChangedListener listener : MapView.this.mOnMapChangedListener) {
                        listener.onMapChanged(change);
                    }
                }
            });
        }
    }

    public void setOnFpsChangedListener(OnFpsChangedListener listener) {
        this.mOnFpsChangedListener = listener;
    }

    protected void onFpsChanged(final double fps) {
        if (this.mOnFpsChangedListener != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    MapView.this.mOnFpsChangedListener.onFpsChanged(fps);
                }
            });
        }
    }

    public final boolean isMyLocationEnabled() {
        return this.mIsMyLocationEnabled;
    }

    public final void setMyLocationEnabled(boolean enabled) {
        this.mIsMyLocationEnabled = enabled;
        this.toggleGps(enabled);
        this.updateMap(MapChange.MapChangeNullChange);
    }

    public final Location getMyLocation() {
        return this.mGpsLocation;
    }

    private void toggleGps(boolean enableGps) {
        if (enableGps) {
            if (!this.mLocationClient.isConnected()) {
                this.mGpsLocation = null;
                this.mLocationClient.connect();
                this.updateLocation(LocationServices.FusedLocationApi.getLastLocation());
                LocationServices.FusedLocationApi.requestLocationUpdates(this.mLocationRequest, (LocationListener)this);
                this.mSensorManager.registerListener((SensorEventListener)this.mCompassListener, this.mSensorAccelerometer, 2);
                this.mSensorManager.registerListener((SensorEventListener)this.mCompassListener, this.mSensorMagneticField, 2);
            }
        } else if (this.mLocationClient.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates((LocationListener)this);
            this.mLocationClient.disconnect();
            this.mGpsLocation = null;
            this.mSensorManager.unregisterListener((SensorEventListener)this.mCompassListener, this.mSensorAccelerometer);
            this.mSensorManager.unregisterListener((SensorEventListener)this.mCompassListener, this.mSensorMagneticField);
        }
    }

    public boolean isCompassEnabled() {
        return this.mIsCompassEnabled;
    }

    public void setCompassEnabled(boolean compassEnabled) {
        this.mIsCompassEnabled = compassEnabled;
        if (this.mIsCompassEnabled) {
            this.mCompassView.setVisibility(0);
        } else {
            this.mCompassView.setVisibility(8);
        }
        this.updateMap(MapChange.MapChangeNullChange);
    }

    public void setCompassGravity(int gravity) {
        this.setWidgetGravity((View)this.mCompassView, gravity);
    }

    public void setCompassMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.mCompassView, left, top, right, bottom);
    }

    public void setLogoGravity(int gravity) {
        this.setWidgetGravity((View)this.mLogoView, gravity);
    }

    public void setLogoMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.mLogoView, left, top, right, bottom);
    }

    public void setAttributionGravity(int gravity) {
        this.setWidgetGravity((View)this.mAttributionsView, gravity);
    }

    public void setAttributionMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.mAttributionsView, left, top, right, bottom);
    }

    private void setWidgetGravity(@NonNull View view, int gravity) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.gravity = gravity;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setWidgetMargins(@NonNull View view, int left, int top, int right, int bottom) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.setMargins(left, top, right, bottom);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setWidgetMargins(@NonNull View view, float leftDp, float topDp, float rightDp, float bottomDp) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.setMargins((int)(leftDp * this.mScreenDensity), (int)(topDp * this.mScreenDensity), (int)(rightDp * this.mScreenDensity), (int)(bottomDp * this.mScreenDensity));
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void onLocationChanged(Location location) {
        this.updateLocation(location);
    }

    private void updateLocation(Location location) {
        if (location != null) {
            this.mGpsLocation = location;
            this.updateMap(MapChange.MapChangeNullChange);
        }
    }

    private void rotateImageView(ImageView imageView, float angle) {
        Matrix matrix = new Matrix();
        matrix.setScale((float)imageView.getWidth() / (float)imageView.getDrawable().getIntrinsicWidth(), (float)imageView.getHeight() / (float)imageView.getDrawable().getIntrinsicHeight());
        matrix.postRotate(angle, (float)imageView.getWidth() / 2.0f, (float)imageView.getHeight() / 2.0f);
        imageView.setImageMatrix(matrix);
        imageView.setScaleType(ImageView.ScaleType.MATRIX);
    }

    private void updateMap(MapChange change) {
        if (this.mIsCompassEnabled) {
            this.rotateImageView(this.mCompassView, (float)this.getDirection());
        }
        if (this.isMyLocationEnabled() && this.mGpsLocation != null) {
            long t;
            if (this.mGpsMarker == null) {
                this.mGpsMarker = new ImageView(this.getContext());
                this.mGpsMarker.setImageResource(R.drawable.location_marker);
                this.addView((View)this.mGpsMarker);
            }
            this.mGpsMarker.setVisibility(0);
            LatLng coordinate = new LatLng(this.mGpsLocation);
            PointF screenLocation = this.toScreenLocation(coordinate);
            float iconSize = 27.0f * this.mScreenDensity;
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams((int)iconSize, (int)iconSize);
            lp.leftMargin = (int)(screenLocation.x - iconSize / 2.0f);
            lp.topMargin = this.getHeight() - (int)(screenLocation.y + iconSize / 2.0f);
            this.mGpsMarker.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.rotateImageView(this.mGpsMarker, 0.0f);
            this.mGpsMarker.requestLayout();
            if (this.mUserLocationTrackingMode == UserLocationTrackingMode.FOLLOW_BEARING && this.mCompassValid && (t = new Date().getTime()) - this.t0 > 1000L) {
                this.t0 = t;
                this.setDirection(-this.mCompassBearing, true);
            }
        } else if (this.mGpsMarker != null) {
            this.mGpsMarker.setVisibility(4);
        }
        if (change.equals((Object)MapChange.MapChangeRegionWillChange) || change.equals((Object)MapChange.MapChangeRegionWillChangeAnimated)) {
            this.deselectAnnotation();
        }
    }

    private void selectAnnotation(Annotation annotation) {
        if (annotation == null) {
            return;
        }
        if (annotation == this.mSelectedAnnotation) {
            return;
        }
        if (annotation instanceof Marker) {
            this.deselectAnnotation();
            ((Marker)annotation).showInfoWindow();
            this.mSelectedAnnotation = annotation;
        }
    }

    private void deselectAnnotation() {
        Marker marker;
        if (this.mSelectedAnnotation != null && this.mSelectedAnnotation instanceof Marker && (marker = (Marker)this.mSelectedAnnotation).isInfoWindowShown()) {
            marker.hideInfoWindow();
            this.mSelectedAnnotation = null;
        }
    }

    private static class AttributionOnClickListener
    implements View.OnClickListener,
    DialogInterface.OnClickListener {
        private MapView mMapView;

        public AttributionOnClickListener(MapView mapView) {
            this.mMapView = mapView;
        }

        public void onClick(View v) {
            Context context = v.getContext();
            Object[] items = context.getResources().getStringArray(R.array.attribution_names);
            AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.AttributionAlertDialogStyle);
            builder.setTitle(R.string.attributionsDialogTitle);
            builder.setAdapter((ListAdapter)new ArrayAdapter(context, R.layout.attribution_list_item, items), (DialogInterface.OnClickListener)this);
            builder.show();
        }

        public void onClick(DialogInterface dialog, int which) {
            Context context = ((Dialog)dialog).getContext();
            String url = context.getResources().getStringArray(R.array.attribution_links)[which];
            if (which == 2) {
                LatLng latLng = this.mMapView.getCenterCoordinate();
                url = String.format(url, latLng.getLongitude(), latLng.getLatitude(), (int)this.mMapView.getZoomLevel());
            }
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            context.startActivity(intent);
        }
    }

    private class CompassOnClickListener
    implements View.OnClickListener {
        private CompassOnClickListener() {
        }

        public void onClick(View view) {
            MapView.this.resetNorth();
        }
    }

    private class CompassListener
    implements SensorEventListener {
        private CompassListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            switch (event.sensor.getType()) {
                case 1: {
                    System.arraycopy(event.values, 0, MapView.this.mValuesAccelerometer, 0, 3);
                    break;
                }
                case 2: {
                    System.arraycopy(event.values, 0, MapView.this.mValuesMagneticField, 0, 3);
                }
            }
            boolean valid = SensorManager.getRotationMatrix((float[])MapView.this.mMatrixR, (float[])MapView.this.mMatrixI, (float[])MapView.this.mValuesAccelerometer, (float[])MapView.this.mValuesMagneticField);
            if (valid) {
                SensorManager.getOrientation((float[])MapView.this.mMatrixR, (float[])MapView.this.mMatrixValues);
                Location mGpsLocation = MapView.this.getMyLocation();
                if (mGpsLocation != null) {
                    GeomagneticField geomagneticField = new GeomagneticField((float)mGpsLocation.getLatitude(), (float)mGpsLocation.getLongitude(), (float)mGpsLocation.getAltitude(), System.currentTimeMillis());
                    MapView.this.mCompassBearing = (float)Math.toDegrees(MapView.this.mMatrixValues[0]) + geomagneticField.getDeclination();
                    MapView.this.mCompassValid = true;
                }
            }
            MapView.this.updateMap(MapChange.MapChangeNullChange);
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    public static interface OnFpsChangedListener {
        public void onFpsChanged(double var1);
    }

    public static interface OnMapChangedListener {
        public void onMapChanged(MapChange var1);
    }

    public class ConnectivityReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                boolean noConnectivity = intent.getBooleanExtra("noConnectivity", false);
                MapView.this.onConnectivityChanged(!noConnectivity);
            }
        }
    }

    private class TrackballLongPressTimeOut
    implements Runnable {
        private boolean cancelled = false;

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                MapView.this.zoom(false);
                MapView.this.mCurrentTrackballLongPressTimeOut = null;
            }
        }
    }

    private class OnZoomListener
    implements ZoomButtonsController.OnZoomListener {
        private OnZoomListener() {
        }

        public void onVisibilityChanged(boolean visible) {
        }

        public void onZoom(boolean zoomIn) {
            if (!MapView.this.mZoomEnabled) {
                return;
            }
            MapView.this.zoom(zoomIn);
        }
    }

    private class RotateGestureListener
    extends RotateGestureDetector.SimpleOnRotateGestureListener {
        long mBeginTime = 0L;
        float mTotalAngle = 0.0f;
        boolean mStarted = false;

        private RotateGestureListener() {
        }

        @Override
        public boolean onRotateBegin(RotateGestureDetector detector) {
            if (!MapView.this.mRotateEnabled) {
                return false;
            }
            this.mBeginTime = detector.getEventTime();
            return true;
        }

        @Override
        public void onRotateEnd(RotateGestureDetector detector) {
            this.mBeginTime = 0L;
            this.mTotalAngle = 0.0f;
            this.mStarted = false;
        }

        @Override
        public boolean onRotate(RotateGestureDetector detector) {
            if (!MapView.this.mRotateEnabled) {
                return false;
            }
            this.mTotalAngle += detector.getRotationDegreesDelta();
            if (this.mTotalAngle > 5.0f || this.mTotalAngle < -5.0f) {
                this.mStarted = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.mBeginTime;
            if (!this.mStarted && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            MapView.this.mNativeMapView.cancelTransitions();
            double bearing = MapView.this.mNativeMapView.getBearing();
            MapView.this.mNativeMapView.setBearing(bearing += (double)detector.getRotationDegreesDelta(), detector.getFocusX() / MapView.this.mScreenDensity, detector.getFocusY() / MapView.this.mScreenDensity);
            return true;
        }
    }

    private class ScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        long mBeginTime = 0L;
        float mScaleFactor = 1.0f;
        boolean mStarted = false;

        private ScaleGestureListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            if (!MapView.this.mZoomEnabled) {
                return false;
            }
            this.mBeginTime = detector.getEventTime();
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            this.mBeginTime = 0L;
            this.mScaleFactor = 1.0f;
            this.mStarted = false;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            if (!MapView.this.mZoomEnabled) {
                return false;
            }
            this.mScaleFactor *= detector.getScaleFactor();
            if (this.mScaleFactor > 1.05f || this.mScaleFactor < 0.95f) {
                this.mStarted = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.mBeginTime;
            if (!this.mStarted && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            MapView.this.mNativeMapView.cancelTransitions();
            MapView.this.mNativeMapView.scaleBy(detector.getScaleFactor(), detector.getFocusX() / MapView.this.mScreenDensity, detector.getFocusY() / MapView.this.mScreenDensity);
            return true;
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            if (MapView.this.mZoomButtonsController != null && MapView.this.mZoomEnabled) {
                MapView.this.mZoomButtonsController.setVisible(true);
            }
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (!MapView.this.mZoomEnabled) {
                return false;
            }
            MapView.this.zoom(true, e.getX(), e.getY());
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            MapView.this.mNativeMapView.cancelTransitions();
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            float x = e.getX();
            float y = e.getY();
            y = (float)MapView.this.getHeight() - y;
            PointF tapPoint = new PointF(x, y);
            float toleranceWidth = 40.0f * MapView.this.mScreenDensity;
            float toleranceHeight = 60.0f * MapView.this.mScreenDensity;
            RectF tapRect = new RectF(tapPoint.x - toleranceWidth / 2.0f, tapPoint.y + 2.0f * toleranceHeight / 3.0f, tapPoint.x + toleranceWidth / 2.0f, tapPoint.y - 1.0f * toleranceHeight / 3.0f);
            List<LatLng> corners = Arrays.asList(MapView.this.fromScreenLocation(new PointF(tapRect.left, tapRect.bottom)), MapView.this.fromScreenLocation(new PointF(tapRect.left, tapRect.top)), MapView.this.fromScreenLocation(new PointF(tapRect.right, tapRect.top)), MapView.this.fromScreenLocation(new PointF(tapRect.right, tapRect.bottom)));
            BoundingBox tapBounds = BoundingBox.fromLatLngs(corners);
            List<Annotation> nearbyAnnotations = MapView.this.getAnnotationsInBounds(tapBounds);
            long newSelectedAnnotationID = -1L;
            if (nearbyAnnotations.size() > 0) {
                Collections.sort(nearbyAnnotations);
                if (nearbyAnnotations == MapView.this.mAnnotationsNearLastTap) {
                    if (MapView.this.mSelectedAnnotation != null && MapView.this.mSelectedAnnotation.getId() == ((Annotation)MapView.this.mAnnotationsNearLastTap.get(MapView.this.mAnnotationsNearLastTap.size() - 1)).getId()) {
                        newSelectedAnnotationID = ((Annotation)MapView.this.mAnnotationsNearLastTap.get(0)).getId();
                    } else if (MapView.this.mSelectedAnnotation != null) {
                        long currentID = MapView.this.mSelectedAnnotation.getId();
                        long result = MapView.this.mAnnotationsNearLastTap.indexOf(MapView.this.mSelectedAnnotation);
                        newSelectedAnnotationID = ((Annotation)MapView.this.mAnnotationsNearLastTap.get((int)result + 1)).getId();
                    } else {
                        newSelectedAnnotationID = ((Annotation)MapView.this.mAnnotationsNearLastTap.get(0)).getId();
                    }
                } else {
                    MapView.this.mAnnotationsNearLastTap = nearbyAnnotations;
                    newSelectedAnnotationID = ((Annotation)MapView.this.mAnnotationsNearLastTap.get(0)).getId();
                }
            } else {
                newSelectedAnnotationID = -1L;
            }
            if (newSelectedAnnotationID >= 0L) {
                for (Annotation annotation : MapView.this.mAnnotations) {
                    if (!(annotation instanceof Marker) || annotation.getId() != newSelectedAnnotationID) continue;
                    if (MapView.this.mSelectedAnnotation == null || annotation.getId() != MapView.this.mSelectedAnnotation.getId()) {
                        MapView.this.selectAnnotation(annotation);
                    }
                    break;
                }
            } else if (MapView.this.mSelectedAnnotation != null) {
                MapView.this.deselectAnnotation();
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
            MapView.this.performLongClick();
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!MapView.this.mScrollEnabled) {
                return false;
            }
            float ease = 0.25f;
            double speed = Math.sqrt((velocityX *= ease) * velocityX + (velocityY *= ease) * velocityY);
            double deceleration = 2500.0;
            double duration = speed / (deceleration * (double)ease);
            MapView.this.mNativeMapView.cancelTransitions();
            MapView.this.mNativeMapView.moveBy((double)velocityX * duration / 2.0 / (double)MapView.this.mScreenDensity, (double)velocityY * duration / 2.0 / (double)MapView.this.mScreenDensity, (long)(duration * 1000.0));
            if (MapView.this.onFlingListener != null) {
                MapView.this.onFlingListener.onFling();
            }
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!MapView.this.mScrollEnabled) {
                return false;
            }
            MapView.this.mNativeMapView.cancelTransitions();
            MapView.this.mNativeMapView.moveBy(-distanceX / MapView.this.mScreenDensity, -distanceY / MapView.this.mScreenDensity);
            if (MapView.this.onScrollListener != null) {
                MapView.this.onScrollListener.onScroll();
            }
            return true;
        }
    }

    private class SurfaceTextureListener
    implements TextureView.SurfaceTextureListener {
        private SurfaceTextureListener() {
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            MapView.this.mNativeMapView.createSurface(new Surface(surface));
            MapView.this.mNativeMapView.resizeFramebuffer(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            MapView.this.mNativeMapView.destroySurface();
            return true;
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            MapView.this.mNativeMapView.resizeFramebuffer(width, height);
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    }

    public static interface OnScrollListener {
        public void onScroll();
    }

    public static interface OnFlingListener {
        public void onFling();
    }

    private static enum MapChange {
        MapChangeNullChange(-1),
        MapChangeRegionWillChange(0),
        MapChangeRegionWillChangeAnimated(1),
        MapChangeRegionIsChanging(2),
        MapChangeRegionDidChange(3),
        MapChangeRegionDidChangeAnimated(4),
        MapChangeWillStartLoadingMap(5),
        MapChangeDidFinishLoadingMap(6),
        MapChangeDidFailLoadingMap(7),
        MapChangeWillStartRenderingFrame(8),
        MapChangeDidFinishRenderingFrame(9),
        MapChangeDidFinishRenderingFrameFullyRendered(10),
        MapChangeWillStartRenderingMap(11),
        MapChangeDidFinishRenderingMap(12),
        MapChangeDidFinishRenderingMapFullyRendered(13);

        private int value;

        private MapChange(int value) {
            this.value = value;
        }

        public static MapChange fromInteger(int value) {
            switch (value) {
                case -1: {
                    return MapChangeNullChange;
                }
                case 0: {
                    return MapChangeRegionWillChange;
                }
                case 1: {
                    return MapChangeRegionWillChangeAnimated;
                }
                case 2: {
                    return MapChangeRegionIsChanging;
                }
                case 3: {
                    return MapChangeRegionDidChange;
                }
                case 4: {
                    return MapChangeRegionDidChangeAnimated;
                }
                case 5: {
                    return MapChangeWillStartLoadingMap;
                }
                case 6: {
                    return MapChangeDidFinishLoadingMap;
                }
                case 7: {
                    return MapChangeDidFailLoadingMap;
                }
                case 8: {
                    return MapChangeWillStartRenderingFrame;
                }
                case 9: {
                    return MapChangeDidFinishRenderingFrame;
                }
                case 10: {
                    return MapChangeDidFinishRenderingFrameFullyRendered;
                }
                case 11: {
                    return MapChangeWillStartRenderingMap;
                }
                case 12: {
                    return MapChangeDidFinishRenderingMap;
                }
                case 13: {
                    return MapChangeDidFinishRenderingMapFullyRendered;
                }
            }
            return null;
        }
    }

    public static enum UserLocationTrackingMode {
        NONE,
        FOLLOW,
        FOLLOW_BEARING;

    }
}

