/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import com.mapbox.mapboxsdk.annotations.MultiPoint;
import com.mapbox.mapboxsdk.annotations.MultiPointOptions;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.geometry.LatLng;
import java.util.ArrayList;
import java.util.List;

public class PolygonOptions
extends MultiPointOptions {
    public PolygonOptions() {
        this.annotation = new Polygon();
    }

    public PolygonOptions add(LatLng point) {
        ((MultiPoint)this.annotation).points.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        for (LatLng point : points) {
            this.add(point);
        }
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng point : points) {
            this.add(point);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> hole = new ArrayList<LatLng>();
        for (LatLng point : points) {
            hole.add(point);
        }
        ((Polygon)this.annotation).holes.add(hole);
        return this;
    }

    public PolygonOptions fillColor(int color2) {
        ((Polygon)this.annotation).fillColor = color2;
        return this;
    }

    public int getFillColor() {
        return ((Polygon)this.annotation).fillColor;
    }

    public List<List<LatLng>> getHoles() {
        return ((Polygon)this.annotation).holes;
    }

    public Polygon getPolygon() {
        return (Polygon)this.annotation;
    }

    public int getStrokeColor() {
        return ((Polygon)this.annotation).strokeColor;
    }

    public float getStrokeWidth() {
        return ((Polygon)this.annotation).strokeWidth;
    }

    public PolygonOptions strokeColor(int color2) {
        ((Polygon)this.annotation).strokeColor = color2;
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        ((Polygon)this.annotation).strokeWidth = width;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.annotation.visible = visible;
        return this;
    }
}

