/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views;

import com.almeros.android.multitouch.RotateGestureDetector;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.util.OnMapOrientationChangeListener;

public class MapViewRotateGestureDetectorListener
implements RotateGestureDetector.OnRotateGestureListener {
    private static String TAG = "MapViewRotateListener";
    private final MapView mapView;
    private float firstAngle;
    private float currentDelta;

    public MapViewRotateGestureDetectorListener(MapView mv) {
        this.mapView = mv;
    }

    @Override
    public boolean onRotate(RotateGestureDetector detector) {
        float delta = detector.getRotationDegreesDelta();
        this.currentDelta += delta;
        float newAngle = this.firstAngle - this.currentDelta;
        this.mapView.setMapOrientation(newAngle);
        OnMapOrientationChangeListener l = this.mapView.getOnMapOrientationChangeListener();
        if (l != null) {
            l.onMapOrientationChange(newAngle);
        }
        return true;
    }

    @Override
    public boolean onRotateBegin(RotateGestureDetector detector) {
        this.firstAngle = this.mapView.getMapOrientation();
        this.currentDelta = 0.0f;
        return true;
    }

    @Override
    public void onRotateEnd(RotateGestureDetector detector) {
    }
}

