/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.os.Process;
import android.util.Log;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.MapTileRequestState;
import com.mapbox.mapboxsdk.tileprovider.constants.TileLayerConstants;
import com.mapbox.mapboxsdk.tileprovider.modules.ConfigurablePriorityThreadFactory;
import com.mapbox.mapboxsdk.tileprovider.tilesource.ITileLayer;
import com.mapbox.mapboxsdk.util.BitmapUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public abstract class MapTileModuleLayerBase
implements TileLayerConstants {
    private final ExecutorService mExecutor;
    protected final Object mQueueLockObject = new Object();
    protected final HashMap<MapTile, MapTileRequestState> mWorking;
    protected final LinkedHashMap<MapTile, MapTileRequestState> mPending;
    private static final String TAG = "MapTileModuleLayerBase";

    protected abstract String getName();

    protected abstract String getThreadGroupName();

    protected abstract Runnable getTileLoader();

    public abstract boolean getUsesDataConnection();

    public abstract float getMinimumZoomLevel();

    public abstract float getMaximumZoomLevel();

    public abstract BoundingBox getBoundingBox();

    public abstract LatLng getCenterCoordinate();

    public abstract float getCenterZoom();

    public abstract int getTileSizePixels();

    public abstract void setTileSource(ITileLayer var1);

    public abstract ITileLayer getTileSource();

    public abstract String getCacheKey();

    public MapTileRequestState popFirstPending() {
        Iterator<MapTile> i$ = this.mPending.keySet().iterator();
        if (i$.hasNext()) {
            MapTile tile = i$.next();
            return (MapTileRequestState)this.mPending.remove(tile);
        }
        return null;
    }

    public MapTileModuleLayerBase(int pThreadPoolSize, final int pPendingQueueSize) {
        if (pPendingQueueSize < pThreadPoolSize) {
            Log.w((String)TAG, (String)"The pending queue size is smaller than the thread pool size. Automatically reducing the thread pool size.");
            pThreadPoolSize = pPendingQueueSize;
        }
        this.mExecutor = Executors.newFixedThreadPool(pThreadPoolSize, new ConfigurablePriorityThreadFactory(5, this.getThreadGroupName()));
        this.mWorking = new HashMap();
        this.mPending = new LinkedHashMap<MapTile, MapTileRequestState>(pPendingQueueSize + 2, 0.1f, true){
            private static final long serialVersionUID = 6455337315681858866L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<MapTile, MapTileRequestState> pEldest) {
                while (this.size() > pPendingQueueSize) {
                    MapTileRequestState state = MapTileModuleLayerBase.this.popFirstPending();
                    state.getCallback().mapTileRequestFailed(state);
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMapTileAsync(MapTileRequestState pState) {
        Object object = this.mQueueLockObject;
        synchronized (object) {
            this.mPending.put(pState.getMapTile(), pState);
        }
        try {
            this.mExecutor.execute(this.getTileLoader());
        }
        catch (RejectedExecutionException e) {
            Log.w((String)TAG, (String)"RejectedExecutionException", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearQueue() {
        Object object = this.mQueueLockObject;
        synchronized (object) {
            this.mPending.clear();
            this.mWorking.clear();
        }
    }

    public void detach() {
        this.clearQueue();
        this.mExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTileFromQueues(MapTile mapTile) {
        Object object = this.mQueueLockObject;
        synchronized (object) {
            this.mPending.remove(mapTile);
            this.mWorking.remove(mapTile);
        }
    }

    public class CantContinueException
    extends Exception {
        private static final long serialVersionUID = 146526524087765133L;

        public CantContinueException(String pDetailMessage) {
            super(pDetailMessage);
        }

        public CantContinueException(Throwable pThrowable) {
            super(pThrowable);
        }
    }

    protected abstract class TileLoader
    implements Runnable {
        protected TileLoader() {
        }

        protected abstract Drawable loadTile(MapTileRequestState var1) throws CantContinueException;

        protected void onTileLoaderInit() {
        }

        protected void onTileLoaderShutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected MapTileRequestState nextTile() {
            Object object = MapTileModuleLayerBase.this.mQueueLockObject;
            synchronized (object) {
                MapTileRequestState state = MapTileModuleLayerBase.this.popFirstPending();
                if (state != null) {
                    MapTileModuleLayerBase.this.mWorking.put(state.getMapTile(), state);
                }
                return state;
            }
        }

        protected void tileLoaded(MapTileRequestState pState, Drawable pDrawable) {
            MapTileModuleLayerBase.this.removeTileFromQueues(pState.getMapTile());
            pState.getCallback().mapTileRequestCompleted(pState, pDrawable);
        }

        protected void tileLoadedExpired(MapTileRequestState pState, CacheableBitmapDrawable pDrawable) {
            MapTileModuleLayerBase.this.removeTileFromQueues(pState.getMapTile());
            pState.getCallback().mapTileRequestExpiredTile(pState, pDrawable);
        }

        protected void tileLoadedFailed(MapTileRequestState pState) {
            MapTileModuleLayerBase.this.removeTileFromQueues(pState.getMapTile());
            pState.getCallback().mapTileRequestFailed(pState);
        }

        @Override
        public void run() {
            MapTileRequestState state;
            Process.setThreadPriority((int)10);
            this.onTileLoaderInit();
            Drawable result = null;
            while ((state = this.nextTile()) != null) {
                try {
                    result = null;
                    result = this.loadTile(state);
                }
                catch (CantContinueException e) {
                    Log.e((String)MapTileModuleLayerBase.TAG, (String)("Tile loader can't continue: " + state.getMapTile()), (Throwable)e);
                    MapTileModuleLayerBase.this.clearQueue();
                }
                catch (Throwable e) {
                    Log.e((String)MapTileModuleLayerBase.TAG, (String)("Error downloading tile: " + state.getMapTile()), (Throwable)e);
                }
                if (result == null) {
                    this.tileLoadedFailed(state);
                    continue;
                }
                if (BitmapUtils.isCacheDrawableExpired(result)) {
                    this.tileLoadedExpired(state, (CacheableBitmapDrawable)result);
                    continue;
                }
                this.tileLoaded(state, result);
            }
            this.onTileLoaderShutdown();
        }
    }
}

