/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.tileprovider.IMapTileProviderCallback;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.MapTileCache;
import com.mapbox.mapboxsdk.tileprovider.MapTileRequestState;
import com.mapbox.mapboxsdk.tileprovider.constants.TileLayerConstants;
import com.mapbox.mapboxsdk.tileprovider.tilesource.ITileLayer;
import com.mapbox.mapboxsdk.util.BitmapUtils;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public abstract class MapTileLayerBase
implements IMapTileProviderCallback,
TileLayerConstants {
    protected Context context;
    protected final MapTileCache mTileCache;
    private Handler mTileRequestCompleteHandler;
    private boolean mUseDataConnection = true;
    private ITileLayer mTileSource;
    protected String mCacheKey = "";
    private static final String TAG = "MapTileLayerBase";

    public abstract Drawable getMapTile(MapTile var1, boolean var2);

    public abstract void detach();

    public float getMinimumZoomLevel() {
        return this.mTileSource.getMinimumZoomLevel();
    }

    public float getMaximumZoomLevel() {
        return this.mTileSource.getMaximumZoomLevel();
    }

    public int getTileSizePixels() {
        return this.mTileSource.getTileSizePixels();
    }

    public BoundingBox getBoundingBox() {
        return this.mTileSource.getBoundingBox();
    }

    public LatLng getCenterCoordinate() {
        return this.mTileSource.getCenterCoordinate();
    }

    public float getCenterZoom() {
        return this.mTileSource.getCenterZoom();
    }

    public void setTileSource(ITileLayer pTileSource) {
        if (this.mTileSource != null) {
            this.mTileSource.detach();
        }
        this.mTileSource = pTileSource;
        if (this.mTileSource != null) {
            this.mCacheKey = this.mTileSource.getCacheKey();
        }
    }

    public ITileLayer getTileSource() {
        return this.mTileSource;
    }

    public String getCacheKey() {
        return this.mCacheKey;
    }

    public MapTileCache createTileCache(Context aContext) {
        return new MapTileCache(aContext);
    }

    public MapTileLayerBase(Context aContext, ITileLayer pTileSource) {
        this(aContext, pTileSource, null);
    }

    public MapTileLayerBase(Context aContext, ITileLayer pTileSource, Handler pDownloadFinishedListener) {
        this.context = aContext;
        this.mTileRequestCompleteHandler = pDownloadFinishedListener;
        this.mTileSource = pTileSource;
        this.mTileCache = this.createTileCache(aContext);
    }

    @Override
    public void mapTileRequestCompleted(MapTileRequestState pState, Drawable pDrawable) {
        if (this.mTileRequestCompleteHandler != null) {
            Message msg = new Message();
            msg.obj = pState.getMapTile().getTileRect();
            msg.what = 0;
            this.mTileRequestCompleteHandler.sendMessage(msg);
        } else {
            Log.e((String)TAG, (String)"Failed to send map update request because mTileRequestCompleteHandler == null");
        }
    }

    @Override
    public void mapTileRequestFailed(MapTileRequestState pState) {
        if (this.mTileRequestCompleteHandler != null) {
            this.mTileRequestCompleteHandler.sendEmptyMessage(1);
        }
    }

    @Override
    public void mapTileRequestExpiredTile(MapTileRequestState pState, CacheableBitmapDrawable pDrawable) {
        this.putExpiredTileIntoCache(pState.getMapTile(), pDrawable.getBitmap());
        if (this.mTileRequestCompleteHandler != null) {
            this.mTileRequestCompleteHandler.sendEmptyMessage(0);
        }
    }

    private void putTileIntoCacheInternal(MapTile pTile, Drawable pDrawable) {
        this.mTileCache.putTile(pTile, pDrawable);
    }

    private void putTileIntoCache(MapTile pTile, Drawable pDrawable) {
        if (pDrawable != null) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                new CacheTask().execute(new Object[]{pTile, pDrawable});
            } else {
                this.putTileIntoCacheInternal(pTile, pDrawable);
            }
        }
    }

    protected void putTileIntoCache(MapTileRequestState pState, Drawable pDrawable) {
        this.putTileIntoCache(pState.getMapTile(), pDrawable);
    }

    protected void removeTileFromCache(MapTileRequestState pState) {
        this.mTileCache.removeTileFromMemory(pState.getMapTile());
    }

    public void putExpiredTileIntoCache(MapTile pTile, Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        CacheableBitmapDrawable drawable2 = this.mTileCache.putTileInMemoryCache(pTile, bitmap);
        BitmapUtils.setCacheDrawableExpired(drawable2);
    }

    public void setTileRequestCompleteHandler(Handler handler) {
        this.mTileRequestCompleteHandler = handler;
    }

    public void clearTileMemoryCache() {
        this.mTileCache.purgeMemoryCache();
    }

    public void memoryCacheNeedsMoreMemory(int numberOfTiles) {
        this.mTileCache.getCache().resizeMemoryForTiles(numberOfTiles);
    }

    public void clearTileDiskCache() {
        this.mTileCache.purgeDiskCache();
    }

    public void setDiskCacheEnabled(boolean enabled) {
        this.mTileCache.setDiskCacheEnabled(enabled);
    }

    @Override
    public boolean useDataConnection() {
        return this.mUseDataConnection;
    }

    public void setUseDataConnection(boolean pMode) {
        this.mUseDataConnection = pMode;
    }

    public boolean hasNoSource() {
        return this.mTileSource == null;
    }

    public CacheableBitmapDrawable getMapTileFromMemory(MapTile pTile) {
        return this.mTileCache != null ? this.mTileCache.getMapTileFromMemory(pTile) : null;
    }

    public CacheableBitmapDrawable createCacheableBitmapDrawable(Bitmap bitmap, MapTile aTile) {
        return this.mTileCache != null ? this.mTileCache.createCacheableBitmapDrawable(bitmap, aTile) : null;
    }

    public Bitmap getBitmapFromRemoved(int width, int height) {
        return this.mTileCache != null ? this.mTileCache.getBitmapFromRemoved(width, height) : null;
    }

    public void removeTileFromMemory(MapTile aTile) {
        if (this.mTileCache != null) {
            this.mTileCache.removeTileFromMemory(aTile);
        }
    }

    private class CacheTask
    extends AsyncTask<Object, Void, Void> {
        private CacheTask() {
        }

        protected Void doInBackground(Object ... params) {
            MapTileLayerBase.this.putTileIntoCacheInternal((MapTile)params[0], (Drawable)params[1]);
            return null;
        }
    }
}

