/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.view.MotionEvent;
import com.mapbox.mapboxsdk.clustering.Cluster;
import com.mapbox.mapboxsdk.clustering.algo.NonHierarchicalDistanceBasedAlgorithm;
import com.mapbox.mapboxsdk.clustering.algo.PreCachingAlgorithmDecorator;
import com.mapbox.mapboxsdk.events.MapListener;
import com.mapbox.mapboxsdk.events.RotateEvent;
import com.mapbox.mapboxsdk.events.ScrollEvent;
import com.mapbox.mapboxsdk.events.ZoomEvent;
import com.mapbox.mapboxsdk.overlay.ClusterMarker;
import com.mapbox.mapboxsdk.overlay.Marker;
import com.mapbox.mapboxsdk.overlay.Overlay;
import com.mapbox.mapboxsdk.overlay.SafeDrawOverlay;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.safecanvas.ISafeCanvas;
import com.mapbox.mapboxsdk.views.safecanvas.SafePaint;
import com.mapbox.mapboxsdk.views.util.Projection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class ItemizedOverlay
extends SafeDrawOverlay
implements Overlay.Snappable,
MapListener {
    private static final String TAG = ItemizedOverlay.class.getSimpleName();
    private final ArrayList<Marker> mInternalItemList;
    private ArrayList<ClusterMarker> mInternalClusterList;
    protected boolean mDrawFocusedItem = true;
    private Marker mFocusedItem;
    private boolean mPendingFocusChangedEvent = false;
    private OnFocusChangeListener mOnFocusChangeListener;
    private boolean mIsClusteringEnabled;
    private ClusterMarker.OnDrawClusterListener mOnDrawClusterListener;
    private static SafePaint mClusterTextPaint;
    private CalculateClusterTask mCalculateClusterTask;
    private float mMinZoomForClustering = 22.0f;
    private PreCachingAlgorithmDecorator<Marker> mAlgorithm;

    protected abstract Marker createItem(int var1);

    public abstract int size();

    public ItemizedOverlay() {
        if (mClusterTextPaint == null) {
            mClusterTextPaint = new SafePaint();
            mClusterTextPaint.setTextAlign(Paint.Align.CENTER);
            mClusterTextPaint.setTextSize(30.0f);
            mClusterTextPaint.setFakeBoldText(true);
        }
        this.mAlgorithm = new PreCachingAlgorithmDecorator(new NonHierarchicalDistanceBasedAlgorithm());
        this.mInternalItemList = new ArrayList();
        this.mInternalClusterList = new ArrayList();
    }

    @Override
    protected void drawSafe(ISafeCanvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (this.mPendingFocusChangedEvent && this.mOnFocusChangeListener != null) {
            this.mOnFocusChangeListener.onFocusChanged(this, this.mFocusedItem);
        }
        this.mPendingFocusChangedEvent = false;
        Projection pj = mapView.getProjection();
        int size = this.mInternalItemList.size() - 1;
        RectF bounds = new RectF(0.0f, 0.0f, (float)mapView.getMeasuredWidth(), (float)mapView.getMeasuredHeight());
        pj.rotateRect(bounds);
        float mapScale = 1.0f / mapView.getScale();
        if (!this.mIsClusteringEnabled || mapView.getZoomLevel() > this.mMinZoomForClustering) {
            for (int i = size; i >= 0; --i) {
                Marker item = this.getItem(i);
                if (item == this.mFocusedItem) continue;
                this.onDrawItem(canvas, item, pj, mapView.getMapOrientation(), bounds, mapScale);
            }
            if (this.mFocusedItem != null) {
                this.onDrawItem(canvas, this.mFocusedItem, pj, mapView.getMapOrientation(), bounds, mapScale);
            }
        } else if (this.mInternalClusterList != null) {
            for (int i = this.mInternalClusterList.size() - 1; i >= 0; --i) {
                ClusterMarker clusterMarker = this.mInternalClusterList.get(i);
                List<Marker> markerList = clusterMarker.getMarkersReadOnly();
                if (markerList.size() > 1) {
                    this.onDrawItem(canvas, clusterMarker, pj, mapView.getMapOrientation(), bounds, mapScale);
                    continue;
                }
                this.onDrawItem(canvas, markerList.get(0), pj, mapView.getMapOrientation(), bounds, mapScale);
            }
        }
    }

    protected void populate() {
        int size = this.size();
        this.mAlgorithm.clearItems();
        this.mInternalItemList.clear();
        this.mInternalItemList.ensureCapacity(size);
        for (int a = 0; a < size; ++a) {
            this.mInternalItemList.add(this.createItem(a));
        }
        this.mAlgorithm.addItems(this.mInternalItemList);
    }

    public final Marker getItem(int position) {
        return this.mInternalItemList.get(position);
    }

    protected void onDrawItem(ISafeCanvas canvas, Marker item, Projection projection, final float aMapOrientation, RectF mapBounds, float mapScale) {
        item.updateDrawingPosition();
        PointF position = item.getPositionOnMap();
        final Point roundedCoords = new Point((int)position.x, (int)position.y);
        if (!RectF.intersects((RectF)mapBounds, (RectF)item.getDrawingBounds(projection, null))) {
            return;
        }
        canvas.save();
        canvas.scale(mapScale, mapScale, position.x, position.y);
        int state = this.mDrawFocusedItem && this.mFocusedItem == item ? 4 : 0;
        final Drawable marker = item.getMarker(state);
        if (marker == null) {
            return;
        }
        final Point point = item.getAnchor();
        if (this.isUsingSafeCanvas()) {
            Overlay.drawAt(canvas.getSafeCanvas(), marker, roundedCoords, point, false, aMapOrientation);
        } else {
            canvas.getUnsafeCanvas(new ISafeCanvas.UnsafeCanvasHandler(){

                @Override
                public void onUnsafeCanvas(Canvas canvas) {
                    Overlay.drawAt(canvas, marker, roundedCoords, point, false, aMapOrientation);
                }
            });
        }
        canvas.restore();
    }

    protected boolean markerHitTest(Marker pMarker, Projection pProjection, float pX, float pY) {
        RectF rect = pMarker.getHitBounds(pProjection, null);
        return rect.contains(pX, pY);
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent e, MapView mapView) {
        int size = this.size();
        Projection projection = mapView.getProjection();
        float x = e.getX();
        float y = e.getY();
        for (int i = 0; i < size; ++i) {
            Marker item = this.getItem(i);
            if (!this.markerHitTest(item, projection, x, y) || !this.onTap(i)) continue;
            return true;
        }
        return super.onSingleTapConfirmed(e, mapView);
    }

    protected boolean onTap(int index) {
        return false;
    }

    public void setDrawFocusedItem(boolean drawFocusedItem) {
        this.mDrawFocusedItem = drawFocusedItem;
    }

    public void setFocus(Marker item) {
        this.mPendingFocusChangedEvent = item != this.mFocusedItem;
        this.mFocusedItem = item;
    }

    public Marker getFocus() {
        return this.mFocusedItem;
    }

    public void blurItem(Marker item) {
        if (this.mFocusedItem == item) {
            this.setFocus(null);
        }
    }

    public void setOnFocusChangeListener(OnFocusChangeListener l) {
        this.mOnFocusChangeListener = l;
    }

    public void setClusteringEnabled(boolean enabled, ClusterMarker.OnDrawClusterListener onDrawClusterListener, float minZoom) {
        this.mIsClusteringEnabled = enabled;
        this.mOnDrawClusterListener = onDrawClusterListener;
        this.mMinZoomForClustering = minZoom;
    }

    @Override
    public void onScroll(ScrollEvent event) {
    }

    @Override
    public void onZoom(ZoomEvent event) {
        if (this.mIsClusteringEnabled && event.getZoomLevel() < this.mMinZoomForClustering) {
            if (this.mCalculateClusterTask != null && this.mCalculateClusterTask.getStatus() != AsyncTask.Status.FINISHED) {
                this.mCalculateClusterTask.cancel(true);
            }
            this.mCalculateClusterTask = new CalculateClusterTask(event);
            this.mCalculateClusterTask.execute(new Void[0]);
        }
    }

    @Override
    public void onRotate(RotateEvent event) {
    }

    public ClusterMarker.OnDrawClusterListener getOnDrawClusterListener() {
        return this.mOnDrawClusterListener;
    }

    public boolean isClusteringEnabled() {
        return this.mIsClusteringEnabled;
    }

    private class CalculateClusterTask
    extends AsyncTask<Void, Void, ArrayList<ClusterMarker>> {
        private ZoomEvent mZoomEvent;

        public CalculateClusterTask(ZoomEvent event) {
            this.mZoomEvent = event;
        }

        protected ArrayList<ClusterMarker> doInBackground(Void ... voids) {
            ArrayList<ClusterMarker> clusterMarkers = new ArrayList<ClusterMarker>();
            Set clusters = ItemizedOverlay.this.mAlgorithm.getClusters(this.mZoomEvent.getZoomLevel());
            for (Cluster cluster : clusters) {
                Collection<Marker> markers = cluster.getItems();
                if (markers.size() <= 0) continue;
                ClusterMarker clusterMarker = new ClusterMarker();
                clusterMarker.addMarkersToCluster(markers);
                clusterMarker.addTo(this.mZoomEvent.getSource());
                clusterMarker.setPoint(cluster.getPosition());
                if (ItemizedOverlay.this.mOnDrawClusterListener != null) {
                    Drawable drawable2 = ItemizedOverlay.this.mOnDrawClusterListener.drawCluster(clusterMarker);
                    clusterMarker.setMarker(drawable2);
                }
                clusterMarkers.add(clusterMarker);
            }
            return clusterMarkers;
        }

        protected void onPostExecute(ArrayList<ClusterMarker> clusterList) {
            ItemizedOverlay.this.mInternalClusterList = clusterList;
            this.mZoomEvent.getSource().invalidate();
        }
    }

    public static interface OnFocusChangeListener {
        public void onFocusChanged(ItemizedOverlay var1, Marker var2);
    }
}

