/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.content.Context;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

public class OfflineDatabaseHandler
extends SQLiteOpenHelper {
    private static OfflineDatabaseHandler offlineDatabaseHandler;
    private static final String TAG = "OfflineDatabaseHandler";
    public static final int DATABASE_VERSION = 2;
    public static final String TABLE_METADATA = "metadata";
    public static final String TABLE_RESOURCES = "resources";
    public static final String FIELD_METADATA_NAME = "name";
    public static final String FIELD_METADATA_VALUE = "value";
    public static final String FIELD_RESOURCES_URL = "url";
    public static final String FIELD_RESOURCES_DATA = "data";
    public static final String FIELD_RESOURCES_STATUS = "status";

    public OfflineDatabaseHandler(Context context, String dbName) {
        super(context, dbName, null, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate(SQLiteDatabase db) {
        Log.i((String)TAG, (String)"onCreate() called... Setting up application's database.");
        String metadata = "CREATE TABLE metadata (name TEXT UNIQUE, value TEXT);";
        String resources = "CREATE TABLE resources (url TEXT UNIQUE, data BLOB, status TEXT);";
        db.beginTransaction();
        try {
            db.execSQL(metadata);
            db.execSQL(resources);
            db.setTransactionSuccessful();
        }
        catch (SQLException e) {
            Log.e((String)TAG, (String)("Error creating database: " + e.toString()));
            e.printStackTrace();
        }
        finally {
            db.endTransaction();
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.w((String)TAG, (String)("Upgrading database from version " + oldVersion + " to " + newVersion + ", which will destroy all old data"));
        db.execSQL("drop table if exists metadata");
        db.execSQL("drop table if exists resources");
        this.onCreate(db);
    }
}

