/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.clustering.algo;

import android.support.v4.util.LruCache;
import android.util.Log;
import com.mapbox.mapboxsdk.clustering.Cluster;
import com.mapbox.mapboxsdk.clustering.ClusterItem;
import com.mapbox.mapboxsdk.clustering.algo.Algorithm;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PreCachingAlgorithmDecorator<T extends ClusterItem>
implements Algorithm<T> {
    private final Algorithm<T> mAlgorithm;
    private final LruCache<Integer, Set<? extends Cluster<T>>> mCache = new LruCache(5);
    private final ReadWriteLock mCacheLock = new ReentrantReadWriteLock();

    public PreCachingAlgorithmDecorator(Algorithm<T> algorithm) {
        this.mAlgorithm = algorithm;
    }

    @Override
    public void addItem(T item) {
        this.mAlgorithm.addItem(item);
        this.clearCache();
    }

    @Override
    public void addItems(Collection<T> items) {
        this.mAlgorithm.addItems(items);
        this.clearCache();
    }

    @Override
    public void clearItems() {
        this.mAlgorithm.clearItems();
        this.clearCache();
    }

    @Override
    public void removeItem(T item) {
        this.mAlgorithm.removeItem(item);
        this.clearCache();
    }

    private void clearCache() {
        this.mCache.evictAll();
    }

    @Override
    public Set<? extends Cluster<T>> getClusters(double zoom) {
        int discreteZoom = (int)zoom;
        Set<Cluster<T>> results = this.getClustersInternal(discreteZoom);
        if (this.mCache.get((Object)(discreteZoom + 1)) == null) {
            new Thread(new PrecacheRunnable(discreteZoom + 1)).start();
        }
        if (this.mCache.get((Object)(discreteZoom - 1)) == null) {
            new Thread(new PrecacheRunnable(discreteZoom - 1)).start();
        }
        return results;
    }

    @Override
    public Collection<T> getItems() {
        return this.mAlgorithm.getItems();
    }

    private Set<? extends Cluster<T>> getClustersInternal(int discreteZoom) {
        this.mCacheLock.readLock().lock();
        Set<Cluster<T>> results = (Set<Cluster<T>>)this.mCache.get((Object)discreteZoom);
        this.mCacheLock.readLock().unlock();
        if (results == null) {
            this.mCacheLock.writeLock().lock();
            results = (Set)this.mCache.get((Object)discreteZoom);
            if (results == null) {
                results = this.mAlgorithm.getClusters(discreteZoom);
                this.mCache.put((Object)discreteZoom, results);
            }
            this.mCacheLock.writeLock().unlock();
        }
        return results;
    }

    private class PrecacheRunnable
    implements Runnable {
        private final int mZoom;

        public PrecacheRunnable(int zoom) {
            this.mZoom = zoom;
        }

        @Override
        public void run() {
            try {
                Thread.sleep((long)(Math.random() * 500.0 + 500.0));
            }
            catch (InterruptedException e) {
                Log.e((String)"PrecahceRunnable", (String)e.toString());
            }
            PreCachingAlgorithmDecorator.this.getClustersInternal(this.mZoom);
        }
    }
}

