/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.clustering.algo;

import com.mapbox.mapboxsdk.clustering.Cluster;
import com.mapbox.mapboxsdk.clustering.ClusterItem;
import com.mapbox.mapboxsdk.clustering.algo.Algorithm;
import com.mapbox.mapboxsdk.clustering.algo.StaticCluster;
import com.mapbox.mapboxsdk.clustering.geometry.Bounds;
import com.mapbox.mapboxsdk.clustering.geometry.Point;
import com.mapbox.mapboxsdk.clustering.projection.SphericalMercatorProjection;
import com.mapbox.mapboxsdk.clustering.quadtree.PointQuadTree;
import com.mapbox.mapboxsdk.geometry.LatLng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class NonHierarchicalDistanceBasedAlgorithm<T extends ClusterItem>
implements Algorithm<T> {
    public static final int MAX_DISTANCE_AT_ZOOM = 100;
    private final Collection<QuadItem<T>> mItems = new ArrayList<QuadItem<T>>();
    private final PointQuadTree<QuadItem<T>> mQuadTree = new PointQuadTree(0.0, 1.0, 0.0, 1.0);
    private static final SphericalMercatorProjection PROJECTION = new SphericalMercatorProjection(1.0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addItem(T item) {
        QuadItem quadItem = new QuadItem((ClusterItem)item, null);
        PointQuadTree<QuadItem<T>> pointQuadTree = this.mQuadTree;
        synchronized (pointQuadTree) {
            this.mItems.add(quadItem);
            this.mQuadTree.add(quadItem);
        }
    }

    @Override
    public void addItems(Collection<T> items) {
        for (ClusterItem item : items) {
            this.addItem(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearItems() {
        PointQuadTree<QuadItem<T>> pointQuadTree = this.mQuadTree;
        synchronized (pointQuadTree) {
            this.mItems.clear();
            this.mQuadTree.clear();
        }
    }

    @Override
    public void removeItem(T item) {
        throw new UnsupportedOperationException("NonHierarchicalDistanceBasedAlgorithm.remove not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<? extends Cluster<T>> getClusters(double zoom) {
        int discreteZoom = (int)zoom;
        double zoomSpecificSpan = 100.0 / Math.pow(2.0, discreteZoom) / 256.0;
        HashSet<QuadItem<T>> visitedCandidates = new HashSet<QuadItem<T>>();
        HashSet<Cluster<T>> results = new HashSet<Cluster<T>>();
        HashMap<QuadItem<T>, Double> distanceToCluster = new HashMap<QuadItem<T>, Double>();
        HashMap itemToCluster = new HashMap();
        PointQuadTree<QuadItem<T>> pointQuadTree = this.mQuadTree;
        synchronized (pointQuadTree) {
            for (QuadItem<T> candidate : this.mItems) {
                if (visitedCandidates.contains(candidate)) continue;
                Bounds searchBounds = this.createBoundsFromSpan(candidate.getPoint(), zoomSpecificSpan);
                Collection<QuadItem<T>> clusterItems = this.mQuadTree.search(searchBounds);
                if (clusterItems.size() == 1) {
                    results.add(candidate);
                    visitedCandidates.add(candidate);
                    distanceToCluster.put(candidate, 0.0);
                    continue;
                }
                StaticCluster<ClusterItem> cluster = new StaticCluster<ClusterItem>(((QuadItem)candidate).mClusterItem.getPosition());
                results.add(cluster);
                for (QuadItem<T> clusterItem : clusterItems) {
                    Double existingDistance = (Double)distanceToCluster.get(clusterItem);
                    double distance = this.distanceSquared(clusterItem.getPoint(), candidate.getPoint());
                    if (existingDistance != null) {
                        if (existingDistance < distance) continue;
                        ((StaticCluster)itemToCluster.get(clusterItem)).remove(((QuadItem)clusterItem).mClusterItem);
                    }
                    distanceToCluster.put(clusterItem, distance);
                    cluster.add(((QuadItem)clusterItem).mClusterItem);
                    itemToCluster.put(clusterItem, cluster);
                }
                visitedCandidates.addAll(clusterItems);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> getItems() {
        ArrayList<ClusterItem> items = new ArrayList<ClusterItem>();
        PointQuadTree<QuadItem<T>> pointQuadTree = this.mQuadTree;
        synchronized (pointQuadTree) {
            for (QuadItem<T> quadItem : this.mItems) {
                items.add(((QuadItem)quadItem).mClusterItem);
            }
        }
        return items;
    }

    private double distanceSquared(Point a, Point b) {
        return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
    }

    private Bounds createBoundsFromSpan(Point p, double span) {
        double halfSpan = span / 2.0;
        return new Bounds(p.x - halfSpan, p.x + halfSpan, p.y - halfSpan, p.y + halfSpan);
    }

    static class 1 {
    }

    private static class QuadItem<T extends ClusterItem>
    implements PointQuadTree.Item,
    Cluster<T> {
        private final T mClusterItem;
        private final Point mPoint;
        private final LatLng mPosition;
        private Set<T> singletonSet;

        private QuadItem(T item) {
            this.mClusterItem = item;
            this.mPosition = item.getPosition();
            this.mPoint = PROJECTION.toPoint(this.mPosition);
            this.singletonSet = Collections.singleton(this.mClusterItem);
        }

        @Override
        public Point getPoint() {
            return this.mPoint;
        }

        @Override
        public LatLng getPosition() {
            return this.mPosition;
        }

        @Override
        public Set<T> getItems() {
            return this.singletonSet;
        }

        @Override
        public int getSize() {
            return 1;
        }

        /* synthetic */ QuadItem(ClusterItem x0, 1 x1) {
            this(x0);
        }
    }
}

