/*
 * Decompiled with CFR 0.152.
 */
package com.cocoahero.android.geojson;

import com.cocoahero.android.geojson.Feature;
import com.cocoahero.android.geojson.FeatureCollection;
import com.cocoahero.android.geojson.GeoJSONObject;
import com.cocoahero.android.geojson.GeometryCollection;
import com.cocoahero.android.geojson.LineString;
import com.cocoahero.android.geojson.MultiLineString;
import com.cocoahero.android.geojson.MultiPoint;
import com.cocoahero.android.geojson.MultiPolygon;
import com.cocoahero.android.geojson.Point;
import com.cocoahero.android.geojson.Polygon;
import com.cocoahero.android.geojson.util.JSONUtils;
import com.cocoahero.android.geojson.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class GeoJSON {
    public static final String TYPE_POINT = "Point";
    public static final String TYPE_MULTI_POINT = "MultiPoint";
    public static final String TYPE_LINE_STRING = "LineString";
    public static final String TYPE_MULTI_LINE_STRING = "MultiLineString";
    public static final String TYPE_POLYGON = "Polygon";
    public static final String TYPE_MULTI_POLYGON = "MultiPolygon";
    public static final String TYPE_GEOMETRY_COLLECTION = "GeometryCollection";
    public static final String TYPE_FEATURE = "Feature";
    public static final String TYPE_FEATURE_COLLECTION = "FeatureCollection";

    public static GeoJSONObject parse(JSONObject json) {
        String type = JSONUtils.optString(json, "type");
        if (TYPE_POINT.equalsIgnoreCase(type)) {
            return new Point(json);
        }
        if (TYPE_MULTI_POINT.equalsIgnoreCase(type)) {
            return new MultiPoint(json);
        }
        if (TYPE_LINE_STRING.equalsIgnoreCase(type)) {
            return new LineString(json);
        }
        if (TYPE_MULTI_LINE_STRING.equalsIgnoreCase(type)) {
            return new MultiLineString(json);
        }
        if (TYPE_POLYGON.equalsIgnoreCase(type)) {
            return new Polygon(json);
        }
        if (TYPE_MULTI_POLYGON.equalsIgnoreCase(type)) {
            return new MultiPolygon(json);
        }
        if (TYPE_GEOMETRY_COLLECTION.equalsIgnoreCase(type)) {
            return new GeometryCollection(json);
        }
        if (TYPE_FEATURE.equalsIgnoreCase(type)) {
            return new Feature(json);
        }
        if (TYPE_FEATURE_COLLECTION.equalsIgnoreCase(type)) {
            return new FeatureCollection(json);
        }
        throw new IllegalArgumentException("The type '" + type + "' is not a valid GeoJSON type.");
    }

    public static GeoJSONObject parse(String jsonString) throws JSONException {
        return GeoJSON.parse(new JSONObject(jsonString));
    }

    public static GeoJSONObject parse(InputStream stream) throws IOException, JSONException {
        return GeoJSON.parse(StreamUtils.toString(stream));
    }
}

