/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class NumberBitmapDrawable
extends BitmapDrawable {
    protected int mCount;
    protected Paint mPaint;
    private static final int TEXT_SIZE = 16;

    public NumberBitmapDrawable(Resources res, Bitmap bitmap) {
        this(res, bitmap, 0);
    }

    public NumberBitmapDrawable(Resources res, Bitmap bitmap, int count) {
        super(res, bitmap);
        this.mCount = count;
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setAntiAlias(true);
        paint.setDither(true);
        paint.setTextSize(TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)res.getDisplayMetrics()));
        paint.setTextAlign(Paint.Align.CENTER);
        this.setTextPaint(paint);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.drawText(canvas);
    }

    protected void drawText(Canvas canvas) {
        canvas.drawText(String.valueOf(this.mCount), (float)this.getBounds().centerX(), (float)this.getBounds().centerY() + this.mPaint.descent(), this.mPaint);
    }

    public void setCount(int count) {
        this.mCount = count;
    }

    public int getCount() {
        return this.mCount;
    }

    public void setTextPaint(Paint paint) {
        this.mPaint = paint;
    }
}

