/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.overlay.Overlay;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.util.Projection;
import java.util.ArrayList;
import java.util.List;

public class PathOverlay
extends Overlay {
    private static final String TAG = "PathOverlay";
    private ArrayList<PointF> mPoints;
    private int mPointsPrecomputed;
    private boolean mOptimizePath = true;
    protected Paint mPaint = new Paint();
    private final Path mPath = new Path();
    private final PointF mTempPoint1 = new PointF();
    private final PointF mTempPoint2 = new PointF();
    private final Rect mLineBounds = new Rect();

    public PathOverlay() {
        this.mPaint.setColor(-16776961);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(10.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.clearPath();
        this.setOverlayIndex(1);
    }

    public PathOverlay(int color, float width) {
        this.mPaint.setColor(color);
        this.mPaint.setStrokeWidth(width);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.clearPath();
        this.setOverlayIndex(1);
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public PathOverlay setPaint(Paint pPaint) {
        this.mPaint = pPaint;
        return this;
    }

    public void clearPath() {
        this.mPoints = new ArrayList();
        this.mPointsPrecomputed = 0;
    }

    public void addPoint(LatLng aPoint) {
        this.addPoint(aPoint.getLatitude(), aPoint.getLongitude());
    }

    public void addPoint(double aLatitude, double aLongitude) {
        this.mPoints.add(new PointF((float)aLatitude, (float)aLongitude));
    }

    public void addPoints(LatLng ... aPoints) {
        for (LatLng point : aPoints) {
            this.addPoint(point);
        }
    }

    public void addPoints(List<LatLng> aPoints) {
        for (LatLng point : aPoints) {
            this.addPoint(point);
        }
    }

    public void removeAllPoints() {
        this.mPoints.clear();
    }

    public int getNumberOfPoints() {
        return this.mPoints.size();
    }

    @Override
    protected void draw(Canvas canvas, MapView mapView, boolean shadow) {
        int size = this.mPoints.size();
        if (shadow || size < 2) {
            return;
        }
        Projection pj = mapView.getProjection();
        while (this.mPointsPrecomputed < size) {
            PointF pt = this.mPoints.get(this.mPointsPrecomputed);
            Projection.toMapPixelsProjected(pt.x, pt.y, pt);
            ++this.mPointsPrecomputed;
        }
        PointF screenPoint0 = null;
        Rect clipBounds = pj.fromPixelsToProjected(pj.getScreenRect());
        this.mPath.rewind();
        boolean needsDrawing = !this.mOptimizePath;
        PointF projectedPoint0 = this.mPoints.get(size - 1);
        this.mLineBounds.set((int)projectedPoint0.x, (int)projectedPoint0.y, (int)projectedPoint0.x, (int)projectedPoint0.y);
        for (int i = size - 2; i >= 0; --i) {
            PointF projectedPoint1 = this.mPoints.get(i);
            this.mLineBounds.union((int)projectedPoint1.x, (int)projectedPoint1.y);
            if (this.mOptimizePath && !Rect.intersects((Rect)clipBounds, (Rect)this.mLineBounds)) {
                projectedPoint0 = projectedPoint1;
                this.mLineBounds.set((int)projectedPoint0.x, (int)projectedPoint0.y, (int)projectedPoint0.x, (int)projectedPoint0.y);
                screenPoint0 = null;
                continue;
            }
            if (screenPoint0 == null) {
                screenPoint0 = pj.toMapPixelsTranslated(projectedPoint0, this.mTempPoint1);
                this.mPath.moveTo(screenPoint0.x, screenPoint0.y);
            }
            PointF screenPoint1 = pj.toMapPixelsTranslated(projectedPoint1, this.mTempPoint2);
            if (Math.abs(screenPoint1.x - screenPoint0.x) + Math.abs(screenPoint1.y - screenPoint0.y) <= 1.0f) continue;
            this.mPath.lineTo(screenPoint1.x, screenPoint1.y);
            projectedPoint0 = projectedPoint1;
            screenPoint0.x = screenPoint1.x;
            screenPoint0.y = screenPoint1.y;
            if (!this.mOptimizePath) continue;
            needsDrawing = true;
            this.mLineBounds.set((int)projectedPoint0.x, (int)projectedPoint0.y, (int)projectedPoint0.x, (int)projectedPoint0.y);
        }
        if (!this.mOptimizePath) {
            needsDrawing = Rect.intersects((Rect)clipBounds, (Rect)this.mLineBounds);
        }
        if (needsDrawing) {
            float realWidth = this.mPaint.getStrokeWidth();
            this.mPaint.setStrokeWidth(realWidth / mapView.getScale());
            canvas.drawPath(this.mPath, this.mPaint);
            this.mPaint.setStrokeWidth(realWidth);
        }
    }

    public void setOptimizePath(boolean value) {
        this.mOptimizePath = value;
    }
}

