/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider.modules;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetworkAvailabilityCheck {
    private final ConnectivityManager mConnectionManager;

    public NetworkAvailabilityCheck(Context aContext) {
        this.mConnectionManager = (ConnectivityManager)aContext.getSystemService("connectivity");
    }

    public boolean getNetworkAvailable() {
        NetworkInfo networkInfo = this.mConnectionManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isAvailable();
    }

    public boolean getWiFiNetworkAvailable() {
        NetworkInfo wifi = this.mConnectionManager.getNetworkInfo(1);
        return wifi != null && wifi.isAvailable();
    }

    public boolean getCellularDataNetworkAvailable() {
        NetworkInfo mobile = this.mConnectionManager.getNetworkInfo(0);
        return mobile != null && mobile.isAvailable();
    }

    public boolean getRouteToPathExists(int hostAddress) {
        return this.mConnectionManager.requestRouteToHost(1, hostAddress) || this.mConnectionManager.requestRouteToHost(0, hostAddress);
    }
}

