/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.exceptions.OfflineDatabaseException;
import com.mapbox.mapboxsdk.geometry.CoordinateRegion;
import com.mapbox.mapboxsdk.geometry.CoordinateSpan;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.offline.OfflineDatabaseManager;
import java.util.Date;

public class OfflineMapDatabase
implements MapboxConstants {
    private static final String TAG = "OfflineMapDatabase";
    private Context context;
    private String uniqueID;
    private String mapID;
    private boolean includesMetadata;
    private boolean includesMarkers;
    private MapboxConstants.RasterImageQuality imageQuality;
    private CoordinateRegion mapRegion;
    private Integer minimumZ;
    private Integer maximumZ;
    private String path;
    private boolean invalid;
    private boolean initializedProperly = false;

    public OfflineMapDatabase(Context context) {
        this.context = context;
    }

    public OfflineMapDatabase(Context context, String mapID) {
        this.context = context;
        this.mapID = mapID;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public String getMapID() {
        return this.mapID;
    }

    public String getPath() {
        return this.path;
    }

    public MapboxConstants.RasterImageQuality getImageQuality() {
        return this.imageQuality;
    }

    public boolean initializeDatabase() {
        String uniqueID = this.sqliteMetadataForName("uniqueID");
        String mapID = this.sqliteMetadataForName("mapID");
        String includesMetadata = this.sqliteMetadataForName("includesMetadata");
        String includesMarkers = this.sqliteMetadataForName("includesMarkers");
        String imageQuality = this.sqliteMetadataForName("imageQuality");
        String region_latitude = this.sqliteMetadataForName("region_latitude");
        String region_longitude = this.sqliteMetadataForName("region_longitude");
        String region_latitude_delta = this.sqliteMetadataForName("region_latitude_delta");
        String region_longitude_delta = this.sqliteMetadataForName("region_longitude_delta");
        String minimumZ = this.sqliteMetadataForName("minimumZ");
        String maximumZ = this.sqliteMetadataForName("maximumZ");
        if (TextUtils.isEmpty((CharSequence)uniqueID)) {
            uniqueID = String.format(MAPBOX_LOCALE, "%s-%s-%s-%s-%s-%s-%s-%d", mapID, region_latitude, region_longitude, region_latitude_delta, region_longitude_delta, minimumZ, maximumZ, new Date().getTime() / 1000L);
        }
        if (!(TextUtils.isEmpty((CharSequence)mapID) || TextUtils.isEmpty((CharSequence)includesMetadata) || TextUtils.isEmpty((CharSequence)includesMarkers) || TextUtils.isEmpty((CharSequence)imageQuality) || TextUtils.isEmpty((CharSequence)region_latitude) || TextUtils.isEmpty((CharSequence)region_longitude) || TextUtils.isEmpty((CharSequence)region_latitude_delta) || TextUtils.isEmpty((CharSequence)region_longitude_delta) || TextUtils.isEmpty((CharSequence)minimumZ) || TextUtils.isEmpty((CharSequence)maximumZ))) {
            this.uniqueID = uniqueID;
            this.mapID = mapID;
            this.includesMetadata = "YES".equalsIgnoreCase(includesMetadata);
            this.includesMarkers = "YES".equalsIgnoreCase(includesMarkers);
            this.imageQuality = MapboxConstants.RasterImageQuality.getEnumForValue(Integer.parseInt(imageQuality));
            LatLng center = new LatLng(Double.parseDouble(region_latitude), Double.parseDouble(region_longitude));
            CoordinateSpan span = new CoordinateSpan(Double.parseDouble(region_latitude_delta), Double.parseDouble(region_longitude_delta));
            this.mapRegion = new CoordinateRegion(center, span);
            this.minimumZ = Integer.parseInt(minimumZ);
            this.maximumZ = Integer.parseInt(maximumZ);
            SQLiteDatabase db = OfflineDatabaseManager.getOfflineDatabaseManager(this.context).getOfflineDatabaseHandlerForMapId(mapID).getReadableDatabase();
            this.path = db.getPath();
            db.close();
            this.initializedProperly = true;
        } else {
            Log.w((String)TAG, (String)"Invalid offline map database.  Can't be used.");
        }
        return this.initializedProperly;
    }

    public byte[] dataForURL(String url) throws OfflineDatabaseException {
        byte[] data = this.sqliteDataForURL(url);
        return data;
    }

    public void invalidate() {
        this.invalid = false;
    }

    public String sqliteMetadataForName(String name) {
        if (this.mapID == null) {
            return null;
        }
        String query = "SELECT value FROM metadata WHERE name='" + name + "';";
        SQLiteDatabase db = OfflineDatabaseManager.getOfflineDatabaseManager(this.context).getOfflineDatabaseHandlerForMapId(this.mapID).getReadableDatabase();
        Cursor cursor = db.rawQuery(query, null);
        if (cursor != null && cursor.moveToFirst()) {
            String res = cursor.getString(cursor.getColumnIndex("value"));
            cursor.close();
            db.close();
            return res;
        }
        return null;
    }

    public byte[] sqliteDataForURL(String url) {
        String query;
        if (this.mapID == null) {
            return null;
        }
        SQLiteDatabase db = OfflineDatabaseManager.getOfflineDatabaseManager(this.context).getOfflineDatabaseHandlerForMapId(this.mapID).getReadableDatabase();
        Cursor cursor = db.rawQuery(query = "SELECT value FROM data WHERE id= (SELECT id from resources where url = '" + url + "');", null);
        if (cursor != null && cursor.moveToFirst()) {
            byte[] blob = cursor.getBlob(cursor.getColumnIndex("value"));
            cursor.close();
            db.close();
            return blob;
        }
        db.close();
        return null;
    }
}

