/*
 * Decompiled with CFR 0.152.
 */
package com.spatialdev.osm.model;

import android.util.Xml;
import com.spatialdev.osm.model.OSMElement;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import org.xmlpull.v1.XmlSerializer;

public class OSMXmlWriter {
    private static final String OSM_API_VERSION = "0.6";
    private static final String GENERATOR = "OpenMapKit 0.1";
    private static final String ns = null;
    private LinkedList<OSMElement> elements;
    private XmlSerializer xmlSerializer;
    StringWriter stringWriter;

    public static String elementToString(OSMElement element, String osmUser) throws IOException {
        LinkedList<OSMElement> elements = null;
        if (element != null) {
            elements = new LinkedList<OSMElement>();
            elements.add(element);
        }
        return OSMXmlWriter.elementsToString(elements, osmUser);
    }

    public static String elementsToString(LinkedList<OSMElement> elements, String osmUser) throws IOException {
        OSMXmlWriter writer = new OSMXmlWriter(elements);
        writer.start(osmUser);
        if (elements != null) {
            writer.iterateElements(elements);
        }
        return writer.end();
    }

    private OSMXmlWriter(LinkedList<OSMElement> elements) {
        this.elements = elements;
        this.xmlSerializer = Xml.newSerializer();
        this.stringWriter = new StringWriter();
    }

    private void start(String osmUser) throws IOException {
        this.xmlSerializer.setOutput((Writer)this.stringWriter);
        this.xmlSerializer.startDocument("UTF-8", null);
        this.xmlSerializer.startTag(ns, "osm");
        this.xmlSerializer.attribute(ns, "version", OSM_API_VERSION);
        this.xmlSerializer.attribute(ns, "generator", GENERATOR);
        this.xmlSerializer.attribute(ns, "user", osmUser);
    }

    private String end() throws IOException {
        this.xmlSerializer.endTag(ns, "osm");
        this.xmlSerializer.endDocument();
        return this.stringWriter.toString();
    }

    private void iterateElements(LinkedList<OSMElement> elements) throws IOException {
        for (OSMElement element : elements) {
            element.xml(this.xmlSerializer);
        }
    }
}

