/*
 * Decompiled with CFR 0.152.
 */
package com.spatialdev.osm.model;

import com.mapbox.mapboxsdk.api.ILatLng;
import com.spatialdev.osm.model.OSMDataSet;
import com.spatialdev.osm.model.OSMElement;
import com.spatialdev.osm.model.OSMNode;
import com.spatialdev.osm.model.OSMWay;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.List;

public class JTSModel {
    private static final int TAP_PIXEL_TOLERANCE = 24;
    private ArrayList<OSMDataSet> dataSets;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private STRtree rtree = new STRtree();

    public JTSModel(OSMDataSet ds) {
        this();
        this.addOSMDataSet(ds);
    }

    public JTSModel() {
        this.dataSets = new ArrayList();
    }

    public void addOSMDataSet(OSMDataSet ds) {
        this.dataSets.add(ds);
        this.addOSMClosedWays(ds);
        this.addOSMOpenWays(ds);
        this.addOSMStandaloneNodes(ds);
    }

    public Envelope createTapEnvelope(ILatLng latLng, float zoom) {
        return this.createTapEnvelope(latLng.getLatitude(), latLng.getLongitude(), zoom);
    }

    public Envelope createTapEnvelope(double lat, double lng, float zoom) {
        Coordinate coord = new Coordinate(lng, lat);
        return this.createTapEnvelope(coord, lat, lng, zoom);
    }

    public List<OSMElement> queryFromEnvelope(Envelope envelope) {
        List results = this.rtree.query(envelope);
        return results;
    }

    public OSMElement queryFromTap(ILatLng latLng, float zoom) {
        double lat = latLng.getLatitude();
        double lng = latLng.getLongitude();
        Coordinate coord = new Coordinate(lng, lat);
        Envelope envelope = this.createTapEnvelope(coord, lat, lng, zoom);
        List results = this.rtree.query(envelope);
        int len = results.size();
        if (len == 0) {
            return null;
        }
        if (len == 1) {
            return (OSMElement)results.get(0);
        }
        Point clickPoint = this.geometryFactory.createPoint(coord);
        OSMElement closestElement = null;
        double closestDist = Double.POSITIVE_INFINITY;
        for (Object res : results) {
            OSMElement el = (OSMElement)res;
            if (closestElement == null) {
                closestElement = el;
                closestDist = el.getJTSGeom().distance((Geometry)clickPoint);
                continue;
            }
            Geometry geom = el.getJTSGeom();
            double dist = geom.distance((Geometry)clickPoint);
            if (dist > closestDist) continue;
            if (dist < closestDist) {
                closestElement = el;
                closestDist = dist;
                continue;
            }
            closestElement = this.prioritizeElementByType(closestElement, el);
        }
        return closestElement;
    }

    private Envelope createTapEnvelope(Coordinate coord, double lat, double lng, float zoom) {
        Envelope envelope = new Envelope(coord);
        double degreesLngPerPixel = JTSModel.degreesLngPerPixel(zoom);
        double deltaX = degreesLngPerPixel * 24.0;
        double deltaY = JTSModel.scaledLatDeltaForMercator(deltaX, lat);
        envelope.expandBy(deltaX, deltaY);
        return envelope;
    }

    private OSMElement prioritizeElementByType(OSMElement el1, OSMElement el2) {
        if (el1 instanceof OSMNode) {
            return el1;
        }
        if (el2 instanceof OSMNode) {
            return el2;
        }
        if (!((OSMWay)el1).isClosed()) {
            return el1;
        }
        return el2;
    }

    private void addOSMClosedWays(OSMDataSet ds) {
        List<OSMWay> closedWays = ds.getClosedWays();
        for (OSMWay closedWay : closedWays) {
            List<OSMNode> nodes = closedWay.getNodes();
            Coordinate[] coords = this.coordArrayFromNodeList(nodes);
            Polygon poly = this.geometryFactory.createPolygon(coords);
            closedWay.setJTSGeom((Geometry)poly);
            Envelope envelope = poly.getEnvelopeInternal();
            this.rtree.insert(envelope, (Object)closedWay);
        }
    }

    private void addOSMOpenWays(OSMDataSet ds) {
        List<OSMWay> openWays = ds.getOpenWays();
        for (OSMWay w : openWays) {
            List<OSMNode> nodes = w.getNodes();
            Coordinate[] coords = this.coordArrayFromNodeList(nodes);
            LineString line = this.geometryFactory.createLineString(coords);
            w.setJTSGeom((Geometry)line);
            Envelope envelope = line.getEnvelopeInternal();
            this.rtree.insert(envelope, (Object)w);
        }
    }

    private Coordinate[] coordArrayFromNodeList(List<OSMNode> nodes) {
        Coordinate[] coords = new Coordinate[nodes.size()];
        int i = 0;
        for (OSMNode node : nodes) {
            double lat = node.getLat();
            double lng = node.getLng();
            Coordinate coord = new Coordinate(lng, lat);
            coords[i++] = coord;
        }
        return coords;
    }

    private void addOSMStandaloneNodes(OSMDataSet ds) {
        List<OSMNode> standaloneNodes = ds.getStandaloneNodes();
        for (OSMNode n : standaloneNodes) {
            double lat = n.getLat();
            double lng = n.getLng();
            Coordinate coord = new Coordinate(lng, lat);
            Point point = this.geometryFactory.createPoint(coord);
            n.setJTSGeom((Geometry)point);
            Envelope envelope = point.getEnvelopeInternal();
            this.rtree.insert(envelope, (Object)n);
        }
    }

    private static double degreesLngPerPixel(float zoom) {
        double degreesPerTile = 360.0 / Math.pow(2.0, zoom);
        return degreesPerTile / 256.0;
    }

    private static double scaledLatDeltaForMercator(double deltaDeg, double lat) {
        double scale = 1.0 / Math.cos(Math.toRadians(lat));
        return deltaDeg / scale;
    }
}

