/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.exceptions.OfflineDatabaseException;
import com.mapbox.mapboxsdk.offline.OfflineMapDatabase;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.MapTileLayerBase;
import com.mapbox.mapboxsdk.util.MapboxUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class OfflineMapTileProvider
extends MapTileLayerBase
implements MapboxConstants {
    private static final String TAG = "OfflineMapTileProvider";
    private OfflineMapDatabase offlineMapDatabase = null;

    public OfflineMapTileProvider(Context context, OfflineMapDatabase offlineMapDatabase) {
        super(context, null);
        this.offlineMapDatabase = offlineMapDatabase;
    }

    @Override
    public Drawable getMapTile(MapTile pTile, boolean allowRemote) {
        try {
            String url = MapboxUtils.getMapTileURL(this.context, this.offlineMapDatabase.getMapID(), pTile.getZ(), pTile.getX(), pTile.getY(), this.offlineMapDatabase.getImageQuality());
            byte[] data = this.offlineMapDatabase.dataForURL(url);
            if (data == null || data.length == 0) {
                return null;
            }
            return new BitmapDrawable(this.context.getResources(), (InputStream)new ByteArrayInputStream(data));
        }
        catch (OfflineDatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void detach() {
        if (this.getTileSource() != null) {
            this.getTileSource().detach();
        }
    }
}

