/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.util.Log;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.MapTileCache;
import com.mapbox.mapboxsdk.tileprovider.MapTileRequestState;
import com.mapbox.mapboxsdk.tileprovider.modules.MapTileModuleLayerBase;
import com.mapbox.mapboxsdk.tileprovider.modules.NetworkAvailabilityCheck;
import com.mapbox.mapboxsdk.tileprovider.tilesource.ITileLayer;
import com.mapbox.mapboxsdk.tileprovider.tilesource.MBTilesLayer;
import com.mapbox.mapboxsdk.tileprovider.tilesource.TileLayer;
import com.mapbox.mapboxsdk.util.AppUtils;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.util.TileLoadedListener;
import com.mapbox.mapboxsdk.views.util.TilesLoadedListener;
import java.util.concurrent.atomic.AtomicReference;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public class MapTileDownloader
extends MapTileModuleLayerBase {
    private static final String TAG = "MapTileDownloader";
    private final AtomicReference<TileLayer> mTileSource = new AtomicReference();
    private final AtomicReference<MapTileCache> mTileCache = new AtomicReference();
    private final NetworkAvailabilityCheck mNetworkAvailabilityCheck;
    private MapView mMapView;
    private boolean mUseDataConnection;
    boolean hdpi;

    public MapTileDownloader(ITileLayer pTileSource, MapTileCache pTileCache, NetworkAvailabilityCheck pNetworkAvailabilityCheck, MapView mapView) {
        super(8, 40);
        this.mMapView = mapView;
        this.mUseDataConnection = true;
        if (pTileSource instanceof MBTilesLayer) {
            this.mUseDataConnection = false;
        }
        this.mTileCache.set(pTileCache);
        this.hdpi = AppUtils.isRunningOn2xOrGreaterScreen(mapView.getContext());
        Log.d((String)TAG, (String)String.format("Going to use @2x tiles? '%b'", this.hdpi));
        this.mNetworkAvailabilityCheck = pNetworkAvailabilityCheck;
        this.setTileSource(pTileSource);
    }

    @Override
    public ITileLayer getTileSource() {
        return this.mTileSource.get();
    }

    public MapTileCache getCache() {
        return this.mTileCache.get();
    }

    public boolean isNetworkAvailable() {
        return this.mNetworkAvailabilityCheck == null || this.mNetworkAvailabilityCheck.getNetworkAvailable();
    }

    public TilesLoadedListener getTilesLoadedListener() {
        return this.mMapView.getTilesLoadedListener();
    }

    public TileLoadedListener getTileLoadedListener() {
        return this.mMapView.getTileLoadedListener();
    }

    @Override
    public boolean getUsesDataConnection() {
        return this.mUseDataConnection;
    }

    @Override
    protected String getName() {
        return "Online Tile Download Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "downloader";
    }

    @Override
    protected Runnable getTileLoader() {
        return new TileLoader();
    }

    @Override
    public float getMinimumZoomLevel() {
        TileLayer tileLayer = this.mTileSource.get();
        return tileLayer != null ? tileLayer.getMinimumZoomLevel() : 0.0f;
    }

    @Override
    public float getMaximumZoomLevel() {
        TileLayer tileLayer = this.mTileSource.get();
        return tileLayer != null ? tileLayer.getMaximumZoomLevel() : 22.0f;
    }

    @Override
    public BoundingBox getBoundingBox() {
        TileLayer tileLayer = this.mTileSource.get();
        return tileLayer != null ? tileLayer.getBoundingBox() : null;
    }

    @Override
    public LatLng getCenterCoordinate() {
        TileLayer tileLayer = this.mTileSource.get();
        return tileLayer != null ? tileLayer.getCenterCoordinate() : null;
    }

    @Override
    public float getCenterZoom() {
        TileLayer tileLayer = this.mTileSource.get();
        return tileLayer != null ? tileLayer.getCenterZoom() : (this.getMaximumZoomLevel() + this.getMinimumZoomLevel()) / 2.0f;
    }

    @Override
    public int getTileSizePixels() {
        TileLayer tileLayer = this.mTileSource.get();
        return tileLayer != null ? tileLayer.getTileSizePixels() : 0;
    }

    @Override
    public void setTileSource(ITileLayer tileSource) {
        if (this.mTileSource.get() != null) {
            this.mTileSource.get().detach();
        }
        if (tileSource instanceof TileLayer) {
            this.mTileSource.set((TileLayer)tileSource);
        } else {
            this.mTileSource.set(null);
        }
    }

    @Override
    public String getCacheKey() {
        TileLayer tileLayer = this.mTileSource.get();
        return tileLayer != null ? tileLayer.getCacheKey() : "";
    }

    private CacheableBitmapDrawable onTileLoaded(CacheableBitmapDrawable pDrawable) {
        return this.mMapView.getTileLoadedListener().onTileLoaded(pDrawable);
    }

    protected class TileLoader
    extends MapTileModuleLayerBase.TileLoader {
        protected TileLoader() {
            super(MapTileDownloader.this);
        }

        @Override
        public Drawable loadTile(MapTileRequestState aState) throws MapTileModuleLayerBase.CantContinueException {
            MapTile tile = aState.getMapTile();
            Log.d((String)MapTileDownloader.TAG, (String)("loadTile() with tile = '" + tile + "'"));
            if (MapTileDownloader.this.mTileCache != null && ((MapTileCache)MapTileDownloader.this.mTileCache.get()).containsTileInDiskCache(tile)) {
                Log.d((String)MapTileDownloader.TAG, (String)("tile found in Disk Cache, so returning it. tile = '" + tile + "'"));
                return ((MapTileCache)MapTileDownloader.this.mTileCache.get()).getMapTileFromDisk(tile);
            }
            TileLayer tileLayer = (TileLayer)MapTileDownloader.this.mTileSource.get();
            Drawable result = tileLayer != null ? tileLayer.getDrawableFromTile(MapTileDownloader.this, tile, MapTileDownloader.this.hdpi) : null;
            Log.d((String)MapTileDownloader.TAG, (String)("tileLayer.getDrawable() returning result = '" + result + "'"));
            return result;
        }
    }
}

