/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import com.mapbox.mapboxsdk.overlay.Marker;
import com.mapbox.mapboxsdk.overlay.Overlay;
import com.mapbox.mapboxsdk.overlay.SafeDrawOverlay;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.safecanvas.ISafeCanvas;
import com.mapbox.mapboxsdk.views.safecanvas.SafePaint;
import com.mapbox.mapboxsdk.views.util.Projection;
import java.util.ArrayList;

public abstract class ItemizedOverlay
extends SafeDrawOverlay
implements Overlay.Snappable {
    private final ArrayList<Marker> mInternalItemList;
    protected boolean mDrawFocusedItem = true;
    private Marker mFocusedItem;
    private boolean mPendingFocusChangedEvent = false;
    private OnFocusChangeListener mOnFocusChangeListener;
    private static SafePaint mClusterTextPaint;

    protected abstract Marker createItem(int var1);

    public abstract int size();

    public ItemizedOverlay() {
        if (mClusterTextPaint == null) {
            mClusterTextPaint = new SafePaint();
            mClusterTextPaint.setTextAlign(Paint.Align.CENTER);
            mClusterTextPaint.setTextSize(30.0f);
            mClusterTextPaint.setFakeBoldText(true);
        }
        this.mInternalItemList = new ArrayList();
    }

    @Override
    protected void drawSafe(ISafeCanvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (this.mPendingFocusChangedEvent && this.mOnFocusChangeListener != null) {
            this.mOnFocusChangeListener.onFocusChanged(this, this.mFocusedItem);
        }
        this.mPendingFocusChangedEvent = false;
        Projection pj = mapView.getProjection();
        int size = this.mInternalItemList.size() - 1;
        RectF bounds = new RectF(0.0f, 0.0f, (float)mapView.getMeasuredWidth(), (float)mapView.getMeasuredHeight());
        pj.rotateRect(bounds);
        float mapScale = 1.0f / mapView.getScale();
        for (int i = size; i >= 0; --i) {
            Marker item = this.getItem(i);
            if (item == this.mFocusedItem) continue;
            this.onDrawItem(canvas, item, pj, mapView.getMapOrientation(), bounds, mapScale);
        }
        if (this.mFocusedItem != null) {
            this.onDrawItem(canvas, this.mFocusedItem, pj, mapView.getMapOrientation(), bounds, mapScale);
        }
    }

    protected void populate() {
        int size = this.size();
        this.mInternalItemList.clear();
        this.mInternalItemList.ensureCapacity(size);
        for (int a = 0; a < size; ++a) {
            this.mInternalItemList.add(this.createItem(a));
        }
    }

    public final Marker getItem(int position) {
        return this.mInternalItemList.get(position);
    }

    protected void onDrawItem(ISafeCanvas canvas, Marker item, Projection projection, final float aMapOrientation, RectF mapBounds, float mapScale) {
        item.updateDrawingPosition();
        PointF position = item.getPositionOnMap();
        final Point roundedCoords = new Point((int)position.x, (int)position.y);
        if (!RectF.intersects((RectF)mapBounds, (RectF)item.getDrawingBounds(projection, null))) {
            return;
        }
        canvas.save();
        canvas.scale(mapScale, mapScale, position.x, position.y);
        int state = this.mDrawFocusedItem && this.mFocusedItem == item ? 4 : 0;
        final BitmapDrawable marker = (BitmapDrawable)item.getMarker(state);
        if (marker == null) {
            return;
        }
        final Point point = item.getAnchor();
        if (this.isUsingSafeCanvas()) {
            Overlay.drawAt(canvas.getSafeCanvas(), (Drawable)marker, roundedCoords, point, false, aMapOrientation);
        } else {
            canvas.getUnsafeCanvas(new ISafeCanvas.UnsafeCanvasHandler(){

                @Override
                public void onUnsafeCanvas(Canvas canvas) {
                    Overlay.drawAt(canvas, (Drawable)marker, roundedCoords, point, false, aMapOrientation);
                }
            });
        }
        canvas.restore();
    }

    protected boolean markerHitTest(Marker pMarker, Projection pProjection, float pX, float pY) {
        RectF rect = pMarker.getHitBounds(pProjection, null);
        return rect.contains(pX, pY);
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent e, MapView mapView) {
        int size = this.size();
        Projection projection = mapView.getProjection();
        float x = e.getX();
        float y = e.getY();
        for (int i = 0; i < size; ++i) {
            Marker item = this.getItem(i);
            if (!this.markerHitTest(item, projection, x, y) || !this.onTap(i)) continue;
            return true;
        }
        return super.onSingleTapConfirmed(e, mapView);
    }

    protected boolean onTap(int index) {
        return false;
    }

    public void setDrawFocusedItem(boolean drawFocusedItem) {
        this.mDrawFocusedItem = drawFocusedItem;
    }

    public void setFocus(Marker item) {
        this.mPendingFocusChangedEvent = item != this.mFocusedItem;
        this.mFocusedItem = item;
    }

    public Marker getFocus() {
        return this.mFocusedItem;
    }

    public void blurItem(Marker item) {
        if (this.mFocusedItem == item) {
            this.setFocus(null);
        }
    }

    public void setOnFocusChangeListener(OnFocusChangeListener l) {
        this.mOnFocusChangeListener = l;
    }

    public static interface OnFocusChangeListener {
        public void onFocusChanged(ItemizedOverlay var1, Marker var2);
    }
}

